/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.ext;

import com.alipay.sofa.rpc.base.Sortable;
import com.alipay.sofa.rpc.common.utils.ClassUtils;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import java.util.Arrays;

public class ExtensionClass<T>
implements Sortable {
    protected final Class<? extends T> clazz;
    protected final String alias;
    protected byte code;
    protected boolean singleton;
    protected int order;
    protected boolean override;
    protected String[] rejection;
    private volatile transient T instance;

    public ExtensionClass(Class<? extends T> clazz, String alias) {
        this.clazz = clazz;
        this.alias = alias;
    }

    public T getExtInstance() {
        return this.getExtInstance(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getExtInstance(Class[] argTypes, Object[] args) {
        if (this.clazz != null) {
            try {
                if (this.singleton) {
                    if (this.instance == null) {
                        ExtensionClass extensionClass = this;
                        synchronized (extensionClass) {
                            if (this.instance == null) {
                                this.instance = ClassUtils.newInstanceWithArgs(this.clazz, argTypes, args);
                            }
                        }
                    }
                    return this.instance;
                }
                return ClassUtils.newInstanceWithArgs(this.clazz, argTypes, args);
            }
            catch (Exception e) {
                throw new SofaRpcRuntimeException("create " + this.clazz.getCanonicalName() + " instance error", e);
            }
        }
        throw new SofaRpcRuntimeException("Class of ExtensionClass is null");
    }

    public String getAlias() {
        return this.alias;
    }

    public byte getCode() {
        return this.code;
    }

    public ExtensionClass setCode(byte code) {
        this.code = code;
        return this;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public Class<? extends T> getClazz() {
        return this.clazz;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public ExtensionClass setOrder(int order) {
        this.order = order;
        return this;
    }

    public boolean isOverride() {
        return this.override;
    }

    public ExtensionClass setOverride(boolean override) {
        this.override = override;
        return this;
    }

    public String[] getRejection() {
        return this.rejection;
    }

    public ExtensionClass setRejection(String[] rejection) {
        this.rejection = rejection;
        return this;
    }

    public String toString() {
        return "ExtensionClass{clazz=" + this.clazz + ", alias='" + this.alias + '\'' + ", code=" + this.code + ", singleton=" + this.singleton + ", order=" + this.order + ", override=" + this.override + ", rejection=" + Arrays.toString(this.rejection) + ", instance=" + this.instance + '}';
    }
}

