/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry;

import com.alipay.sofa.rpc.common.utils.ExceptionUtils;
import com.alipay.sofa.rpc.config.RegistryConfig;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.ext.ExtensionClass;
import com.alipay.sofa.rpc.ext.ExtensionLoaderFactory;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.registry.Registry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class RegistryFactory {
    private static final ConcurrentMap<RegistryConfig, Registry> ALL_REGISTRIES = new ConcurrentHashMap<RegistryConfig, Registry>();
    private static final Logger LOGGER = LoggerFactory.getLogger(RegistryFactory.class);

    public static synchronized Registry getRegistry(RegistryConfig registryConfig) {
        if (ALL_REGISTRIES.size() > 3 && LOGGER.isWarnEnabled()) {
            LOGGER.warn("Size of registry is greater than 3, Please check it!");
        }
        try {
            Registry registry = (Registry)ALL_REGISTRIES.get(registryConfig);
            if (registry == null) {
                ExtensionClass<Registry> ext = ExtensionLoaderFactory.getExtensionLoader(Registry.class).getExtensionClass(registryConfig.getProtocol());
                if (ext == null) {
                    throw ExceptionUtils.buildRuntime("registry.protocol", registryConfig.getProtocol(), "Unsupported protocol of registry config !");
                }
                registry = ext.getExtInstance(new Class[]{RegistryConfig.class}, new Object[]{registryConfig});
                ALL_REGISTRIES.put(registryConfig, registry);
            }
            return registry;
        }
        catch (SofaRpcRuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SofaRpcRuntimeException(e.getMessage(), e);
        }
    }

    public static List<RegistryConfig> getRegistryConfigs() {
        return new ArrayList<RegistryConfig>(ALL_REGISTRIES.keySet());
    }

    public static List<Registry> getRegistries() {
        return new ArrayList<Registry>(ALL_REGISTRIES.values());
    }

    public static void destroyAll() {
        for (Map.Entry entry : ALL_REGISTRIES.entrySet()) {
            RegistryConfig config = (RegistryConfig)entry.getKey();
            Registry registry = (Registry)entry.getValue();
            try {
                registry.destroy();
                ALL_REGISTRIES.remove(config);
            }
            catch (Exception e) {
                LOGGER.error("Error when destroy registry :" + config + ", but you can ignore if it's called by JVM shutdown hook", e);
            }
        }
    }
}

