/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.mesh;

import com.alipay.sofa.rpc.client.ProviderGroup;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.struct.NamedThreadFactory;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.RegistryConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.event.ConsumerSubEvent;
import com.alipay.sofa.rpc.event.EventBus;
import com.alipay.sofa.rpc.event.ProviderPubEvent;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.listener.ProviderInfoListener;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.registry.Registry;
import com.alipay.sofa.rpc.registry.mesh.MeshRegistryHelper;
import com.alipay.sofa.rpc.registry.mesh.SofaRegistryHelper;
import com.alipay.sofa.rpc.registry.mesh.client.MeshApiClient;
import com.alipay.sofa.rpc.registry.mesh.model.ApplicationInfoRequest;
import com.alipay.sofa.rpc.registry.mesh.model.ProviderMetaInfo;
import com.alipay.sofa.rpc.registry.mesh.model.PublishServiceRequest;
import com.alipay.sofa.rpc.registry.mesh.model.SubscribeServiceRequest;
import com.alipay.sofa.rpc.registry.mesh.model.SubscribeServiceResult;
import com.alipay.sofa.rpc.registry.mesh.model.UnPublishServiceRequest;
import com.alipay.sofa.rpc.registry.mesh.model.UnSubscribeServiceRequest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@Extension(value="mesh")
public class MeshRegistry
extends Registry {
    private static final Logger LOGGER = LoggerFactory.getLogger(MeshRegistry.class);
    private static final String VERSION = "4.0";
    protected MeshApiClient client;
    protected boolean inited;
    protected boolean registedApp;
    protected static ThreadPoolExecutor asyncCreateConnectionExecutor = MeshRegistry.initThreadPoolExecutor();

    private static ThreadPoolExecutor initThreadPoolExecutor() {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(20, 20, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(5000), new NamedThreadFactory("Mesh-Async-Registry", true));
        threadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        return threadPoolExecutor;
    }

    protected MeshRegistry(RegistryConfig registryConfig) {
        super(registryConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        Class<MeshRegistry> clazz = MeshRegistry.class;
        synchronized (MeshRegistry.class) {
            if (!this.inited) {
                String address = this.registryConfig.getAddress();
                this.client = new MeshApiClient(address);
                this.inited = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean start() {
        return true;
    }

    @Override
    public void register(ProviderConfig config) {
        String appName = config.getAppName();
        if (!this.registryConfig.isRegister()) {
            if (LOGGER.isInfoEnabled(appName)) {
                LOGGER.infoWithApp(appName, LogCodes.getLog("00208"));
            }
            return;
        }
        if (!config.isRegister()) {
            return;
        }
        List<ServerConfig> serverConfigs = config.getServer();
        if (CommonUtils.isNotEmpty(serverConfigs)) {
            for (ServerConfig server : serverConfigs) {
                String serviceName = MeshRegistryHelper.buildMeshKey(config, server.getProtocol());
                ProviderInfo providerInfo = MeshRegistryHelper.convertProviderToProviderInfo(config, server);
                if (LOGGER.isInfoEnabled(appName)) {
                    LOGGER.infoWithApp(appName, LogCodes.getLog("00205", serviceName));
                }
                this.doRegister(appName, serviceName, providerInfo, server.getProtocol());
                if (!LOGGER.isInfoEnabled(appName)) continue;
                LOGGER.infoWithApp(appName, LogCodes.getLog("00206", serviceName));
            }
            if (EventBus.isEnable(ProviderPubEvent.class)) {
                ProviderPubEvent event = new ProviderPubEvent(config);
                EventBus.post(event);
            }
        }
    }

    protected void doRegister(final String appName, final String serviceName, final ProviderInfo providerInfo, final String protocol) {
        asyncCreateConnectionExecutor.execute(new Runnable(){

            @Override
            public void run() {
                MeshRegistry.this.registerAppInfoOnce(appName);
                if (LOGGER.isInfoEnabled(appName)) {
                    LOGGER.infoWithApp(appName, LogCodes.getLog("00201", serviceName));
                }
                PublishServiceRequest publishServiceRequest = MeshRegistry.this.buildPublishServiceRequest(serviceName, protocol, providerInfo, appName);
                MeshRegistry.this.client.publishService(publishServiceRequest);
            }
        });
    }

    protected PublishServiceRequest buildPublishServiceRequest(String serviceName, String protocol, ProviderInfo providerInfo, String appName) {
        PublishServiceRequest publishServiceRequest = new PublishServiceRequest();
        publishServiceRequest.setServiceName(serviceName);
        publishServiceRequest.setProtocolType(protocol);
        ProviderMetaInfo providerMetaInfo = new ProviderMetaInfo();
        providerMetaInfo.setProtocol(providerInfo.getProtocolType());
        providerMetaInfo.setSerializeType(providerInfo.getSerializationType());
        providerMetaInfo.setAppName(appName);
        providerMetaInfo.setVersion(VERSION);
        providerMetaInfo.setProperties(providerInfo.getStaticAttrs());
        publishServiceRequest.setProviderMetaInfo(providerMetaInfo);
        return publishServiceRequest;
    }

    @Override
    public void unRegister(ProviderConfig config) {
        String appName = config.getAppName();
        if (!this.registryConfig.isRegister()) {
            if (LOGGER.isInfoEnabled(appName)) {
                LOGGER.infoWithApp(appName, LogCodes.getLog("00208"));
            }
            return;
        }
        if (!config.isRegister()) {
            return;
        }
        List<ServerConfig> serverConfigs = config.getServer();
        if (CommonUtils.isNotEmpty(serverConfigs)) {
            for (ServerConfig server : serverConfigs) {
                String serviceName = MeshRegistryHelper.buildMeshKey(config, server.getProtocol());
                ProviderInfo providerInfo = MeshRegistryHelper.convertProviderToProviderInfo(config, server);
                try {
                    this.doUnRegister(serviceName, providerInfo);
                    if (!LOGGER.isInfoEnabled(appName)) continue;
                    LOGGER.infoWithApp(appName, LogCodes.getLog("00203", serviceName, "1"));
                }
                catch (Exception e) {
                    LOGGER.errorWithApp(appName, LogCodes.getLog("00203", serviceName, "0"), e);
                }
            }
        }
    }

    protected void doUnRegister(String serviceName, ProviderInfo providerInfo) {
        UnPublishServiceRequest unPublishServiceRequest = new UnPublishServiceRequest();
        unPublishServiceRequest.setServiceName(serviceName);
        this.client.unPublishService(unPublishServiceRequest);
    }

    @Override
    public void batchUnRegister(List<ProviderConfig> configs) {
        for (ProviderConfig config : configs) {
            String appName = config.getAppName();
            try {
                this.unRegister(config);
            }
            catch (Exception e) {
                LOGGER.errorWithApp(appName, "Error when batch unregistry", e);
            }
        }
    }

    @Override
    public List<ProviderGroup> subscribe(final ConsumerConfig config) {
        final ProviderInfoListener providerInfoListener = config.getProviderInfoListener();
        asyncCreateConnectionExecutor.execute(new Runnable(){

            @Override
            public void run() {
                String appName = config.getAppName();
                MeshRegistry.this.registerAppInfoOnce(appName);
                SubscribeServiceRequest subscribeRequest = MeshRegistry.this.buildSubscribeServiceRequest(config);
                SubscribeServiceResult subscribeServiceResult = MeshRegistry.this.client.subscribeService(subscribeRequest);
                if (subscribeServiceResult == null || !subscribeServiceResult.isSuccess()) {
                    throw new RuntimeException("regist consumer occors error," + subscribeRequest);
                }
                ArrayList<ProviderGroup> providerGroups = new ArrayList<ProviderGroup>();
                ProviderGroup providerGroup = new ProviderGroup();
                ArrayList<ProviderInfo> providerInfos = new ArrayList<ProviderInfo>();
                String url = MeshRegistry.this.fillProtocolAndVersion(subscribeServiceResult, MeshRegistry.this.client.getHost(), "", config.getProtocol());
                ProviderInfo providerInfo = SofaRegistryHelper.parseProviderInfo(url);
                providerInfos.add(providerInfo);
                providerGroup.setProviderInfos(providerInfos);
                providerGroups.add(providerGroup);
                if (EventBus.isEnable(ConsumerSubEvent.class)) {
                    ConsumerSubEvent event = new ConsumerSubEvent(config);
                    EventBus.post(event);
                }
                if (providerInfoListener != null) {
                    providerInfoListener.updateAllProviders(providerGroups);
                }
            }
        });
        return null;
    }

    protected SubscribeServiceRequest buildSubscribeServiceRequest(ConsumerConfig consumerConfig) {
        String key = MeshRegistryHelper.buildMeshKey(consumerConfig, consumerConfig.getProtocol());
        SubscribeServiceRequest subscribeRequest = new SubscribeServiceRequest();
        subscribeRequest.setServiceName(key);
        return subscribeRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerAppInfoOnce(String appName) {
        Class<MeshRegistry> clazz = MeshRegistry.class;
        synchronized (MeshRegistry.class) {
            if (!this.registedApp) {
                ApplicationInfoRequest applicationInfoRequest = this.buildApplicationRequest(appName);
                boolean registed = this.client.registeApplication(applicationInfoRequest);
                if (!registed) {
                    throw new RuntimeException("registe application occors error," + applicationInfoRequest);
                }
                this.registedApp = true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected ApplicationInfoRequest buildApplicationRequest(String appName) {
        ApplicationInfoRequest applicationInfoRequest = new ApplicationInfoRequest();
        applicationInfoRequest.setAppName(appName);
        return applicationInfoRequest;
    }

    protected String fillProtocolAndVersion(SubscribeServiceResult subscribeServiceResult, String targetURL, String serviceName, String protocol) {
        block3: {
            String meshPort;
            block2: {
                meshPort = this.judgeMeshPort(protocol);
                List<String> datas = subscribeServiceResult.getDatas();
                if (!CommonUtils.isEmpty(datas)) break block2;
                targetURL = targetURL + ":" + meshPort;
                break block3;
            }
            Iterator<String> iterator = subscribeServiceResult.getDatas().iterator();
            if (!iterator.hasNext()) break block3;
            String data = iterator.next();
            int indexOfParam = data.indexOf("?");
            if (indexOfParam != -1) {
                String param = data.substring(indexOfParam + 1);
                targetURL = targetURL + ":" + meshPort;
                targetURL = targetURL + "?" + param;
            } else {
                targetURL = targetURL + ":" + meshPort;
            }
        }
        return targetURL;
    }

    @Override
    public void unSubscribe(ConsumerConfig config) {
        UnSubscribeServiceRequest unsubscribeRequest = this.buildUnSubscribeServiceRequest(config);
        this.client.unSubscribeService(unsubscribeRequest);
    }

    protected UnSubscribeServiceRequest buildUnSubscribeServiceRequest(ConsumerConfig config) {
        UnSubscribeServiceRequest unsubscribeRequest = new UnSubscribeServiceRequest();
        String key = MeshRegistryHelper.buildMeshKey(config, config.getProtocol());
        unsubscribeRequest.setServiceName(key);
        return unsubscribeRequest;
    }

    @Override
    public void batchUnSubscribe(List<ConsumerConfig> configs) {
        for (ConsumerConfig config : configs) {
            String appName = config.getAppName();
            try {
                this.unSubscribe(config);
            }
            catch (Exception e) {
                LOGGER.errorWithApp(appName, "Error when batch unSubscribe", e);
            }
        }
    }

    protected String judgeMeshPort(String protocol) {
        return String.valueOf(12220);
    }

    @Override
    public void destroy() {
        this.client = null;
    }
}

