/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.mesh;

import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.client.ProviderStatus;
import com.alipay.sofa.rpc.common.SystemInfo;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.NetUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.AbstractInterfaceConfig;
import com.alipay.sofa.rpc.config.ConfigUniqueNameGenerator;
import com.alipay.sofa.rpc.config.MethodConfig;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.context.RpcRuntimeContext;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SofaRegistryHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SofaRegistryHelper.class);
    public static final String PUBLISHER_PREFIX = "SofaProvider-";
    public static final String SUBSCRIBER_PREFIX = "SofaSubscriber-";
    public static final String SUBSCRIBER_LIST_GROUP_ID = "SOFA";
    public static final String SUBSCRIBER_CONFIG_GROUP_ID = "SOFA.CONFIG";
    public static final String PROTOCOL_TYPE_OVERRIDE = "override";

    public static String buildListDataId(AbstractInterfaceConfig config, String protocol) {
        if ("bolt".equals(protocol) || "tr".equals(protocol)) {
            return ConfigUniqueNameGenerator.getUniqueName(config) + "@DEFAULT";
        }
        return ConfigUniqueNameGenerator.getUniqueName(config) + "@" + protocol;
    }

    public static String convertProviderToUrls(ProviderConfig providerConfig, ServerConfig server) {
        Map<String, MethodConfig> methodConfigs;
        Integer port;
        StringBuilder sb = new StringBuilder(200);
        String appName = providerConfig.getAppName();
        String host = server.getVirtualHost();
        if (host == null) {
            host = server.getHost();
            if (NetUtils.isLocalHost(host) || NetUtils.isAnyHost(host)) {
                host = SystemInfo.getLocalHost();
            }
        } else if (LOGGER.isWarnEnabled(appName)) {
            LOGGER.warnWithApp(appName, "Virtual host is specified, host will be change from {} to {} when register", server.getHost(), host);
        }
        if ((port = server.getVirtualPort()) == null) {
            port = server.getPort();
        } else if (LOGGER.isWarnEnabled(appName)) {
            LOGGER.warnWithApp(appName, "Virtual port is specified, host will be change from {} to {} when register", server.getPort(), port);
        }
        String protocol = server.getProtocol();
        sb.append(host).append(":").append(port).append(server.getContextPath());
        sb.append("?").append("rpcVer").append("=").append(50604);
        sb.append(SofaRegistryHelper.getKeyPairs("serialization", providerConfig.getSerialization()));
        sb.append(SofaRegistryHelper.getKeyPairs("weight", providerConfig.getWeight()));
        if (providerConfig.getTimeout() > 0) {
            sb.append(SofaRegistryHelper.getKeyPairs("timeout", providerConfig.getTimeout()));
        }
        sb.append(SofaRegistryHelper.getKeyPairs("appName", appName));
        if ("bolt".equals(protocol)) {
            sb.append(SofaRegistryHelper.getKeyPairs("p", (byte)1));
        } else if ("tr".equals(protocol)) {
            sb.append(SofaRegistryHelper.getKeyPairs("p", (byte)13));
        }
        sb.append(SofaRegistryHelper.getKeyPairs("v", "4.0"));
        sb.append(SofaRegistryHelper.getKeyPairs("_SERIALIZETYPE", providerConfig.getSerialization()));
        sb.append(SofaRegistryHelper.getKeyPairs("_WEIGHT", providerConfig.getWeight()));
        if (providerConfig.getTimeout() > 0) {
            sb.append(SofaRegistryHelper.getKeyPairs("_TIMEOUT", providerConfig.getTimeout()));
        }
        sb.append(SofaRegistryHelper.getKeyPairs("app_name", appName));
        if (StringUtils.isNotBlank(SystemInfo.getHostMachine())) {
            sb.append(SofaRegistryHelper.getKeyPairs("_HOSTMACHINE", SystemInfo.getHostMachine()));
        }
        if (CommonUtils.isNotEmpty(methodConfigs = providerConfig.getMethods())) {
            for (Map.Entry<String, MethodConfig> entry : methodConfigs.entrySet()) {
                String methodName = entry.getKey();
                MethodConfig methodConfig = entry.getValue();
                sb.append(SofaRegistryHelper.getKeyPairs("." + methodName + "." + "timeout", methodConfig.getTimeout()));
                String key = "[" + methodName + "]";
                String value = "[clientTimeout#" + methodConfig.getTimeout() + "]";
                sb.append(SofaRegistryHelper.getKeyPairs(key, value));
            }
        }
        sb.append(SofaRegistryHelper.convertMap2Pair(providerConfig.getParameters()));
        SofaRegistryHelper.addCommonAttrs(sb);
        return sb.toString();
    }

    private static String convertMap2Pair(Map<String, String> map) {
        if (CommonUtils.isEmpty(map)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(128);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append(SofaRegistryHelper.getKeyPairs(entry.getKey(), entry.getValue()));
        }
        return sb.toString();
    }

    private static String getKeyPairs(String key, Object value) {
        if (value != null) {
            return "&" + key + "=" + value.toString();
        }
        return "";
    }

    private static void addCommonAttrs(StringBuilder sb) {
        sb.append(SofaRegistryHelper.getKeyPairs("startTime", RpcRuntimeContext.now()));
    }

    public static List<ProviderInfo> parseProviderInfos(List<String> urls) {
        ArrayList<ProviderInfo> providers = new ArrayList<ProviderInfo>();
        if (CommonUtils.isNotEmpty(urls)) {
            for (String object : urls) {
                providers.add(SofaRegistryHelper.parseProviderInfo(object));
            }
        }
        return providers;
    }

    public static ProviderInfo parseProviderInfo(String originUrl) {
        String hostMachineName;
        String connections;
        String appNameStr;
        String serializationStr;
        String timeoutStr;
        String v;
        String url = originUrl;
        String host = null;
        int port = 80;
        String path = null;
        String schema = null;
        int i = url.indexOf("://");
        if (i > 0) {
            schema = url.substring(0, i);
            url = url.substring(i + 3);
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        i = url.indexOf(63);
        if (i >= 0) {
            String[] parts;
            for (String part : parts = url.substring(i + 1).split("\\&")) {
                if ((part = part.trim()).length() <= 0) continue;
                int j = part.indexOf(61);
                if (j >= 0) {
                    parameters.put(part.substring(0, j), part.substring(j + 1));
                    continue;
                }
                parameters.put(part, part);
            }
            url = url.substring(0, i);
        }
        if ((i = url.indexOf(47)) >= 0) {
            path = url.substring(i + 1);
            url = url.substring(0, i);
        }
        if ((i = url.indexOf(58)) >= 0 && i < url.length() - 1) {
            port = Integer.parseInt(url.substring(i + 1));
            url = url.substring(0, i);
        }
        if (url.length() > 0) {
            host = url;
        }
        ProviderInfo providerInfo = new ProviderInfo();
        providerInfo.setOriginUrl(originUrl);
        providerInfo.setHost(host);
        if (port != 80) {
            providerInfo.setPort(port);
        }
        if (path != null) {
            providerInfo.setPath(path);
        }
        if (schema != null) {
            providerInfo.setProtocolType(schema);
        }
        String protocolStr = SofaRegistryHelper.getValue(parameters, "p");
        if (schema == null && protocolStr != null) {
            if ("1".equals(protocolStr)) {
                protocolStr = "bolt";
            } else if ("13".equals(protocolStr)) {
                protocolStr = "tr";
            }
            try {
                providerInfo.setProtocolType(protocolStr);
            }
            catch (Exception e) {
                LOGGER.error("protocol is invalid : {}", originUrl);
            }
        }
        if (StringUtils.isNotBlank(v = SofaRegistryHelper.getValue(parameters, "v"))) {
            providerInfo.setStaticAttr("v", v);
        }
        if ((timeoutStr = SofaRegistryHelper.getValue(parameters, "timeout", "_TIMEOUT")) != null) {
            SofaRegistryHelper.removeOldKeys(parameters, "timeout", "_TIMEOUT");
            try {
                providerInfo.setDynamicAttr("timeout", Integer.parseInt(timeoutStr));
            }
            catch (Exception e) {
                LOGGER.error("timeout is invalid : {}", originUrl);
            }
        }
        if ((serializationStr = SofaRegistryHelper.getValue(parameters, "serialization", "_SERIALIZETYPE")) != null) {
            SofaRegistryHelper.removeOldKeys(parameters, "serialization", "_SERIALIZETYPE");
            if ("1".equals(serializationStr)) {
                serializationStr = "hessian";
            } else if ("2".equals(serializationStr)) {
                serializationStr = "java";
            } else if ("4".equals(serializationStr)) {
                serializationStr = "hessian2";
            } else if ("11".equals(serializationStr)) {
                serializationStr = "protobuf";
            }
            providerInfo.setSerializationType(serializationStr);
        }
        if ((appNameStr = SofaRegistryHelper.getValue(parameters, "appName", "app_name", "self_app_name")) != null) {
            SofaRegistryHelper.removeOldKeys(parameters, "app_name", "self_app_name");
            providerInfo.setStaticAttr("appName", appNameStr);
        }
        if ((connections = SofaRegistryHelper.getValue(parameters, "connections", "_CONNECTIONNUM")) != null) {
            SofaRegistryHelper.removeOldKeys(parameters, "_CONNECTIONNUM");
            providerInfo.setStaticAttr("connections", connections);
        }
        String rpcVersion = SofaRegistryHelper.getValue(parameters, "rpcVer");
        providerInfo.setRpcVersion(CommonUtils.parseInt(rpcVersion, providerInfo.getRpcVersion()));
        String weightStr = SofaRegistryHelper.getValue(parameters, "weight", "_WEIGHT");
        if (weightStr != null) {
            SofaRegistryHelper.removeOldKeys(parameters, "weight", "_WEIGHT");
            try {
                int weight = Integer.parseInt(weightStr);
                providerInfo.setWeight(weight);
                providerInfo.setStaticAttr("weight", weightStr);
            }
            catch (Exception e) {
                LOGGER.error("weight is invalid : {}", originUrl);
            }
        }
        String warmupTimeStr = SofaRegistryHelper.getValue(parameters, "warmupTime", "_WARMUPTIME");
        int warmupTime = 0;
        if (warmupTimeStr != null) {
            SofaRegistryHelper.removeOldKeys(parameters, "warmupTime", "_WARMUPTIME");
            try {
                warmupTime = Integer.parseInt(warmupTimeStr);
                providerInfo.setStaticAttr("warmupTime", warmupTimeStr);
            }
            catch (Exception e) {
                LOGGER.error("warmupTime is invalid : {}", originUrl);
            }
        }
        String warmupWeightStr = SofaRegistryHelper.getValue(parameters, "warmupWeight", "_WARMUPWEIGHT");
        int warmupWeight = 0;
        if (warmupWeightStr != null) {
            SofaRegistryHelper.removeOldKeys(parameters, "warmupWeight", "_WARMUPWEIGHT");
            try {
                warmupWeight = Integer.parseInt(warmupWeightStr);
                providerInfo.setStaticAttr("warmupWeight", warmupWeightStr);
            }
            catch (Exception e) {
                LOGGER.error("warmupWeight is invalid : {}", originUrl);
            }
        }
        String startTimeStr = SofaRegistryHelper.getValue(parameters, "startTime");
        long startTime = 0L;
        if (startTimeStr != null) {
            try {
                startTime = Long.parseLong(startTimeStr);
            }
            catch (Exception e) {
                LOGGER.error("startTime is invalid : {}", originUrl);
            }
        }
        if (startTime == 0L) {
            startTime = System.currentTimeMillis();
        }
        if (StringUtils.isNotBlank(warmupTimeStr) && StringUtils.isNotBlank(warmupWeightStr) && warmupTime > 0) {
            providerInfo.setStatus(ProviderStatus.WARMING_UP);
            providerInfo.setDynamicAttr("warmupWeight", warmupWeight);
            providerInfo.setDynamicAttr("warmupEndTime", startTime + (long)warmupTime);
        }
        if (StringUtils.isNotBlank(hostMachineName = SofaRegistryHelper.getValue(parameters, "_HOSTMACHINE"))) {
            providerInfo.setDynamicAttr("hostMachine", hostMachineName);
        }
        ArrayList<String> methodKeys = new ArrayList<String>();
        HashMap<String, Object> methodParameters = new HashMap<String, Object>();
        for (Map.Entry entry : parameters.entrySet()) {
            if (!((String)entry.getKey()).startsWith("[") || !((String)entry.getKey()).endsWith("]") || !((String)entry.getValue()).startsWith("[") || !((String)entry.getValue()).endsWith("]")) continue;
            String key = (String)entry.getKey();
            methodKeys.add(key);
            String methodName = key.substring(1, key.length() - 1);
            SofaRegistryHelper.parseMethodInfo(methodParameters, methodName, (String)entry.getValue());
        }
        for (String methodKey : methodKeys) {
            parameters.remove(methodKey);
        }
        providerInfo.getStaticAttrs().putAll(parameters);
        providerInfo.getDynamicAttrs().putAll(methodParameters);
        providerInfo.setStaticAttr("source", "sofa");
        return providerInfo;
    }

    static void parseMethodInfo(Map<String, Object> methodParameters, String method, String valueStr) {
        int idxRight;
        int idxSplit = valueStr.indexOf(35);
        if (idxSplit < 0) {
            return;
        }
        int idxLeft = valueStr.indexOf(91);
        String parameters = valueStr.substring(idxLeft + 1, idxRight = valueStr.indexOf(93));
        String[] kvs = parameters.split("@");
        if (kvs.length > 0) {
            HashMap<String, String> tmp = new HashMap<String, String>();
            for (String kvp : kvs) {
                String[] kv = kvp.split("#");
                if (kv.length != 2) continue;
                tmp.put(kv[0], kv[1]);
            }
            String timeout = SofaRegistryHelper.getValue(tmp, "timeout", "clientTimeout", "_TIMEOUT");
            if (timeout != null) {
                SofaRegistryHelper.removeOldKeys(tmp, "timeout", "clientTimeout", "_TIMEOUT");
                try {
                    methodParameters.put("." + method + "." + "timeout", Integer.parseInt(timeout));
                }
                catch (Exception e) {
                    LOGGER.error("method timeout is invalid : {}", timeout);
                }
            }
            for (Map.Entry entry : tmp.entrySet()) {
                methodParameters.put("." + method + "." + (String)entry.getKey(), entry.getValue());
            }
        }
    }

    static String getValue(Map<String, String> map, String ... keys) {
        if (CommonUtils.isEmpty(map)) {
            return null;
        }
        for (String key : keys) {
            String val = map.get(key);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    static void removeOldKeys(Map<String, String> map, String ... keys) {
        if (CommonUtils.isEmpty(map)) {
            return;
        }
        for (String key : keys) {
            map.remove(key);
        }
    }
}

