/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client.aft;

import com.alipay.sofa.rpc.client.aft.FaultToleranceConfig;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class FaultToleranceConfigManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(FaultToleranceConfigManager.class);
    private static final ConcurrentMap<String, FaultToleranceConfig> APP_CONFIGS = new ConcurrentHashMap<String, FaultToleranceConfig>();
    private static final FaultToleranceConfig DEFAULT_CFG = new FaultToleranceConfig();
    private static volatile boolean aftEnable = false;

    public static void putAppConfig(String appName, FaultToleranceConfig value) {
        if (appName == null) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("App name is null when put fault-tolerance config");
            }
            return;
        }
        if (value != null) {
            APP_CONFIGS.put(appName, value);
            if (LOGGER.isInfoEnabled(appName)) {
                LOGGER.infoWithApp(appName, "Get a new resource, value[" + value + "]");
            }
        } else {
            APP_CONFIGS.remove(appName);
            if (LOGGER.isInfoEnabled(appName)) {
                LOGGER.infoWithApp(appName, "Remove a resource, key[" + appName + "]");
            }
        }
        FaultToleranceConfigManager.calcEnable();
    }

    static void calcEnable() {
        for (FaultToleranceConfig config : APP_CONFIGS.values()) {
            if (!config.isRegulationEffective()) continue;
            aftEnable = true;
            return;
        }
        aftEnable = false;
    }

    public static boolean isEnable() {
        return aftEnable;
    }

    public static FaultToleranceConfig getConfig(String appName) {
        if (appName == null) {
            return DEFAULT_CFG;
        }
        FaultToleranceConfig config = (FaultToleranceConfig)APP_CONFIGS.get(appName);
        return config == null ? DEFAULT_CFG : config;
    }

    public static long getTimeWindow(String appName) {
        FaultToleranceConfig config = FaultToleranceConfigManager.getConfig(appName);
        return config.getTimeWindow();
    }

    public static long getLeastCallCount(String appName) {
        FaultToleranceConfig config = FaultToleranceConfigManager.getConfig(appName);
        return config.getLeastCallCount();
    }

    public static long getLeastWindowCount(String appName) {
        FaultToleranceConfig config = FaultToleranceConfigManager.getConfig(appName);
        return config.getLeastWindowCount();
    }

    public static double getLeastWindowExceptionRateMultiple(String appName) {
        FaultToleranceConfig config = FaultToleranceConfigManager.getConfig(appName);
        return config.getLeastWindowExceptionRateMultiple();
    }

    public static double getWeightDegradeRate(String appName) {
        FaultToleranceConfig config = FaultToleranceConfigManager.getConfig(appName);
        return config.getWeightDegradeRate();
    }

    public static boolean isRegulationEffective(String appName) {
        FaultToleranceConfig config = FaultToleranceConfigManager.getConfig(appName);
        return config.isRegulationEffective();
    }

    public static boolean isDegradeEffective(String appName) {
        FaultToleranceConfig config = FaultToleranceConfigManager.getConfig(appName);
        return config.isDegradeEffective();
    }

    public static int getDegradeLeastWeight(String appName) {
        FaultToleranceConfig config = FaultToleranceConfigManager.getConfig(appName);
        return config.getDegradeLeastWeight();
    }

    public static double getWeightRecoverRate(String appName) {
        FaultToleranceConfig config = FaultToleranceConfigManager.getConfig(appName);
        return config.getWeightRecoverRate();
    }

    public static int getDegradeMaxIpCount(String appName) {
        FaultToleranceConfig config = FaultToleranceConfigManager.getConfig(appName);
        return config.getDegradeMaxIpCount();
    }
}

