/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.consul;

import com.alipay.sofa.rpc.base.Destroyable;
import com.alipay.sofa.rpc.client.ProviderGroup;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.RegistryConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.context.RpcRunningState;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.event.ConsumerSubEvent;
import com.alipay.sofa.rpc.event.EventBus;
import com.alipay.sofa.rpc.event.ProviderPubEvent;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.registry.Registry;
import com.alipay.sofa.rpc.registry.consul.ConsulRegistryProperties;
import com.alipay.sofa.rpc.registry.consul.ConsulUtils;
import com.alipay.sofa.rpc.registry.consul.HealthServiceInformer;
import com.alipay.sofa.rpc.registry.utils.RegistryUtils;
import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.agent.model.NewService;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@Extension(value="consul")
public class ConsulRegistry
extends Registry {
    public static final String EXT_NAME = "ConsulRegistry";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsulRegistry.class);
    private final ConsulRegistryProperties properties;
    private Map<String, ScheduledFuture> heartbeatFutures = new ConcurrentHashMap<String, ScheduledFuture>();
    private Map<String, HealthServiceInformer> healthServiceInformers = new ConcurrentHashMap<String, HealthServiceInformer>();
    private ConsulClient consulClient;
    private ScheduledExecutorService heartbeatExecutor;

    protected ConsulRegistry(RegistryConfig registryConfig) {
        super(registryConfig);
        this.properties = new ConsulRegistryProperties(registryConfig.getParameters());
    }

    @Override
    public void init() {
        if (this.consulClient != null) {
            return;
        }
        String[] hostAndPort = StringUtils.split(this.registryConfig.getAddress(), ":");
        String host = hostAndPort[0];
        int port = hostAndPort.length > 1 ? Integer.parseInt(hostAndPort[1]) : 8500;
        this.consulClient = new ConsulClient(host, port);
        int coreSize = this.properties.getHeartbeatCoreSize();
        this.heartbeatExecutor = Executors.newScheduledThreadPool(coreSize);
    }

    @Override
    public void destroy() {
        if (this.heartbeatExecutor != null) {
            this.heartbeatExecutor.shutdown();
        }
        this.healthServiceInformers.values().forEach(HealthServiceInformer::shutdown);
    }

    @Override
    public void destroy(Destroyable.DestroyHook hook) {
        hook.preDestroy();
        this.destroy();
        hook.postDestroy();
    }

    @Override
    public boolean start() {
        return true;
    }

    @Override
    public void register(ProviderConfig config) {
        String appName = config.getAppName();
        if (!this.registryConfig.isRegister()) {
            if (LOGGER.isInfoEnabled(appName)) {
                LOGGER.infoWithApp(appName, LogCodes.getLog("010060003"));
            }
            return;
        }
        if (!config.isRegister()) {
            return;
        }
        try {
            List<NewService> services = this.buildNewServices(config);
            if (CommonUtils.isNotEmpty(services)) {
                if (LOGGER.isInfoEnabled(appName)) {
                    LOGGER.infoWithApp(appName, LogCodes.getLog("010000003", config.getInterfaceId()));
                }
                for (NewService service : services) {
                    this.registerConsulService(service);
                    if (!LOGGER.isInfoEnabled(appName)) continue;
                    LOGGER.infoWithApp(appName, LogCodes.getLog("010000001", config.getInterfaceId()));
                }
                if (LOGGER.isInfoEnabled(appName)) {
                    LOGGER.infoWithApp(appName, LogCodes.getLog("010000004", config.getInterfaceId()));
                }
            }
        }
        catch (SofaRpcRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("010060007", "consulRegistry", config.buildKey()), e);
        }
        if (EventBus.isEnable(ProviderPubEvent.class)) {
            ProviderPubEvent event = new ProviderPubEvent(config);
            EventBus.post(event);
        }
    }

    @Override
    public void unRegister(ProviderConfig config) {
        block8: {
            String appName = config.getAppName();
            if (!this.registryConfig.isRegister()) {
                if (LOGGER.isInfoEnabled(appName)) {
                    LOGGER.infoWithApp(appName, LogCodes.getLog("010060003"));
                }
                return;
            }
            if (!config.isRegister()) {
                return;
            }
            try {
                List<String> ids = ConsulUtils.buildServiceIds(config);
                if (CommonUtils.isNotEmpty(ids)) {
                    ids.forEach(this::deregisterConsulService);
                    if (LOGGER.isInfoEnabled(appName)) {
                        LOGGER.infoWithApp(appName, LogCodes.getLog("010000002", config.getInterfaceId(), ids.size()));
                    }
                }
            }
            catch (Exception e) {
                if (RpcRunningState.isShuttingDown()) break block8;
                if (e instanceof SofaRpcRuntimeException) {
                    throw e;
                }
                throw new SofaRpcRuntimeException(LogCodes.getLog("010060008", EXT_NAME), e);
            }
        }
    }

    @Override
    public void batchUnRegister(List<ProviderConfig> configs) {
        configs.forEach(this::unRegister);
    }

    @Override
    public List<ProviderGroup> subscribe(ConsumerConfig config) {
        String appName = config.getAppName();
        if (!this.registryConfig.isSubscribe()) {
            if (LOGGER.isInfoEnabled(appName)) {
                LOGGER.infoWithApp(appName, LogCodes.getLog("010060003"));
            }
            return null;
        }
        if (!config.isSubscribe()) {
            return null;
        }
        try {
            List<ProviderInfo> providers = this.lookupHealthService(config);
            if (EventBus.isEnable(ConsumerSubEvent.class)) {
                ConsumerSubEvent event = new ConsumerSubEvent(config);
                EventBus.post(event);
            }
            return Collections.singletonList(new ProviderGroup().addAll(providers));
        }
        catch (SofaRpcRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("010060009", EXT_NAME), e);
        }
    }

    @Override
    public void unSubscribe(ConsumerConfig config) {
        String appName = config.getAppName();
        if (!this.registryConfig.isSubscribe() && LOGGER.isInfoEnabled(appName)) {
            LOGGER.infoWithApp(config.getAppName(), LogCodes.getLog("010060003"));
        }
        if (!config.isSubscribe()) {
            return;
        }
        String uniqueName = RegistryUtils.buildUniqueName(config, config.getProtocol());
        HealthServiceInformer informer = this.healthServiceInformers.get(uniqueName);
        if (informer == null) {
            return;
        }
        informer.removeListener(config.getProviderInfoListener());
        if (informer.getListenerSize() == 0) {
            this.healthServiceInformers.remove(uniqueName);
            informer.shutdown();
        }
    }

    @Override
    public void batchUnSubscribe(List<ConsumerConfig> configs) {
        configs.forEach(this::unSubscribe);
    }

    private List<ProviderInfo> lookupHealthService(ConsumerConfig config) {
        String uniqueName = RegistryUtils.buildUniqueName(config, config.getProtocol());
        String serviceName = ConsulUtils.buildServiceName(config);
        String informerKey = String.join((CharSequence)"-", serviceName, uniqueName);
        HealthServiceInformer informer = this.healthServiceInformers.get(informerKey);
        if (informer == null) {
            informer = new HealthServiceInformer(serviceName, uniqueName, this.consulClient, this.properties);
            informer.init();
            this.healthServiceInformers.put(informerKey, informer);
        }
        informer.addListener(config.getProviderInfoListener());
        return informer.currentProviders();
    }

    private void deregisterConsulService(String id) {
        this.consulClient.agentServiceDeregister(id);
        ScheduledFuture future = this.heartbeatFutures.remove(id);
        if (future != null) {
            future.cancel(true);
        }
    }

    private void registerConsulService(NewService service) {
        this.consulClient.agentServiceRegister(service);
        if (service.getCheck().getTtl() != null) {
            ScheduledFuture<?> scheduledFuture = this.heartbeatExecutor.scheduleAtFixedRate(() -> this.checkPass(service), 0L, this.properties.getHeartbeatInterval(), TimeUnit.MILLISECONDS);
            ScheduledFuture oldFuture = this.heartbeatFutures.remove(service.getId());
            if (oldFuture != null) {
                oldFuture.cancel(true);
            }
            this.heartbeatFutures.put(service.getId(), scheduledFuture);
        }
    }

    private void checkPass(NewService service) {
        try {
            this.consulClient.agentCheckPass("service:" + service.getId(), "TTL check passing by SOFA RPC");
        }
        catch (Exception e) {
            LOGGER.error(LogCodes.getLog("010060024", "Consul"), e);
        }
    }

    private List<NewService> buildNewServices(ProviderConfig<?> config) {
        List<ServerConfig> servers = config.getServer();
        if (CommonUtils.isEmpty(servers)) {
            return Collections.emptyList();
        }
        return servers.stream().map(server -> {
            NewService service = new NewService();
            service.setId(ConsulUtils.buildServiceId(config, server));
            service.setName(ConsulUtils.buildServiceName(config));
            String host = RegistryUtils.getServerHost(server);
            int port = server.getPort();
            service.setAddress(host);
            service.setPort(Integer.valueOf(port));
            Map<String, String> metaData = RegistryUtils.convertProviderToMap(config, server).entrySet().stream().filter(e -> ConsulUtils.isValidMetaKey((String)e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            service.setMeta(metaData);
            service.setTags(Collections.singletonList(RegistryUtils.buildUniqueName(config, server.getProtocol())));
            service.setCheck(this.buildCheck(host, port));
            return service;
        }).collect(Collectors.toList());
    }

    private NewService.Check buildCheck(String serverHost, int serverPort) {
        NewService.Check check = new NewService.Check();
        ConsulRegistryProperties.HealthCheckType healthCheckType = this.properties.getHealthCheckType();
        if (healthCheckType == ConsulRegistryProperties.HealthCheckType.TTL) {
            check.setTtl(this.properties.getHealthCheckTTL());
        } else if (healthCheckType == ConsulRegistryProperties.HealthCheckType.TCP) {
            String host = this.properties.getHealthCheckHost(serverHost);
            int port = this.properties.getHealthCheckPort(serverPort);
            check.setTcp(host + ":" + port);
            check.setInterval(this.properties.getHealthCheckInterval());
            check.setTimeout(this.properties.getHealthCheckTimeout());
        } else {
            String address;
            String host = this.properties.getHealthCheckHost(serverHost);
            int port = this.properties.getHealthCheckPort(serverPort);
            try {
                address = new URL(this.properties.getHealthCheckProtocol(), host, port, this.properties.getHealthCheckPath()).toString();
            }
            catch (SofaRpcRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SofaRpcRuntimeException(LogCodes.getLog("010060018"), e);
            }
            check.setHttp(address);
            check.setMethod(this.properties.getHealthCheckMethod());
            check.setInterval(this.properties.getHealthCheckInterval());
            check.setTimeout(this.properties.getHealthCheckTimeout());
        }
        return check;
    }
}

