/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.transport.http;

import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.server.http.HttpServerHandler;
import com.alipay.sofa.rpc.transport.ServerTransport;
import com.alipay.sofa.rpc.transport.ServerTransportConfig;
import com.alipay.sofa.rpc.transport.http.Http2ServerChannelInitializer;
import com.alipay.sofa.rpc.transport.http.SslContextBuilder;
import com.alipay.sofa.rpc.transport.netty.NettyHelper;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public abstract class AbstractHttp2ServerTransport
extends ServerTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractHttp2ServerTransport.class);
    private volatile ServerBootstrap serverBootstrap;
    private EventLoopGroup bizGroup;

    protected AbstractHttp2ServerTransport(ServerTransportConfig transportConfig) {
        super(transportConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean start() {
        if (this.serverBootstrap != null) {
            return true;
        }
        AbstractHttp2ServerTransport abstractHttp2ServerTransport = this;
        synchronized (abstractHttp2ServerTransport) {
            if (this.serverBootstrap != null) {
                return true;
            }
            boolean flag = false;
            SslContext sslCtx = SslContextBuilder.build();
            EventLoopGroup bossGroup = NettyHelper.getServerBossEventLoopGroup(this.transportConfig);
            HttpServerHandler httpServerHandler = (HttpServerHandler)this.transportConfig.getServerHandler();
            this.bizGroup = NettyHelper.getServerBizEventLoopGroup(this.transportConfig, httpServerHandler.getBizThreadPool());
            this.serverBootstrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.serverBootstrap.group(bossGroup, this.bizGroup).channel(this.transportConfig.isUseEpoll() ? EpollServerSocketChannel.class : NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)this.transportConfig.getBacklog())).option(ChannelOption.SO_REUSEADDR, (Object)this.transportConfig.isReuseAddr())).option(ChannelOption.RCVBUF_ALLOCATOR, (Object)NettyHelper.getRecvByteBufAllocator())).option(ChannelOption.ALLOCATOR, (Object)NettyHelper.getByteBufAllocator())).childOption(ChannelOption.SO_KEEPALIVE, (Object)this.transportConfig.isKeepAlive()).childOption(ChannelOption.TCP_NODELAY, (Object)this.transportConfig.isTcpNoDelay()).childOption(ChannelOption.SO_RCVBUF, (Object)0x100000).childOption(ChannelOption.SO_SNDBUF, (Object)0x100000).handler((ChannelHandler)new LoggingHandler(LogLevel.DEBUG))).childOption(ChannelOption.ALLOCATOR, (Object)NettyHelper.getByteBufAllocator()).childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(this.transportConfig.getBufferMin(), this.transportConfig.getBufferMax())).childHandler((ChannelHandler)new Http2ServerChannelInitializer(this.bizGroup, sslCtx, httpServerHandler, this.transportConfig.getPayload()));
            ChannelFuture future = this.serverBootstrap.bind((SocketAddress)new InetSocketAddress(this.transportConfig.getHost(), this.transportConfig.getPort()));
            ChannelFuture channelFuture = future.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info("HTTP/2 Server bind to {}:{} success!", AbstractHttp2ServerTransport.this.transportConfig.getHost(), AbstractHttp2ServerTransport.this.transportConfig.getPort());
                        }
                    } else {
                        LOGGER.error(LogCodes.getLog("010000029", AbstractHttp2ServerTransport.this.transportConfig.getHost(), AbstractHttp2ServerTransport.this.transportConfig.getPort()));
                        AbstractHttp2ServerTransport.this.stop();
                    }
                }
            });
            try {
                channelFuture.await();
                if (!channelFuture.isSuccess()) {
                    throw new SofaRpcRuntimeException(LogCodes.getLog("010000024", "HTTP/2"), future.cause());
                }
                flag = Boolean.TRUE;
            }
            catch (InterruptedException e) {
                LOGGER.error(e.getMessage(), e);
            }
            return flag;
        }
    }

    @Override
    public void stop() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Shutdown the SOFA RPC HTTP/2 server transport now...");
        }
        NettyHelper.closeServerBossEventLoopGroup(this.transportConfig);
        if (this.bizGroup != null) {
            this.bizGroup.shutdownGracefully();
        }
        this.serverBootstrap = null;
    }
}

