/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.transport.http;

import com.alipay.sofa.rpc.codec.SerializerFactory;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.log.LogCodes;

public class HttpTransportUtils {
    public static byte getSerializeTypeByName(String serialization) throws SofaRpcException {
        String sz = serialization.toLowerCase();
        Byte code = "hessian2".equals(sz) || "hessian".equals(sz) ? SerializerFactory.getCodeByAlias("hessian2") : SerializerFactory.getCodeByAlias(serialization);
        if (code != null) {
            return code;
        }
        throw new SofaRpcException(130, LogCodes.getLog("020050010", serialization));
    }

    public static byte getSerializeTypeByContentType(String contentType) throws SofaRpcException {
        if (StringUtils.isNotBlank(contentType)) {
            String ct = contentType.toLowerCase();
            if (ct.contains("text/plain") || ct.contains("text/html") || ct.contains("application/json")) {
                return HttpTransportUtils.getSerializeTypeByName("json");
            }
            if (ct.contains("protobuf")) {
                return HttpTransportUtils.getSerializeTypeByName("protobuf");
            }
            if (ct.contains("hessian")) {
                return HttpTransportUtils.getSerializeTypeByName("hessian2");
            }
        }
        throw new SofaRpcException(130, LogCodes.getLog("020050011", contentType, "sofa_head_serialize_type"));
    }

    protected static String[] getInterfaceIdAndMethod(String uri) {
        String[] end;
        int i = uri.indexOf(63);
        if (i > 0) {
            uri = uri.substring(0, i);
        }
        if ((end = uri.split("/")).length < 3) {
            throw new SofaRpcException(130, "The correct URI format is: http://ip:port/serviceName/methodName");
        }
        int resultLength = 2;
        String[] result = new String[resultLength];
        System.arraycopy(end, 1, result, 0, resultLength);
        return result;
    }
}

