/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.transport.http;

import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.transport.http.SelfSignedCer;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.File;

public class SslContextBuilder {
    public static final boolean SSL = System.getProperty("ssl") != null;
    public static final String PROPERTY_CERTIFICATE_PATH = "certificate_path";
    public static final String PROPERTY_PRIVATE_KEY_PATH = "private_key_path";
    public static final String CERTIFICATE_PATH = System.getProperty("certificate_path");
    public static final String PRIVATE_KEY_PATH = System.getProperty("private_key_path");

    public static SslContext build() {
        SslContext sslCtx;
        try {
            if (SSL) {
                SslProvider provider = OpenSsl.isAlpnSupported() ? SslProvider.OPENSSL : SslProvider.JDK;
                SelfSignedCer ssc = new SelfSignedCer(CERTIFICATE_PATH, PRIVATE_KEY_PATH);
                sslCtx = io.netty.handler.ssl.SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(provider).ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"})).build();
            } else {
                sslCtx = null;
            }
        }
        catch (SofaRpcRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("010000024", "HTTP/2"), e);
        }
        return sslCtx;
    }

    public static SslContext buildForClient() {
        SslContext sslCtx;
        try {
            if (SSL) {
                SslProvider provider = OpenSsl.isAlpnSupported() ? SslProvider.OPENSSL : SslProvider.JDK;
                sslCtx = io.netty.handler.ssl.SslContextBuilder.forClient().sslProvider(provider).ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).trustManager(InsecureTrustManagerFactory.INSTANCE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"})).build();
            } else {
                sslCtx = null;
            }
        }
        catch (SofaRpcRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("010010022", "HTTP/2"), e);
        }
        return sslCtx;
    }
}

