/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.gen.base;

import com.alipay.sofa.gen.domain.MethodContext;
import com.alipay.sofa.gen.domain.ServiceContext;
import com.google.common.base.Strings;
import com.google.common.html.HtmlEscapers;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.compiler.PluginProtos;
import com.salesforce.jprotoc.Generator;
import com.salesforce.jprotoc.GeneratorException;
import com.salesforce.jprotoc.ProtoTypeMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public abstract class AbstractGenerator
extends Generator {
    private static final int SERVICE_NUMBER_OF_PATHS = 2;
    private static final int METHOD_NUMBER_OF_PATHS = 4;

    protected abstract String getClassPrefix();

    protected abstract String getClassSuffix();

    private String getServiceJavaDocPrefix() {
        return "    ";
    }

    private String getMethodJavaDocPrefix() {
        return "        ";
    }

    public List<PluginProtos.CodeGeneratorResponse.File> generateFiles(PluginProtos.CodeGeneratorRequest request) throws GeneratorException {
        ProtoTypeMap typeMap = ProtoTypeMap.of((Collection)request.getProtoFileList());
        ArrayList<DescriptorProtos.FileDescriptorProto> protosToGenerate = new ArrayList<DescriptorProtos.FileDescriptorProto>();
        for (DescriptorProtos.FileDescriptorProto protoFile : request.getProtoFileList()) {
            if (!request.getFileToGenerateList().contains((Object)protoFile.getName())) continue;
            protosToGenerate.add(protoFile);
        }
        List<ServiceContext> services = this.findServices(protosToGenerate, typeMap);
        return this.generateFiles(services);
    }

    private List<ServiceContext> findServices(List<DescriptorProtos.FileDescriptorProto> protos, ProtoTypeMap typeMap) {
        ArrayList<ServiceContext> contexts = new ArrayList<ServiceContext>();
        for (DescriptorProtos.FileDescriptorProto fileProto : protos) {
            for (int serviceNumber = 0; serviceNumber < fileProto.getServiceCount(); ++serviceNumber) {
                ServiceContext serviceContext = this.buildServiceContext(fileProto.getService(serviceNumber), typeMap, fileProto.getSourceCodeInfo().getLocationList(), serviceNumber);
                serviceContext.setProtoName(fileProto.getName());
                serviceContext.setPackageName(this.extractPackageName(fileProto));
                contexts.add(serviceContext);
            }
        }
        return contexts;
    }

    private String extractPackageName(DescriptorProtos.FileDescriptorProto proto) {
        String javaPackage;
        DescriptorProtos.FileOptions options = proto.getOptions();
        if (options != null && !Strings.isNullOrEmpty((String)(javaPackage = options.getJavaPackage()))) {
            return javaPackage;
        }
        return Strings.nullToEmpty((String)proto.getPackage());
    }

    private ServiceContext buildServiceContext(DescriptorProtos.ServiceDescriptorProto serviceProto, ProtoTypeMap typeMap, List<DescriptorProtos.SourceCodeInfo.Location> locations, int serviceNumber) {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setFileName(this.getClassPrefix() + serviceProto.getName() + this.getClassSuffix() + ".java");
        serviceContext.setClassName(this.getClassPrefix() + serviceProto.getName() + this.getClassSuffix());
        serviceContext.setServiceName(serviceProto.getName());
        serviceContext.setDeprecated(serviceProto.getOptions() != null && serviceProto.getOptions().getDeprecated());
        ArrayList<DescriptorProtos.SourceCodeInfo.Location> allLocationsForService = new ArrayList<DescriptorProtos.SourceCodeInfo.Location>();
        for (DescriptorProtos.SourceCodeInfo.Location location : locations) {
            if (location.getPathCount() < 2 || location.getPath(0) != 6 || location.getPath(1) != serviceNumber) continue;
            allLocationsForService.add(location);
        }
        Optional<DescriptorProtos.SourceCodeInfo.Location> found = Optional.empty();
        for (DescriptorProtos.SourceCodeInfo.Location location : allLocationsForService) {
            if (location.getPathCount() != 2) continue;
            found = Optional.of(location);
            break;
        }
        final DescriptorProtos.SourceCodeInfo.Location location = DescriptorProtos.SourceCodeInfo.Location.getDefaultInstance();
        DescriptorProtos.SourceCodeInfo.Location location2 = found.orElseGet(new Supplier<DescriptorProtos.SourceCodeInfo.Location>(){

            @Override
            public DescriptorProtos.SourceCodeInfo.Location get() {
                return location;
            }
        });
        serviceContext.setJavaDoc(this.getJavaDoc(this.getComments(location2), this.getServiceJavaDocPrefix()));
        for (int methodNumber = 0; methodNumber < serviceProto.getMethodCount(); ++methodNumber) {
            MethodContext methodContext = this.buildMethodContext(serviceProto.getMethod(methodNumber), typeMap, locations, methodNumber);
            serviceContext.getMethods().add(methodContext);
            serviceContext.getMethodTypes().add(methodContext.getInputType());
            serviceContext.getMethodTypes().add(methodContext.getOutputType());
        }
        return serviceContext;
    }

    private MethodContext buildMethodContext(DescriptorProtos.MethodDescriptorProto methodProto, ProtoTypeMap typeMap, List<DescriptorProtos.SourceCodeInfo.Location> locations, int methodNumber) {
        MethodContext methodContext = new MethodContext();
        methodContext.setMethodName(this.lowerCaseFirst(methodProto.getName()));
        methodContext.setInputType(typeMap.toJavaTypeName(methodProto.getInputType()));
        methodContext.setOutputType(typeMap.toJavaTypeName(methodProto.getOutputType()));
        methodContext.setDeprecated(methodProto.getOptions() != null && methodProto.getOptions().getDeprecated());
        methodContext.setManyInput(methodProto.getClientStreaming());
        methodContext.setManyOutput(methodProto.getServerStreaming());
        methodContext.setMethodNumber(methodNumber);
        Optional<DescriptorProtos.SourceCodeInfo.Location> found = Optional.empty();
        for (DescriptorProtos.SourceCodeInfo.Location location : locations) {
            if (location.getPathCount() != 4 || location.getPath(3) != methodNumber) continue;
            found = Optional.of(location);
            break;
        }
        DescriptorProtos.SourceCodeInfo.Location methodLocation = found.orElseGet(DescriptorProtos.SourceCodeInfo.Location::getDefaultInstance);
        methodContext.setJavaDoc(this.getJavaDoc(this.getComments(methodLocation), this.getMethodJavaDocPrefix()));
        if (!methodProto.getClientStreaming() && !methodProto.getServerStreaming()) {
            methodContext.setReactiveCallsMethodName("oneToOne");
            methodContext.setGrpcCallsMethodName("asyncUnaryCall");
        }
        if (!methodProto.getClientStreaming() && methodProto.getServerStreaming()) {
            methodContext.setReactiveCallsMethodName("oneToMany");
            methodContext.setGrpcCallsMethodName("asyncServerStreamingCall");
        }
        if (methodProto.getClientStreaming() && !methodProto.getServerStreaming()) {
            methodContext.setReactiveCallsMethodName("manyToOne");
            methodContext.setGrpcCallsMethodName("asyncClientStreamingCall");
        }
        if (methodProto.getClientStreaming() && methodProto.getServerStreaming()) {
            methodContext.setReactiveCallsMethodName("manyToMany");
            methodContext.setGrpcCallsMethodName("asyncBidiStreamingCall");
        }
        return methodContext;
    }

    private String lowerCaseFirst(String s) {
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    private List<PluginProtos.CodeGeneratorResponse.File> generateFiles(List<ServiceContext> services) {
        ArrayList<PluginProtos.CodeGeneratorResponse.File> list = new ArrayList<PluginProtos.CodeGeneratorResponse.File>();
        for (ServiceContext service : services) {
            PluginProtos.CodeGeneratorResponse.File file = this.buildFile(service);
            list.add(file);
        }
        return list;
    }

    private PluginProtos.CodeGeneratorResponse.File buildFile(ServiceContext context) {
        String mustAcheFile = this.getClassPrefix() + this.getClassSuffix() + "Stub.mustache";
        String content = this.applyTemplate(mustAcheFile, context);
        return PluginProtos.CodeGeneratorResponse.File.newBuilder().setName(this.constructAbsoluteFileName(context)).setContent(content).build();
    }

    private String constructAbsoluteFileName(ServiceContext ctx) {
        String dir = ctx.getPackageName().replace('.', '/');
        if (Strings.isNullOrEmpty((String)dir)) {
            return ctx.getFileName();
        }
        return dir + "/" + ctx.getFileName();
    }

    private String getComments(DescriptorProtos.SourceCodeInfo.Location location) {
        return location.getLeadingComments().isEmpty() ? location.getTrailingComments() : location.getLeadingComments();
    }

    private String getJavaDoc(String comments, String prefix) {
        if (!comments.isEmpty()) {
            StringBuilder builder = new StringBuilder("/**\n").append(prefix).append(" * <pre>\n");
            for (String line : HtmlEscapers.htmlEscaper().escape(comments).split("\n")) {
                String replace = line.replace("*/", "&#42;&#47;").replace("*", "&#42;");
                builder.append(prefix).append(" * ").append(replace).append("\n");
            }
            builder.append(prefix).append(" * </pre>\n").append(prefix).append(" */");
            return builder.toString();
        }
        return null;
    }
}

