/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.datasource;

import com.alipay.sofa.tracer.plugins.datasource.BaseDataSource;
import com.alipay.sofa.tracer.plugins.datasource.ExtendedConnection;
import com.alipay.sofa.tracer.plugins.datasource.Interceptor;
import com.alipay.sofa.tracer.plugins.datasource.Invocation;
import com.alipay.sofa.tracer.plugins.datasource.Prop;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class ExtendedStatement
implements Statement {
    protected final ExtendedConnection conn;
    protected final Statement delegate;
    protected List<Interceptor> interceptors;
    protected Prop prop;
    protected List<String> batchSqlList;

    ExtendedStatement(ExtendedConnection conn, Statement delegate, Prop prop) {
        this.conn = conn;
        this.delegate = delegate;
        this.prop = prop;
        this.interceptors = prop.getInterceptors();
    }

    public Statement getDelegate() {
        return this.delegate;
    }

    Method getMethod(String methodName) {
        Method targetMethod = this.prop.getTargetMethod(methodName);
        if (targetMethod == null) {
            throw new IllegalStateException("method: " + methodName + "not registered");
        }
        return targetMethod;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        StatementInterceptorChainImpl chain = new StatementInterceptorChainImpl(sql, new Invocation(this.getMethod("executeQuery"), this.delegate, sql));
        try {
            return (ResultSet)chain.proceed();
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.doExecuteUpdate(this.getMethod("executeUpdate0"), sql);
    }

    private int doExecuteUpdate(Method method, Object ... args) throws SQLException {
        String sql = (String)args[0];
        StatementInterceptorChainImpl chain = new StatementInterceptorChainImpl(sql, new Invocation(method, this.delegate, args));
        try {
            return (Integer)chain.proceed();
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    protected SQLException handleException(Exception e) throws SQLException {
        Throwable t;
        if (e instanceof InvocationTargetException && (t = ((InvocationTargetException)e).getTargetException()) instanceof SQLException) {
            throw (SQLException)t;
        }
        throw new SQLException(e);
    }

    @Override
    public void close() throws SQLException {
        this.delegate.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.delegate.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.delegate.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.delegate.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.delegate.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.delegate.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.delegate.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.delegate.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.delegate.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.delegate.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.delegate.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.delegate.setCursorName(name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.doExecute(this.getMethod("execute0"), sql);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.delegate.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.delegate.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.delegate.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.delegate.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.delegate.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.delegate.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.delegate.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.delegate.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.delegate.getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (this.batchSqlList == null) {
            this.batchSqlList = new ArrayList<String>();
        }
        this.batchSqlList.add(sql);
        this.delegate.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.batchSqlList != null) {
            this.batchSqlList.clear();
        }
        this.delegate.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.delegate.executeBatch();
    }

    public List<String> getBatchSqlList() {
        return this.batchSqlList;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.delegate.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.delegate.getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.doExecuteUpdate(this.getMethod("executeUpdate1"), sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.doExecuteUpdate(this.getMethod("executeUpdate2"), sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.doExecuteUpdate(this.getMethod("executeUpdate3"), sql, columnNames);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.doExecute(this.getMethod("execute1"), sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.doExecute(this.getMethod("execute2"), sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.doExecute(this.getMethod("execute3"), sql, columnNames);
    }

    private boolean doExecute(Method method, Object ... args) throws SQLException {
        String sql = (String)args[0];
        StatementInterceptorChainImpl chain = new StatementInterceptorChainImpl(sql, new Invocation(method, this.delegate, args));
        try {
            return (Boolean)chain.proceed();
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.delegate.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.delegate.isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.delegate.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.delegate.isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.delegate.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.delegate.isCloseOnCompletion();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.delegate.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.delegate.isWrapperFor(iface);
    }

    class StatementInterceptorChainImpl
    extends BaseStatementInterceptorChain {
        StatementInterceptorChainImpl(String sql, Invocation invocation) {
            super(sql, sql, invocation);
        }

        @Override
        protected void beforeInvoke(Invocation invocation) {
            invocation.getArgs()[0] = this.getProcessingSql();
        }
    }

    abstract class BaseStatementInterceptorChain
    implements Interceptor.Chain {
        private int index = 0;
        private final Invocation invocation;
        private final String sql;
        private String processingSql;

        BaseStatementInterceptorChain(String sql, String processingSql, Invocation invocation) {
            this.sql = sql;
            this.processingSql = processingSql;
            this.invocation = invocation;
        }

        @Override
        public Object proceed() throws Exception {
            if (this.hasNext()) {
                return this.next().intercept(this);
            }
            this.beforeInvoke(this.invocation);
            return this.invocation.invoke();
        }

        abstract void beforeInvoke(Invocation var1) throws Exception;

        @Override
        public boolean hasNext() {
            return ExtendedStatement.this.interceptors != null && this.index < ExtendedStatement.this.interceptors.size();
        }

        @Override
        public Interceptor next() {
            return ExtendedStatement.this.interceptors.get(this.index++);
        }

        @Override
        public String getOriginalSql() {
            return this.sql;
        }

        @Override
        public String getProcessingSql() {
            return this.processingSql;
        }

        @Override
        public void setProcessingSql(String processingSql) {
            this.processingSql = processingSql;
        }

        @Override
        public BaseDataSource getDataSource() {
            return ExtendedStatement.this.conn.getDataSource();
        }

        @Override
        public ExtendedConnection getConnection() {
            return ExtendedStatement.this.conn;
        }

        @Override
        public ExtendedStatement getStatement() {
            return ExtendedStatement.this;
        }
    }
}

