/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.datasource.utils;

import com.alipay.common.tracer.core.utils.AssertUtils;
import com.alipay.common.tracer.core.utils.StringUtils;
import com.alipay.sofa.tracer.plugins.datasource.tracer.Endpoint;
import java.lang.reflect.Method;
import java.security.InvalidParameterException;

public class DataSourceUtils {
    public static final String DS_DRUID_CLASS = "com.alibaba.druid.pool.DruidDataSource";
    public static final String DS_DBCP_CLASS = "org.apache.commons.dbcp.BasicDataSource";
    public static final String DS_C3P0_CLASS = "com.mchange.v2.c3p0.ComboPooledDataSource";
    public static final String DS_TOMCAT_CLASS = "org.apache.tomcat.jdbc.pool.DataSource";
    public static final String DS_HIKARI_CLASS = "com.zaxxer.hikari.HikariDataSource";
    public static final String METHOD_GET_URL = "getUrl";
    public static final String METHOD_SET_URL = "setUrl";
    public static final String METHOD_GET_JDBC_URL = "getJdbcUrl";
    public static final String METHOD_SET_JDBC_URL = "setJdbcUrl";

    public static boolean isDruidDataSource(Object dataSource) {
        return DataSourceUtils.isTargetDataSource(DS_DRUID_CLASS, dataSource);
    }

    public static boolean isDruidDataSource(String clazzType) {
        return !StringUtils.isBlank((String)clazzType) && DS_DRUID_CLASS.equals(clazzType);
    }

    public static boolean isDbcpDataSource(Object dataSource) {
        return DataSourceUtils.isTargetDataSource(DS_DBCP_CLASS, dataSource);
    }

    public static boolean isDbcpDataSource(String clazzType) {
        return !StringUtils.isBlank((String)clazzType) && DS_DBCP_CLASS.equals(clazzType);
    }

    public static boolean isC3p0DataSource(Object dataSource) {
        return DataSourceUtils.isTargetDataSource(DS_C3P0_CLASS, dataSource);
    }

    public static boolean isC3p0DataSource(String clazzType) {
        return !StringUtils.isBlank((String)clazzType) && DS_C3P0_CLASS.equals(clazzType);
    }

    public static boolean isTomcatDataSource(Object dataSource) {
        return DataSourceUtils.isTargetDataSource(DS_TOMCAT_CLASS, dataSource);
    }

    public static boolean isTomcatDataSource(String clazzType) {
        return !StringUtils.isBlank((String)clazzType) && DS_TOMCAT_CLASS.equals(clazzType);
    }

    public static boolean isHikariDataSource(Object dataSource) {
        return DataSourceUtils.isTargetDataSource(DS_HIKARI_CLASS, dataSource);
    }

    public static boolean isHikariDataSource(String clazzType) {
        return !StringUtils.isBlank((String)clazzType) && DS_HIKARI_CLASS.equals(clazzType);
    }

    public static String getJdbcUrl(Object dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException("dataSource is null");
        }
        try {
            Method getUrlMethod;
            if (DataSourceUtils.isDruidDataSource(dataSource) || DataSourceUtils.isDbcpDataSource(dataSource) || DataSourceUtils.isTomcatDataSource(dataSource)) {
                getUrlMethod = dataSource.getClass().getMethod(METHOD_GET_URL, new Class[0]);
            } else if (DataSourceUtils.isC3p0DataSource(dataSource) || DataSourceUtils.isHikariDataSource(dataSource)) {
                getUrlMethod = dataSource.getClass().getMethod(METHOD_GET_JDBC_URL, new Class[0]);
            } else {
                throw new RuntimeException("cannot resolve dataSource type: " + dataSource);
            }
            return (String)getUrlMethod.invoke(dataSource, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("invoke method getUrl failed", e);
        }
    }

    public static void setJdbcUrl(Object dataSource, String url) {
        if (dataSource == null) {
            throw new IllegalArgumentException("dataSource is null");
        }
        if (StringUtils.isBlank((String)url)) {
            throw new IllegalArgumentException("url is null");
        }
        try {
            Method setUrlMethod;
            if (DataSourceUtils.isDruidDataSource(dataSource) || DataSourceUtils.isDbcpDataSource(dataSource) || DataSourceUtils.isTomcatDataSource(dataSource)) {
                setUrlMethod = dataSource.getClass().getMethod(METHOD_SET_URL, String.class);
            } else if (DataSourceUtils.isC3p0DataSource(dataSource) || DataSourceUtils.isHikariDataSource(dataSource)) {
                setUrlMethod = dataSource.getClass().getMethod(METHOD_SET_JDBC_URL, String.class);
            } else {
                throw new RuntimeException("cannot resolve dataSource type: " + dataSource);
            }
            setUrlMethod.invoke(dataSource, url);
        }
        catch (Exception e) {
            throw new RuntimeException("cannot getUrl", e);
        }
    }

    public static String getTomcatJdbcUrlKey() {
        return "url";
    }

    public static String getDbcpJdbcUrlKey() {
        return "url";
    }

    public static String getDruidJdbcUrlKey() {
        return "url";
    }

    public static String getC3p0JdbcUrlKey() {
        return "jdbcUrl";
    }

    public static String getHikariJdbcUrlKey() {
        return "jdbcUrl";
    }

    public static boolean isTargetDataSource(String className, Object dataSource) {
        Class<?> clazz;
        if (dataSource == null) {
            return false;
        }
        try {
            clazz = Class.forName(className, true, DataSourceUtils.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return clazz.isAssignableFrom(dataSource.getClass());
    }

    public static Endpoint getEndpointFromConnectionURL(String connectionURL) {
        int port;
        String host;
        Endpoint endpoint;
        block7: {
            endpoint = new Endpoint();
            host = null;
            port = 0;
            try {
                if (connectionURL.contains("jdbc:oracle:thin:@//")) {
                    int start = "jdbc:oracle:thin:@//".length() + connectionURL.indexOf("jdbc:oracle:thin:@//");
                    int hostEnd = connectionURL.indexOf(58, start);
                    int portEnd = connectionURL.indexOf(47, hostEnd + 1);
                    host = connectionURL.substring(start, hostEnd);
                    port = portEnd > 0 ? Integer.parseInt(connectionURL.substring(hostEnd + 1, portEnd)) : Integer.parseInt(connectionURL.substring(hostEnd + 1));
                    break block7;
                }
                if (connectionURL.contains("jdbc:oracle:thin:@")) {
                    int start = "jdbc:oracle:thin:@".length() + connectionURL.indexOf("jdbc:oracle:thin:@");
                    int hostEnd = connectionURL.indexOf(58, start);
                    int portEnd = connectionURL.indexOf(58, hostEnd + 1);
                    host = connectionURL.substring(start, hostEnd);
                    port = portEnd > 0 ? Integer.parseInt(connectionURL.substring(hostEnd + 1, portEnd)) : Integer.parseInt(connectionURL.substring(hostEnd + 1));
                    break block7;
                }
                if (connectionURL.contains("jdbc:h2:")) {
                    host = connectionURL;
                    port = -1;
                    break block7;
                }
                if (connectionURL.indexOf("://") > 0) {
                    int start = connectionURL.indexOf("://") + 3;
                    int hostEnd = connectionURL.indexOf(58, start);
                    int portEnd = connectionURL.indexOf(47, hostEnd + 1);
                    if (portEnd == -1) {
                        portEnd = connectionURL.indexOf(59, hostEnd + 1);
                    }
                    host = connectionURL.substring(start, hostEnd);
                    port = portEnd > 0 ? Integer.parseInt(connectionURL.substring(hostEnd + 1, portEnd)) : Integer.parseInt(connectionURL.substring(hostEnd + 1));
                    break block7;
                }
                throw new IllegalArgumentException("only support mysql and oracle connectionURL");
            }
            catch (Throwable t) {
                throw new RuntimeException("connectionURL maybe invalid: " + connectionURL, t);
            }
        }
        endpoint.setHost(host);
        endpoint.setPort(port);
        return endpoint;
    }

    public static String resolveDbTypeFromUrl(String url) {
        AssertUtils.isTrue((!StringUtils.isBlank((String)url) ? 1 : 0) != 0, (String)"Jdbc url must not be empty!");
        int start = url.indexOf("jdbc:") + "jdbc:".length();
        if (start < "jdbc:".length()) {
            throw new InvalidParameterException("jdbc url is invalid!");
        }
        int end = url.indexOf(":", start);
        if (end < 0) {
            throw new InvalidParameterException("jdbc url is invalid!");
        }
        String dbType = url.substring(start, end);
        if ("microsoft".equals(dbType)) {
            start = end + 1;
            if ((end = url.indexOf(":", start)) < 0) {
                throw new InvalidParameterException("jdbc url is invalid!");
            }
            return url.substring(start, end);
        }
        return dbType;
    }

    public static String resolveDatabaseFromUrl(String url) {
        int end;
        AssertUtils.isTrue((!StringUtils.isBlank((String)url) ? 1 : 0) != 0, (String)"Jdbc url must not be empty!");
        if ("sqlserver".equals(DataSourceUtils.resolveDbTypeFromUrl(url))) {
            String[] segments;
            for (String segment : segments = url.split(";")) {
                if (!segment.toLowerCase().contains("databasename=")) continue;
                int start = segment.toLowerCase().indexOf("databasename=") + "databasename=".length();
                return segment.substring(start).trim();
            }
            throw new InvalidParameterException("jdbc url is invalid!");
        }
        int start = url.lastIndexOf("/");
        if (start < 0) {
            if ("oracle".equals(DataSourceUtils.resolveDbTypeFromUrl(url))) {
                start = url.lastIndexOf(":");
            } else {
                throw new InvalidParameterException("jdbc url is invalid!");
            }
        }
        if ((end = url.indexOf("?", start)) != -1) {
            return url.substring(start + 1, end);
        }
        return url.substring(start + 1);
    }
}

