/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugin.flexible;

import com.alipay.common.tracer.core.reporter.stat.AbstractSofaTracerStatisticReporter;
import com.alipay.common.tracer.core.reporter.stat.model.StatKey;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.utils.StringUtils;
import com.alipay.common.tracer.core.utils.TracerUtils;
import io.opentracing.tag.Tags;
import java.util.Map;

public class FlexibleStatReporter
extends AbstractSofaTracerStatisticReporter {
    public FlexibleStatReporter(String statTracerName, String rollingPolicy, String logReserveConfig) {
        super(statTracerName, rollingPolicy, logReserveConfig);
    }

    public void doReportStat(SofaTracerSpan sofaTracerSpan) {
        Map tagsWithStr = sofaTracerSpan.getTagsWithStr();
        StatKey statKey = new StatKey();
        String error = (String)tagsWithStr.get(Tags.ERROR.getKey());
        statKey.setKey(this.buildString(new String[]{(String)tagsWithStr.get("local.app"), (String)tagsWithStr.get("method")}));
        statKey.setResult(StringUtils.isBlank((String)error) ? "Y" : "N");
        statKey.setEnd(this.buildString(new String[]{TracerUtils.getLoadTestMark((SofaTracerSpan)sofaTracerSpan)}));
        statKey.setLoadTest(TracerUtils.isLoadTest((SofaTracerSpan)sofaTracerSpan));
        long duration = sofaTracerSpan.getEndTime() - sofaTracerSpan.getStartTime();
        long[] values = new long[]{1L, duration};
        this.addStat(statKey, values);
    }
}

