/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugin.flexible;

import com.alipay.common.tracer.core.SofaTracer;
import com.alipay.common.tracer.core.appender.encoder.SpanEncoder;
import com.alipay.common.tracer.core.appender.self.SelfLog;
import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.context.span.SofaTracerSpanContext;
import com.alipay.common.tracer.core.context.trace.SofaTraceContext;
import com.alipay.common.tracer.core.holder.SofaTraceContextHolder;
import com.alipay.common.tracer.core.reporter.digest.DiskReporterImpl;
import com.alipay.common.tracer.core.reporter.facade.Reporter;
import com.alipay.common.tracer.core.reporter.stat.AbstractSofaTracerStatisticReporter;
import com.alipay.common.tracer.core.reporter.stat.SofaTracerStatisticReporter;
import com.alipay.common.tracer.core.samplers.Sampler;
import com.alipay.common.tracer.core.samplers.SamplerFactory;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.utils.StringUtils;
import com.alipay.sofa.common.code.LogCode2Description;
import com.alipay.sofa.tracer.plugin.flexible.FlexibleDigestEncoder;
import com.alipay.sofa.tracer.plugin.flexible.FlexibleDigestJsonEncoder;
import com.alipay.sofa.tracer.plugin.flexible.FlexibleLogEnum;
import com.alipay.sofa.tracer.plugin.flexible.FlexibleStatJsonReporter;
import com.alipay.sofa.tracer.plugin.flexible.FlexibleStatReporter;
import io.opentracing.Span;
import io.opentracing.tag.Tags;
import java.util.Map;

public class FlexibleTracer
extends SofaTracer {
    private final Reporter reporter;

    public FlexibleTracer(Sampler sampler, Reporter reporter) {
        super("flexible-biz", sampler);
        this.reporter = reporter;
    }

    public FlexibleTracer() {
        super("flexible-biz", null, null, FlexibleTracer.initSampler(), null);
        this.reporter = this.initReporter();
    }

    private static Sampler initSampler() {
        try {
            return SamplerFactory.getSampler();
        }
        catch (Exception e) {
            SelfLog.error((String)LogCode2Description.convert((String)"sofa-tracer", (String)"01-00002"));
            return null;
        }
    }

    public void reportSpan(SofaTracerSpan span) {
        if (span == null) {
            return;
        }
        if (this.getSampler() != null && span.getParentSofaTracerSpan() == null) {
            span.getSofaTracerSpanContext().setSampled(this.getSampler().sample(span).isSampled());
        }
        this.invokeReportListeners(span);
        if (this.reporter != null) {
            this.reporter.report(span);
        } else {
            SelfLog.warn((String)"No reporter implement in flexible tracer");
        }
    }

    public void close() {
        if (this.reporter != null) {
            this.reporter.close();
        }
        super.close();
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    private Reporter initReporter() {
        String logRollingKey = FlexibleLogEnum.FLEXIBLE_DIGEST.getRollingKey();
        String logNameKey = FlexibleLogEnum.FLEXIBLE_DIGEST.getLogNameKey();
        String logName = FlexibleLogEnum.FLEXIBLE_DIGEST.getDefaultLogName();
        String digestRollingPolicy = SofaTracerConfiguration.getRollingPolicy((String)logRollingKey);
        String digestLogReserveConfig = SofaTracerConfiguration.getLogReserveConfig((String)logNameKey);
        SpanEncoder spanEncoder = this.generateAbstractDigestSpanEncoder();
        AbstractSofaTracerStatisticReporter statReporter = this.generateFlexibleStatJsonReporter();
        DiskReporterImpl reporter = new DiskReporterImpl(logName, digestRollingPolicy, digestLogReserveConfig, spanEncoder, (SofaTracerStatisticReporter)statReporter, logNameKey);
        return reporter;
    }

    private SpanEncoder generateAbstractDigestSpanEncoder() {
        if (SofaTracerConfiguration.isJsonOutput()) {
            return new FlexibleDigestJsonEncoder();
        }
        return new FlexibleDigestEncoder();
    }

    private AbstractSofaTracerStatisticReporter generateFlexibleStatJsonReporter() {
        FlexibleLogEnum flexibleLogEnum = FlexibleLogEnum.FLEXIBLE_STAT;
        String statLog = flexibleLogEnum.getDefaultLogName();
        String statRollingPolicy = SofaTracerConfiguration.getRollingPolicy((String)flexibleLogEnum.getRollingKey());
        String statLogReserveConfig = SofaTracerConfiguration.getLogReserveConfig((String)flexibleLogEnum.getLogNameKey());
        if (SofaTracerConfiguration.isJsonOutput()) {
            return new FlexibleStatJsonReporter(statLog, statRollingPolicy, statLogReserveConfig);
        }
        return new FlexibleStatReporter(statLog, statRollingPolicy, statLogReserveConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SofaTracerSpan beforeInvoke(String operationName) {
        SofaTraceContext sofaTraceContext = SofaTraceContextHolder.getSofaTraceContext();
        SofaTracerSpan serverSpan = sofaTraceContext.pop();
        SofaTracerSpan methodSpan = null;
        try {
            methodSpan = (SofaTracerSpan)this.buildSpan(operationName).asChildOf((Span)serverSpan).start();
            methodSpan.setParentSofaTracerSpan(serverSpan);
        }
        catch (Throwable throwable) {
            SelfLog.errorWithTraceId((String)"Client Send Error And Restart by Root Span", (Throwable)throwable);
            SelfLog.flush();
            Map bizBaggage = null;
            Map sysBaggage = null;
            if (serverSpan != null) {
                bizBaggage = serverSpan.getSofaTracerSpanContext().getBizBaggage();
                sysBaggage = serverSpan.getSofaTracerSpanContext().getSysBaggage();
            }
            methodSpan = this.errorSpan(bizBaggage, sysBaggage);
        }
        finally {
            if (methodSpan != null) {
                String appName = SofaTracerConfiguration.getProperty((String)"spring.application.name");
                methodSpan.setTag("local.app", appName);
                methodSpan.setTag("method", operationName);
                methodSpan.setTag(Tags.SPAN_KIND.getKey(), "client");
                methodSpan.setTag("current.thread.name", Thread.currentThread().getName());
                methodSpan.log("cs");
                sofaTraceContext.push(methodSpan);
            }
        }
        return methodSpan;
    }

    public void afterInvoke() {
        this.afterInvoke("");
    }

    public void afterInvoke(String error) {
        SofaTraceContext sofaTraceContext = SofaTraceContextHolder.getSofaTraceContext();
        SofaTracerSpan clientSpan = sofaTraceContext.pop();
        if (clientSpan == null) {
            return;
        }
        if (StringUtils.isBlank((String)error)) {
            clientSpan.setTag("result.code", "00");
        } else {
            clientSpan.setTag("result.code", "99");
        }
        clientSpan.log("cr");
        clientSpan.setTag(Tags.ERROR.getKey(), error);
        clientSpan.finish();
        if (clientSpan.getParentSofaTracerSpan() != null) {
            sofaTraceContext.push(clientSpan.getParentSofaTracerSpan());
        }
    }

    private SofaTracerSpan errorSpan(Map<String, String> bizBaggage, Map<String, String> sysBaggage) {
        SofaTracerSpanContext spanContext = SofaTracerSpanContext.rootStart();
        spanContext.addBizBaggage(bizBaggage);
        spanContext.addSysBaggage(sysBaggage);
        return new SofaTracerSpan((SofaTracer)this, System.currentTimeMillis(), null, "", spanContext, null);
    }
}

