/*
 * Decompiled with CFR 0.152.
 */
package com.sofa.alipay.tracer.plugins.kafkamq.consumer;

import com.alipay.common.tracer.core.SofaTracer;
import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.context.span.SofaTracerSpanContext;
import com.alipay.common.tracer.core.registry.ExtendFormat;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.sofa.alipay.tracer.plugins.kafkamq.carrier.KafkaMqExtractCarrier;
import com.sofa.alipay.tracer.plugins.kafkamq.tracers.KafkaMQConsumeTracer;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Headers;

public class SofaTracerKafkaConsumer<K, V>
implements Consumer<K, V> {
    private KafkaMQConsumeTracer kafkaMQConsumeTracer;
    private final Consumer<K, V> consumer;

    public SofaTracerKafkaConsumer(Consumer<K, V> consumer, KafkaMQConsumeTracer kafkaMQConsumeTracer) {
        this.consumer = consumer;
        this.kafkaMQConsumeTracer = kafkaMQConsumeTracer;
    }

    public SofaTracerKafkaConsumer(Consumer<K, V> consumer) {
        this.consumer = consumer;
        this.kafkaMQConsumeTracer = KafkaMQConsumeTracer.getKafkaMQConsumeTracerSingleton();
    }

    public Set<TopicPartition> assignment() {
        return this.consumer.assignment();
    }

    public Set<String> subscription() {
        return this.consumer.subscription();
    }

    public void subscribe(Collection<String> topics) {
        this.consumer.subscribe(topics);
    }

    public void subscribe(Collection<String> topics, ConsumerRebalanceListener callback) {
        this.consumer.subscribe(topics, callback);
    }

    public void assign(Collection<TopicPartition> partitions) {
        this.consumer.assign(partitions);
    }

    public void subscribe(Pattern pattern, ConsumerRebalanceListener callback) {
        this.consumer.subscribe(pattern, callback);
    }

    public void subscribe(Pattern pattern) {
        this.consumer.subscribe(pattern);
    }

    public void unsubscribe() {
        this.consumer.unsubscribe();
    }

    @Deprecated
    public ConsumerRecords<K, V> poll(long timeout) {
        ConsumerRecords records = this.consumer.poll(timeout);
        for (ConsumerRecord record : records) {
            this.appendSpanAndServerReceive(record);
        }
        return records;
    }

    public ConsumerRecords<K, V> poll(Duration timeout) {
        ConsumerRecords records = this.consumer.poll(timeout);
        for (ConsumerRecord record : records) {
            this.appendSpanAndServerReceive(record);
        }
        return records;
    }

    public void commitSync() {
        this.consumer.commitSync();
    }

    public void commitSync(Duration timeout) {
        this.consumer.commitSync(timeout);
    }

    public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets) {
        this.consumer.commitSync(offsets);
    }

    public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets, Duration timeout) {
        this.consumer.commitSync(offsets, timeout);
    }

    public void commitAsync() {
        this.consumer.commitSync();
    }

    public void commitAsync(OffsetCommitCallback callback) {
        this.consumer.commitAsync(callback);
    }

    public void commitAsync(Map<TopicPartition, OffsetAndMetadata> offsets, OffsetCommitCallback callback) {
        this.consumer.commitAsync(offsets, callback);
    }

    public void seek(TopicPartition partition, long offset) {
        this.consumer.seek(partition, offset);
    }

    public void seek(TopicPartition topicPartition, OffsetAndMetadata offsetAndMetadata) {
        this.consumer.seek(topicPartition, offsetAndMetadata);
    }

    public void seekToBeginning(Collection<TopicPartition> partitions) {
        this.consumer.seekToBeginning(partitions);
    }

    public void seekToEnd(Collection<TopicPartition> partitions) {
        this.consumer.seekToEnd(partitions);
    }

    public long position(TopicPartition partition) {
        return this.consumer.position(partition);
    }

    public long position(TopicPartition partition, Duration timeout) {
        return this.consumer.position(partition, timeout);
    }

    public OffsetAndMetadata committed(TopicPartition partition) {
        return this.consumer.committed(partition);
    }

    public OffsetAndMetadata committed(TopicPartition partition, Duration timeout) {
        return this.consumer.committed(partition, timeout);
    }

    public Map<TopicPartition, OffsetAndMetadata> committed(Set<TopicPartition> set) {
        return null;
    }

    public Map<TopicPartition, OffsetAndMetadata> committed(Set<TopicPartition> set, Duration duration) {
        return null;
    }

    public Map<MetricName, ? extends Metric> metrics() {
        return this.consumer.metrics();
    }

    public List<PartitionInfo> partitionsFor(String topic) {
        return this.consumer.partitionsFor(topic);
    }

    public List<PartitionInfo> partitionsFor(String topic, Duration timeout) {
        return this.consumer.partitionsFor(topic, timeout);
    }

    public Map<String, List<PartitionInfo>> listTopics() {
        return this.consumer.listTopics();
    }

    public Map<String, List<PartitionInfo>> listTopics(Duration timeout) {
        return this.consumer.listTopics(timeout);
    }

    public Set<TopicPartition> paused() {
        return this.consumer.paused();
    }

    public void pause(Collection<TopicPartition> partitions) {
        this.consumer.pause(partitions);
    }

    public void resume(Collection<TopicPartition> partitions) {
        this.consumer.resume(partitions);
    }

    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestampsToSearch) {
        return this.consumer.offsetsForTimes(timestampsToSearch);
    }

    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestampsToSearch, Duration timeout) {
        return this.consumer.offsetsForTimes(timestampsToSearch, timeout);
    }

    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions) {
        return this.consumer.beginningOffsets(partitions);
    }

    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions, Duration timeout) {
        return this.consumer.beginningOffsets(partitions, timeout);
    }

    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions) {
        return this.consumer.endOffsets(partitions);
    }

    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions, Duration timeout) {
        return this.consumer.endOffsets(partitions, timeout);
    }

    public OptionalLong currentLag(TopicPartition topicPartition) {
        return this.consumer.currentLag(topicPartition);
    }

    public ConsumerGroupMetadata groupMetadata() {
        return this.consumer.groupMetadata();
    }

    public void enforceRebalance() {
        this.consumer.enforceRebalance();
    }

    public void enforceRebalance(String s) {
        this.consumer.enforceRebalance();
    }

    public void close() {
        this.consumer.close();
    }

    public void close(Duration timeout) {
        this.consumer.close(timeout);
    }

    public void wakeup() {
        this.consumer.wakeup();
    }

    private void appendSpanAndServerReceive(ConsumerRecord<K, V> record) {
        if (null == this.kafkaMQConsumeTracer) {
            this.kafkaMQConsumeTracer = KafkaMQConsumeTracer.getKafkaMQConsumeTracerSingleton();
        }
        SofaTracerSpanContext spanContext = this.getSpanContextFromHeaders(record.headers());
        SofaTracerSpan sofaTracerSpan = this.kafkaMQConsumeTracer.serverReceive(spanContext);
        this.appendSpanTags(sofaTracerSpan, record);
    }

    private void appendSpanTags(SofaTracerSpan tracerSpan, ConsumerRecord<K, V> record) {
        tracerSpan.setTag("current.thread.name", Thread.currentThread().getName());
        tracerSpan.setTag("local.app", SofaTracerConfiguration.getProperty((String)"spring.application.name"));
        tracerSpan.setTag("kafka.topic", record.topic());
        tracerSpan.setTag("kafka.partition", (Number)record.partition());
        tracerSpan.setTag("kafka.offset", (Number)record.offset());
    }

    private SofaTracerSpanContext getSpanContextFromHeaders(Headers headers) {
        SofaTracer sofaTracer = this.kafkaMQConsumeTracer.getSofaTracer();
        SofaTracerSpanContext spanContext = (SofaTracerSpanContext)sofaTracer.extract(ExtendFormat.Builtin.B3_TEXT_MAP, (Object)new KafkaMqExtractCarrier(headers));
        return spanContext;
    }
}

