/*
 * Decompiled with CFR 0.152.
 */
package com.sofa.alipay.tracer.plugins.kafkamq.repoters;

import com.alipay.common.tracer.core.reporter.stat.AbstractSofaTracerStatisticReporter;
import com.alipay.common.tracer.core.reporter.stat.model.StatKey;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.utils.TracerUtils;
import java.util.Map;

public class KafkaMQSendStatReporter
extends AbstractSofaTracerStatisticReporter {
    public KafkaMQSendStatReporter(String statTracerName, String rollingPolicy, String logReserveConfig) {
        super(statTracerName, rollingPolicy, logReserveConfig);
    }

    public void doReportStat(SofaTracerSpan sofaTracerSpan) {
        Map tagsWithStr = sofaTracerSpan.getTagsWithStr();
        Map tagsWithNumber = sofaTracerSpan.getTagsWithNumber();
        StatKey statKey = new StatKey();
        String localApp = (String)tagsWithStr.get("local.app");
        String topic = (String)tagsWithStr.get("kafka.topic");
        String partition = String.valueOf(tagsWithNumber.get("kafka.partition"));
        statKey.setKey(this.buildString(new String[]{localApp, topic, partition}));
        String resultCode = (String)tagsWithStr.get("result.code");
        boolean success = this.isMQSimpleSuccess(resultCode);
        statKey.setResult(success ? "Y" : "N");
        statKey.setEnd(this.buildString(new String[]{TracerUtils.getLoadTestMark((SofaTracerSpan)sofaTracerSpan)}));
        statKey.setLoadTest(TracerUtils.isLoadTest((SofaTracerSpan)sofaTracerSpan));
        long duration = sofaTracerSpan.getEndTime() - sofaTracerSpan.getStartTime();
        long[] values = new long[]{1L, duration};
        this.addStat(statKey, values);
    }
}

