/*
 * Decompiled with CFR 0.152.
 */
package com.sofa.alipay.tracer.plugins.kafkamq.tracers;

import com.alipay.common.tracer.core.appender.encoder.SpanEncoder;
import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.reporter.stat.AbstractSofaTracerStatisticReporter;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.tracer.AbstractServerTracer;
import com.sofa.alipay.tracer.plugins.kafkamq.encoders.KafkaMQConsumeDigestEncoder;
import com.sofa.alipay.tracer.plugins.kafkamq.encoders.KafkaMQConsumeDigestJsonEncoder;
import com.sofa.alipay.tracer.plugins.kafkamq.enums.KafkaMqLogEnum;
import com.sofa.alipay.tracer.plugins.kafkamq.repoters.KafkaMQConsumeStatJsonReporter;
import com.sofa.alipay.tracer.plugins.kafkamq.repoters.KafkaMQConsumeStatReporter;

public class KafkaMQConsumeTracer
extends AbstractServerTracer {
    private static volatile KafkaMQConsumeTracer kafkaMQConsumeTracer;

    public KafkaMQConsumeTracer() {
        super("kafkamq-consume");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KafkaMQConsumeTracer getKafkaMQConsumeTracerSingleton() {
        if (kafkaMQConsumeTracer != null) return kafkaMQConsumeTracer;
        Class<KafkaMQConsumeTracer> clazz = KafkaMQConsumeTracer.class;
        synchronized (KafkaMQConsumeTracer.class) {
            if (kafkaMQConsumeTracer != null) return kafkaMQConsumeTracer;
            kafkaMQConsumeTracer = new KafkaMQConsumeTracer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return kafkaMQConsumeTracer;
        }
    }

    protected String getServerDigestReporterLogName() {
        return KafkaMqLogEnum.MQ_CONSUME_DIGEST.getDefaultLogName();
    }

    protected String getServerDigestReporterRollingKey() {
        return KafkaMqLogEnum.MQ_CONSUME_DIGEST.getRollingKey();
    }

    protected String getServerDigestReporterLogNameKey() {
        return KafkaMqLogEnum.MQ_CONSUME_DIGEST.getLogNameKey();
    }

    protected SpanEncoder<SofaTracerSpan> getServerDigestEncoder() {
        if (SofaTracerConfiguration.isJsonOutput()) {
            return new KafkaMQConsumeDigestJsonEncoder();
        }
        return new KafkaMQConsumeDigestEncoder();
    }

    protected AbstractSofaTracerStatisticReporter generateServerStatReporter() {
        KafkaMqLogEnum logEnum = KafkaMqLogEnum.MQ_CONSUME_STAT;
        String statLog = logEnum.getDefaultLogName();
        String statRollingPolicy = SofaTracerConfiguration.getRollingPolicy((String)logEnum.getRollingKey());
        String statLogReserveConfig = SofaTracerConfiguration.getLogReserveConfig((String)logEnum.getLogNameKey());
        return this.getStatJsonReporter(statLog, statRollingPolicy, statLogReserveConfig);
    }

    protected AbstractSofaTracerStatisticReporter getStatJsonReporter(String statTracerName, String statRollingPolicy, String statLogReserveConfig) {
        if (SofaTracerConfiguration.isJsonOutput()) {
            return new KafkaMQConsumeStatJsonReporter(statTracerName, statRollingPolicy, statLogReserveConfig);
        }
        return new KafkaMQConsumeStatReporter(statTracerName, statRollingPolicy, statLogReserveConfig);
    }
}

