/*
 * Decompiled with CFR 0.152.
 */
package com.sofa.alipay.tracer.plugins.kafkamq.tracers;

import com.alipay.common.tracer.core.appender.encoder.SpanEncoder;
import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.reporter.stat.AbstractSofaTracerStatisticReporter;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.tracer.AbstractClientTracer;
import com.sofa.alipay.tracer.plugins.kafkamq.encoders.KafkaMQSendDigestEncoder;
import com.sofa.alipay.tracer.plugins.kafkamq.encoders.KafkaMQSendDigestJsonEncoder;
import com.sofa.alipay.tracer.plugins.kafkamq.enums.KafkaMqLogEnum;
import com.sofa.alipay.tracer.plugins.kafkamq.repoters.KafkaMQSendStatJsonReporter;
import com.sofa.alipay.tracer.plugins.kafkamq.repoters.KafkaMQSendStatReporter;

public class KafkaMQSendTracer
extends AbstractClientTracer {
    private static volatile KafkaMQSendTracer kafkaMQSendTracer;

    public KafkaMQSendTracer() {
        super("kafkamq-send");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KafkaMQSendTracer getKafkaMQSendTracerSingleton() {
        if (kafkaMQSendTracer != null) return kafkaMQSendTracer;
        Class<KafkaMQSendTracer> clazz = KafkaMQSendTracer.class;
        synchronized (KafkaMQSendTracer.class) {
            if (kafkaMQSendTracer != null) return kafkaMQSendTracer;
            kafkaMQSendTracer = new KafkaMQSendTracer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return kafkaMQSendTracer;
        }
    }

    protected String getClientDigestReporterLogName() {
        return KafkaMqLogEnum.MQ_SEND_DIGEST.getDefaultLogName();
    }

    protected String getClientDigestReporterRollingKey() {
        return KafkaMqLogEnum.MQ_SEND_DIGEST.getRollingKey();
    }

    protected String getClientDigestReporterLogNameKey() {
        return KafkaMqLogEnum.MQ_SEND_DIGEST.getLogNameKey();
    }

    protected SpanEncoder<SofaTracerSpan> getClientDigestEncoder() {
        if (SofaTracerConfiguration.isJsonOutput()) {
            return new KafkaMQSendDigestJsonEncoder();
        }
        return new KafkaMQSendDigestEncoder();
    }

    protected AbstractSofaTracerStatisticReporter generateClientStatReporter() {
        KafkaMqLogEnum logEnum = KafkaMqLogEnum.MQ_SEND_STAT;
        String statLog = logEnum.getDefaultLogName();
        String statRollingPolicy = SofaTracerConfiguration.getRollingPolicy((String)logEnum.getRollingKey());
        String statLogReserveConfig = SofaTracerConfiguration.getLogReserveConfig((String)logEnum.getLogNameKey());
        return this.getStatJsonReporter(statLog, statRollingPolicy, statLogReserveConfig);
    }

    protected AbstractSofaTracerStatisticReporter getStatJsonReporter(String statTracerName, String statRollingPolicy, String statLogReserveConfig) {
        if (SofaTracerConfiguration.isJsonOutput()) {
            return new KafkaMQSendStatJsonReporter(statTracerName, statRollingPolicy, statLogReserveConfig);
        }
        return new KafkaMQSendStatReporter(statTracerName, statRollingPolicy, statLogReserveConfig);
    }
}

