/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.mongodb;

import com.alipay.common.tracer.core.context.trace.SofaTraceContext;
import com.alipay.common.tracer.core.holder.SofaTraceContextHolder;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.sofa.tracer.plugins.mongodb.tracers.MongoClientTracer;
import com.mongodb.event.CommandFailedEvent;
import com.mongodb.event.CommandListener;
import com.mongodb.event.CommandStartedEvent;
import com.mongodb.event.CommandSucceededEvent;
import io.opentracing.tag.Tags;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SofaTracerCommandListener
implements CommandListener {
    public static final String COMPONENT_NAME = "mongodb";
    private final MongoClientTracer mongoClientTracer;
    private final String applicationName;
    private final Map<Integer, SofaTracerSpan> cache = new ConcurrentHashMap<Integer, SofaTracerSpan>();

    public SofaTracerCommandListener(String applicationName) {
        this.mongoClientTracer = MongoClientTracer.getMongoClientTracerSingleton();
        this.applicationName = applicationName;
    }

    public void commandStarted(CommandStartedEvent event) {
        this.buildSpan(event);
        SofaTraceContext sofaTraceContext = SofaTraceContextHolder.getSofaTraceContext();
        SofaTracerSpan sofaTracerSpan = sofaTraceContext.pop();
        if (sofaTracerSpan == null) {
            return;
        }
        if (sofaTracerSpan.getParentSofaTracerSpan() != null) {
            sofaTraceContext.push(sofaTracerSpan.getParentSofaTracerSpan());
        }
        if (sofaTracerSpan != null) {
            this.cache.put(event.getRequestId(), sofaTracerSpan);
        }
    }

    public void commandSucceeded(CommandSucceededEvent event) {
        SofaTracerSpan span = this.cache.remove(event.getRequestId());
        if (span != null) {
            this.finishSpan(span, null);
        }
    }

    public void commandFailed(CommandFailedEvent event) {
        SofaTracerSpan span = this.cache.remove(event.getRequestId());
        if (span != null) {
            this.finishSpan(span, event.getThrowable());
        }
    }

    private SofaTracerSpan buildSpan(CommandStartedEvent event) {
        SofaTracerSpan sofaTracerSpan = this.mongoClientTracer.clientSend(event.getCommandName());
        this.decorate(sofaTracerSpan, event);
        return sofaTracerSpan;
    }

    private void finishSpan(SofaTracerSpan sofaTracerSpan, Throwable throwable) {
        if (sofaTracerSpan == null) {
            return;
        }
        String resultCode = "00";
        if (throwable != null) {
            resultCode = "99";
            String message = throwable.getMessage();
            if (message == null) {
                message = throwable.getClass().getName();
            }
            sofaTracerSpan.setTag(Tags.ERROR.getKey(), message);
            sofaTracerSpan.log(this.errorLogs(throwable));
        }
        this.mongoClientTracer.clientReceiveTagFinish(sofaTracerSpan, resultCode);
    }

    private void decorate(SofaTracerSpan span, CommandStartedEvent event) {
        String command = event.getCommandName();
        span.setTag(Tags.COMPONENT.getKey(), COMPONENT_NAME);
        span.setTag(Tags.DB_STATEMENT.getKey(), event.getCommand().toString());
        span.setTag(Tags.DB_INSTANCE.getKey(), event.getDatabaseName());
        span.setTag(Tags.PEER_HOSTNAME.getKey(), event.getConnectionDescription().getServerAddress().getHost());
        InetSocketAddress address = event.getConnectionDescription().getServerAddress().getSocketAddress();
        if (address != null) {
            span.setTag("peer.host", address.toString());
        }
        span.setTag(Tags.PEER_PORT.getKey(), (Number)event.getConnectionDescription().getServerAddress().getPort());
        span.setTag(Tags.DB_TYPE.getKey(), COMPONENT_NAME);
        span.setTag("method", command);
        span.setTag("local.app", this.applicationName);
    }

    private Map<String, Object> errorLogs(Throwable throwable) {
        HashMap<String, Object> errorLogs = new HashMap<String, Object>(4);
        errorLogs.put("event", Tags.ERROR.getKey());
        errorLogs.put("error.kind", throwable.getClass().getName());
        errorLogs.put("error.object", throwable);
        errorLogs.put("message", throwable.getMessage());
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        errorLogs.put("stack", sw.toString());
        return errorLogs;
    }
}

