/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.mongodb;

import com.alipay.sofa.tracer.plugins.mongodb.SofaTracerCommandListener;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.MongoDriverInformation;
import com.mongodb.ServerAddress;
import com.mongodb.event.CommandListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SofaTracerMongoClient
extends MongoClient {
    public SofaTracerMongoClient(SofaTracerCommandListener listener) {
        this(listener, new ServerAddress());
    }

    public SofaTracerMongoClient(SofaTracerCommandListener listener, String host) {
        this(listener, new ServerAddress(host));
    }

    public SofaTracerMongoClient(SofaTracerCommandListener listener, String host, MongoClientOptions options) {
        this(listener, new ServerAddress(host), options);
    }

    public SofaTracerMongoClient(SofaTracerCommandListener listener, String host, int port) {
        this(listener, new ServerAddress(host, port));
    }

    public SofaTracerMongoClient(SofaTracerCommandListener listener, ServerAddress addr) {
        this(listener, addr, new MongoClientOptions.Builder().build());
    }

    public SofaTracerMongoClient(SofaTracerCommandListener listener, ServerAddress addr, List<MongoCredential> credentialsList) {
        this(listener, addr, credentialsList, new MongoClientOptions.Builder().build());
    }

    public SofaTracerMongoClient(SofaTracerCommandListener listener, ServerAddress addr, MongoClientOptions options) {
        super(addr, MongoClientOptions.builder((MongoClientOptions)options).addCommandListener((CommandListener)listener).build());
    }

    public SofaTracerMongoClient(SofaTracerCommandListener listener, ServerAddress addr, List<MongoCredential> credentialsList, MongoClientOptions options) {
        super(addr, credentialsList, MongoClientOptions.builder((MongoClientOptions)options).addCommandListener((CommandListener)listener).build());
    }

    public SofaTracerMongoClient(SofaTracerCommandListener listener, ServerAddress addr, MongoCredential credential, MongoClientOptions options) {
        super(addr, credential, MongoClientOptions.builder((MongoClientOptions)options).addCommandListener((CommandListener)listener).build());
    }

    public SofaTracerMongoClient(SofaTracerCommandListener listener, List<ServerAddress> seeds) {
        this(listener, seeds, new MongoClientOptions.Builder().build());
    }

    public SofaTracerMongoClient(SofaTracerCommandListener listener, List<ServerAddress> seeds, List<MongoCredential> credentialsList) {
        this(listener, seeds, credentialsList, new MongoClientOptions.Builder().build());
    }

    public SofaTracerMongoClient(SofaTracerCommandListener listener, List<ServerAddress> seeds, MongoClientOptions options) {
        super(seeds, MongoClientOptions.builder((MongoClientOptions)options).addCommandListener((CommandListener)listener).build());
    }

    public SofaTracerMongoClient(SofaTracerCommandListener listener, List<ServerAddress> seeds, List<MongoCredential> credentialsList, MongoClientOptions options) {
        super(seeds, credentialsList, MongoClientOptions.builder((MongoClientOptions)options).addCommandListener((CommandListener)listener).build());
    }

    public SofaTracerMongoClient(SofaTracerCommandListener listener, List<ServerAddress> seeds, MongoCredential credential, MongoClientOptions options) {
        super(seeds, credential, MongoClientOptions.builder((MongoClientOptions)options).addCommandListener((CommandListener)listener).build());
    }

    public SofaTracerMongoClient(SofaTracerCommandListener listener, MongoClientURI uri) {
        this(listener, uri, null);
    }

    public SofaTracerMongoClient(SofaTracerCommandListener listener, List<ServerAddress> seeds, MongoCredential credential, MongoClientOptions options, MongoDriverInformation mongoDriverInformation) {
        super(seeds, credential, MongoClientOptions.builder((MongoClientOptions)options).addCommandListener((CommandListener)listener).build(), mongoDriverInformation);
    }

    public SofaTracerMongoClient(SofaTracerCommandListener listener, MongoClientURI uri, MongoDriverInformation mongoDriverInformation) {
        this(listener, SofaTracerMongoClient.toServerAddressList(uri.getHosts()), uri.getCredentials() != null ? Collections.singletonList(uri.getCredentials()) : Collections.emptyList(), uri.getOptions(), mongoDriverInformation);
    }

    public SofaTracerMongoClient(SofaTracerCommandListener listener, ServerAddress addr, List<MongoCredential> credentialsList, MongoClientOptions options, MongoDriverInformation mongoDriverInformation) {
        super(addr, credentialsList, MongoClientOptions.builder((MongoClientOptions)options).addCommandListener((CommandListener)listener).build(), mongoDriverInformation);
    }

    public SofaTracerMongoClient(SofaTracerCommandListener listener, List<ServerAddress> seeds, List<MongoCredential> credentialsList, MongoClientOptions options, MongoDriverInformation mongoDriverInformation) {
        super(seeds, credentialsList, MongoClientOptions.builder((MongoClientOptions)options).addCommandListener((CommandListener)listener).build(), mongoDriverInformation);
    }

    private static List<ServerAddress> toServerAddressList(List<String> hosts) {
        ArrayList<ServerAddress> list = new ArrayList<ServerAddress>();
        for (String host : hosts) {
            list.add(new ServerAddress(host));
        }
        return list;
    }
}

