/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.mongodb.tracers;

import com.alipay.common.tracer.core.appender.encoder.SpanEncoder;
import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.reporter.stat.AbstractSofaTracerStatisticReporter;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.tracer.AbstractClientTracer;
import com.alipay.sofa.tracer.plugins.mongodb.encodes.MongoDigestEncoder;
import com.alipay.sofa.tracer.plugins.mongodb.encodes.MongoDigestJsonEncoder;
import com.alipay.sofa.tracer.plugins.mongodb.enums.MongoClientLogEnum;
import com.alipay.sofa.tracer.plugins.mongodb.repoters.MongoStatJsonReporter;
import com.alipay.sofa.tracer.plugins.mongodb.repoters.MongoStatReporter;

public class MongoClientTracer
extends AbstractClientTracer {
    private static volatile MongoClientTracer mongoClientTracer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MongoClientTracer getMongoClientTracerSingleton() {
        if (mongoClientTracer != null) return mongoClientTracer;
        Class<MongoClientTracer> clazz = MongoClientTracer.class;
        synchronized (MongoClientTracer.class) {
            if (mongoClientTracer != null) return mongoClientTracer;
            mongoClientTracer = new MongoClientTracer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mongoClientTracer;
        }
    }

    protected MongoClientTracer() {
        super("mongo-client");
    }

    protected String getClientDigestReporterLogName() {
        return MongoClientLogEnum.MONGO_CLIENT_DIGEST.getDefaultLogName();
    }

    protected String getClientDigestReporterRollingKey() {
        return MongoClientLogEnum.MONGO_CLIENT_DIGEST.getRollingKey();
    }

    protected String getClientDigestReporterLogNameKey() {
        return MongoClientLogEnum.MONGO_CLIENT_DIGEST.getLogNameKey();
    }

    protected SpanEncoder<SofaTracerSpan> getClientDigestEncoder() {
        if (SofaTracerConfiguration.isJsonOutput()) {
            return new MongoDigestJsonEncoder();
        }
        return new MongoDigestEncoder();
    }

    protected AbstractSofaTracerStatisticReporter generateClientStatReporter() {
        MongoClientLogEnum logEnum = MongoClientLogEnum.MONGO_CLIENT_STAT;
        String statLog = logEnum.getDefaultLogName();
        String statRollingPolicy = SofaTracerConfiguration.getRollingPolicy((String)logEnum.getRollingKey());
        String statLogReserveConfig = SofaTracerConfiguration.getLogReserveConfig((String)logEnum.getLogNameKey());
        return this.getStatJsonReporter(statLog, statRollingPolicy, statLogReserveConfig);
    }

    protected AbstractSofaTracerStatisticReporter getStatJsonReporter(String statTracerName, String statRollingPolicy, String statLogReserveConfig) {
        if (SofaTracerConfiguration.isJsonOutput()) {
            return new MongoStatJsonReporter(statTracerName, statRollingPolicy, statLogReserveConfig);
        }
        return new MongoStatReporter(statTracerName, statRollingPolicy, statLogReserveConfig);
    }
}

