/*
 * Decompiled with CFR 0.152.
 */
package com.sofa.alipay.tracer.plugins.spring.redis;

import com.sofa.alipay.tracer.plugins.spring.redis.common.RedisActionWrapperHelper;
import com.sofa.alipay.tracer.plugins.spring.redis.connections.TracingReactiveRedisClusterConnection;
import com.sofa.alipay.tracer.plugins.spring.redis.connections.TracingReactiveRedisConnection;
import com.sofa.alipay.tracer.plugins.spring.redis.connections.TracingRedisClusterConnection;
import com.sofa.alipay.tracer.plugins.spring.redis.connections.TracingRedisConnection;
import com.sofa.alipay.tracer.plugins.spring.redis.connections.TracingRedisSentinelConnection;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.ReactiveRedisClusterConnection;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisSentinelConnection;

public class TracingRedisConnectionFactory
implements RedisConnectionFactory,
ReactiveRedisConnectionFactory {
    private final RedisConnectionFactory delegate;
    private final RedisActionWrapperHelper actionWrapper;

    public TracingRedisConnectionFactory(RedisConnectionFactory delegate, RedisActionWrapperHelper actionWrapper) {
        this.delegate = delegate;
        this.actionWrapper = actionWrapper;
    }

    public RedisConnection getConnection() {
        RedisConnection connection = this.delegate.getConnection();
        if (connection instanceof RedisClusterConnection) {
            return new TracingRedisClusterConnection((RedisClusterConnection)connection, this.actionWrapper);
        }
        return new TracingRedisConnection(connection, this.actionWrapper);
    }

    public RedisClusterConnection getClusterConnection() {
        return new TracingRedisClusterConnection(this.delegate.getClusterConnection(), this.actionWrapper);
    }

    public boolean getConvertPipelineAndTxResults() {
        return this.delegate.getConvertPipelineAndTxResults();
    }

    public RedisSentinelConnection getSentinelConnection() {
        return new TracingRedisSentinelConnection(this.delegate.getSentinelConnection(), this.actionWrapper);
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException e) {
        return this.delegate.translateExceptionIfPossible(e);
    }

    public ReactiveRedisConnection getReactiveConnection() {
        if (this.delegate instanceof ReactiveRedisConnectionFactory) {
            ReactiveRedisConnectionFactory connectionFactory = (ReactiveRedisConnectionFactory)this.delegate;
            ReactiveRedisConnection connection = connectionFactory.getReactiveConnection();
            if (connection instanceof ReactiveRedisClusterConnection) {
                return new TracingReactiveRedisClusterConnection((ReactiveRedisClusterConnection)connection, this.actionWrapper);
            }
            return new TracingReactiveRedisConnection(connectionFactory.getReactiveConnection(), this.actionWrapper);
        }
        return null;
    }

    public ReactiveRedisClusterConnection getReactiveClusterConnection() {
        if (this.delegate instanceof ReactiveRedisConnectionFactory) {
            return ((ReactiveRedisConnectionFactory)this.delegate).getReactiveClusterConnection();
        }
        return null;
    }
}

