/*
 * Decompiled with CFR 0.152.
 */
package com.sofa.alipay.tracer.plugins.spring.redis.common;

import com.alipay.common.tracer.core.SofaTracer;
import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.holder.SofaTraceContextHolder;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.sofa.alipay.tracer.plugins.spring.redis.common.Action;
import com.sofa.alipay.tracer.plugins.spring.redis.common.ThrowingAction;
import com.sofa.alipay.tracer.plugins.spring.redis.common.ThrowingSupplier;
import com.sofa.alipay.tracer.plugins.spring.redis.tracer.RedisSofaTracer;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;

public class RedisActionWrapperHelper {
    public static final String COMMAND = "command";
    public static final String COMPONENT_NAME = "java-redis";
    public static final String DB_TYPE = "redis";
    protected final SofaTracer tracer;
    private final RedisSofaTracer redisSofaTracer = RedisSofaTracer.getRedisSofaTracerSingleton();
    private String appName;

    public RedisActionWrapperHelper() {
        this.tracer = this.redisSofaTracer.getSofaTracer();
    }

    private static String deserialize(byte[] bytes) {
        return bytes == null ? "" : new String(bytes, StandardCharsets.UTF_8);
    }

    public <T> T doInScope(String command, byte[] key, Supplier<T> supplier) {
        Span span = this.buildSpan(command, RedisActionWrapperHelper.deserialize(key));
        return this.activateAndCloseSpan(span, supplier);
    }

    public <T> T doInScope(String command, Supplier<T> supplier) {
        Span span = this.buildSpan(command);
        return this.activateAndCloseSpan(span, supplier);
    }

    public void doInScope(String command, byte[] key, Runnable runnable) {
        Span span = this.buildSpan(command, RedisActionWrapperHelper.deserialize(key));
        this.activateAndCloseSpan(span, runnable);
    }

    public void doInScope(String command, Runnable runnable) {
        Span span = this.buildSpan(command);
        this.activateAndCloseSpan(span, runnable);
    }

    public <T> T doInScope(String command, byte[][] keys, Supplier<T> supplier) {
        Span span = this.buildSpan(command);
        span.setTag("keys", RedisActionWrapperHelper.toStringWithDeserialization((byte[][])this.limitKeys((T[])keys)));
        return this.activateAndCloseSpan(span, supplier);
    }

    <T> T[] limitKeys(T[] keys) {
        if (keys != null && keys.length > 1024) {
            return Arrays.copyOfRange(keys, 0, 1024);
        }
        return keys;
    }

    public <T> T decorate(Supplier<T> supplier, String operateName) {
        Span span = this.buildSpan(operateName);
        Throwable candidateThrowable = null;
        try {
            T t = supplier.get();
            return t;
        }
        catch (Throwable t) {
            candidateThrowable = t;
            throw t;
        }
        finally {
            if (candidateThrowable != null) {
                span.setTag(Tags.ERROR.getKey(), candidateThrowable.getMessage());
                this.redisSofaTracer.clientReceive("99");
            } else {
                this.redisSofaTracer.clientReceive("00");
            }
        }
    }

    public void decorate(Action action, String operateName) {
        Span span = this.buildSpan(operateName);
        Throwable candidateThrowable = null;
        try {
            action.execute();
        }
        catch (Throwable t) {
            candidateThrowable = t;
            throw t;
        }
        finally {
            if (candidateThrowable != null) {
                span.setTag(Tags.ERROR.getKey(), candidateThrowable.getMessage());
                this.redisSofaTracer.clientReceive("99");
            } else {
                this.redisSofaTracer.clientReceive("00");
            }
        }
    }

    public <T extends Exception> void decorateThrowing(ThrowingAction<T> action, String operateName) throws T {
        Span span = this.buildSpan(operateName);
        Throwable candidateThrowable = null;
        try {
            action.execute();
        }
        catch (Throwable t) {
            candidateThrowable = t;
            throw t;
        }
        finally {
            if (candidateThrowable != null) {
                span.setTag(Tags.ERROR.getKey(), candidateThrowable.getMessage());
                this.redisSofaTracer.clientReceive("99");
            } else {
                this.redisSofaTracer.clientReceive("00");
            }
        }
    }

    public <T extends Exception, V> V decorateThrowing(ThrowingSupplier<T, V> supplier, String operateName) throws T {
        Span span = this.buildSpan(operateName);
        Throwable candidateThrowable = null;
        try {
            V v = supplier.get();
            return v;
        }
        catch (Throwable t) {
            candidateThrowable = t;
            throw t;
        }
        finally {
            if (candidateThrowable != null) {
                span.setTag(Tags.ERROR.getKey(), candidateThrowable.getMessage());
                this.redisSofaTracer.clientReceive("99");
            } else {
                this.redisSofaTracer.clientReceive("00");
            }
        }
    }

    private <T> T activateAndCloseSpan(Span span, Supplier<T> supplier) {
        Throwable candidateThrowable = null;
        try {
            T t = supplier.get();
            return t;
        }
        catch (Throwable t) {
            candidateThrowable = t;
            throw t;
        }
        finally {
            if (candidateThrowable != null) {
                span.setTag(Tags.ERROR.getKey(), candidateThrowable.getMessage());
                this.redisSofaTracer.clientReceive("99");
            } else {
                this.redisSofaTracer.clientReceive("00");
            }
        }
    }

    private void activateAndCloseSpan(Span span, Runnable runnable) {
        Throwable candidateThrowable = null;
        try {
            runnable.run();
        }
        catch (Throwable t) {
            candidateThrowable = t;
            throw t;
        }
        finally {
            if (candidateThrowable != null) {
                span.setTag(Tags.ERROR.getKey(), candidateThrowable.getMessage());
                this.redisSofaTracer.clientReceive("99");
            } else {
                this.redisSofaTracer.clientReceive("00");
            }
        }
    }

    private static String toStringWithDeserialization(byte[][] array) {
        if (array == null) {
            return "null";
        }
        ArrayList<String> list = new ArrayList<String>();
        for (byte[] bytes : array) {
            list.add(RedisActionWrapperHelper.deserialize(bytes));
        }
        return "[" + String.join((CharSequence)", ", list) + "]";
    }

    public Span buildSpan(String operationName) {
        return this.builder(operationName).start();
    }

    public Span buildSpan(String operationName, Object key) {
        return this.buildSpan(operationName).setTag("key", RedisActionWrapperHelper.nullable(key));
    }

    public static String nullable(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    private Tracer.SpanBuilder builder(String operationName) {
        SofaTracerSpan currentSpan = SofaTraceContextHolder.getSofaTraceContext().getCurrentSpan();
        if (this.appName == null) {
            this.appName = SofaTracerConfiguration.getProperty((String)"spring.application.name");
        }
        Tracer.SpanBuilder sb = this.tracer.buildSpan(operationName).asChildOf((Span)currentSpan).withTag("local.app", this.appName).withTag(COMMAND, operationName).withTag(Tags.COMPONENT.getKey(), COMPONENT_NAME).withTag(Tags.SPAN_KIND.getKey(), "client").withTag(Tags.DB_TYPE.getKey(), DB_TYPE);
        return sb;
    }
}

