/*
 * Decompiled with CFR 0.152.
 */
package com.sofa.alipay.tracer.plugins.spring.redis.connections;

import com.sofa.alipay.tracer.plugins.spring.redis.common.RedisActionWrapperHelper;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import org.springframework.data.redis.connection.ClusterInfo;
import org.springframework.data.redis.connection.ReactiveClusterCommands;
import org.springframework.data.redis.connection.ReactiveClusterGeoCommands;
import org.springframework.data.redis.connection.ReactiveClusterHashCommands;
import org.springframework.data.redis.connection.ReactiveClusterHyperLogLogCommands;
import org.springframework.data.redis.connection.ReactiveClusterKeyCommands;
import org.springframework.data.redis.connection.ReactiveClusterListCommands;
import org.springframework.data.redis.connection.ReactiveClusterNumberCommands;
import org.springframework.data.redis.connection.ReactiveClusterServerCommands;
import org.springframework.data.redis.connection.ReactiveClusterSetCommands;
import org.springframework.data.redis.connection.ReactiveClusterStreamCommands;
import org.springframework.data.redis.connection.ReactiveClusterStringCommands;
import org.springframework.data.redis.connection.ReactiveClusterZSetCommands;
import org.springframework.data.redis.connection.ReactivePubSubCommands;
import org.springframework.data.redis.connection.ReactiveRedisClusterConnection;
import org.springframework.data.redis.connection.ReactiveScriptingCommands;
import org.springframework.data.redis.connection.RedisClusterNode;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class TracingReactiveRedisClusterConnection
implements ReactiveRedisClusterConnection {
    private final ReactiveRedisClusterConnection reactiveRedisClusterConnection;
    private final RedisActionWrapperHelper actionWrapper;

    public TracingReactiveRedisClusterConnection(ReactiveRedisClusterConnection reactiveRedisClusterConnection, RedisActionWrapperHelper actionWrapper) {
        this.reactiveRedisClusterConnection = reactiveRedisClusterConnection;
        this.actionWrapper = actionWrapper;
    }

    public ReactiveClusterKeyCommands keyCommands() {
        return this.reactiveRedisClusterConnection.keyCommands();
    }

    public ReactiveClusterStringCommands stringCommands() {
        return this.reactiveRedisClusterConnection.stringCommands();
    }

    public ReactiveClusterNumberCommands numberCommands() {
        return this.reactiveRedisClusterConnection.numberCommands();
    }

    public ReactiveClusterListCommands listCommands() {
        return this.reactiveRedisClusterConnection.listCommands();
    }

    public ReactiveClusterSetCommands setCommands() {
        return this.reactiveRedisClusterConnection.setCommands();
    }

    public ReactiveClusterZSetCommands zSetCommands() {
        return this.reactiveRedisClusterConnection.zSetCommands();
    }

    public ReactiveClusterHashCommands hashCommands() {
        return this.reactiveRedisClusterConnection.hashCommands();
    }

    public ReactiveClusterGeoCommands geoCommands() {
        return this.reactiveRedisClusterConnection.geoCommands();
    }

    public ReactiveClusterHyperLogLogCommands hyperLogLogCommands() {
        return this.reactiveRedisClusterConnection.hyperLogLogCommands();
    }

    public ReactivePubSubCommands pubSubCommands() {
        return this.reactiveRedisClusterConnection.pubSubCommands();
    }

    public ReactiveClusterServerCommands serverCommands() {
        return this.reactiveRedisClusterConnection.serverCommands();
    }

    public ReactiveClusterStreamCommands streamCommands() {
        return this.reactiveRedisClusterConnection.streamCommands();
    }

    public Mono<String> ping(RedisClusterNode node) {
        return this.actionWrapper.doInScope("PING", () -> this.reactiveRedisClusterConnection.ping(node));
    }

    public void close() {
        this.reactiveRedisClusterConnection.close();
    }

    public Mono<Void> closeLater() {
        return this.reactiveRedisClusterConnection.closeLater();
    }

    public ReactiveScriptingCommands scriptingCommands() {
        return this.reactiveRedisClusterConnection.scriptingCommands();
    }

    public Mono<String> ping() {
        return this.actionWrapper.doInScope("PING", () -> this.reactiveRedisClusterConnection.ping());
    }

    public Flux<RedisClusterNode> clusterGetNodes() {
        return this.reactiveRedisClusterConnection.clusterGetNodes();
    }

    public Flux<RedisClusterNode> clusterGetReplicas(RedisClusterNode master) {
        return this.reactiveRedisClusterConnection.clusterGetReplicas(master);
    }

    public Mono<Map<RedisClusterNode, Collection<RedisClusterNode>>> clusterGetMasterReplicaMap() {
        return this.reactiveRedisClusterConnection.clusterGetMasterReplicaMap();
    }

    public Mono<Integer> clusterGetSlotForKey(ByteBuffer key) {
        return this.reactiveRedisClusterConnection.clusterGetSlotForKey(key);
    }

    public Mono<RedisClusterNode> clusterGetNodeForSlot(int slot) {
        return this.reactiveRedisClusterConnection.clusterGetNodeForSlot(slot);
    }

    public Mono<RedisClusterNode> clusterGetNodeForKey(ByteBuffer key) {
        return this.reactiveRedisClusterConnection.clusterGetNodeForKey(key);
    }

    public Mono<ClusterInfo> clusterGetClusterInfo() {
        return this.reactiveRedisClusterConnection.clusterGetClusterInfo();
    }

    public Mono<Void> clusterAddSlots(RedisClusterNode node, int ... slots) {
        return this.reactiveRedisClusterConnection.clusterAddSlots(node, slots);
    }

    public Mono<Void> clusterAddSlots(RedisClusterNode node, RedisClusterNode.SlotRange range) {
        return this.reactiveRedisClusterConnection.clusterAddSlots(node, range);
    }

    public Mono<Long> clusterCountKeysInSlot(int slot) {
        return this.reactiveRedisClusterConnection.clusterCountKeysInSlot(slot);
    }

    public Mono<Void> clusterDeleteSlots(RedisClusterNode node, int ... slots) {
        return this.reactiveRedisClusterConnection.clusterDeleteSlots(node, slots);
    }

    public Mono<Void> clusterDeleteSlotsInRange(RedisClusterNode node, RedisClusterNode.SlotRange range) {
        return this.reactiveRedisClusterConnection.clusterDeleteSlotsInRange(node, range);
    }

    public Mono<Void> clusterForget(RedisClusterNode node) {
        return this.reactiveRedisClusterConnection.clusterForget(node);
    }

    public Mono<Void> clusterMeet(RedisClusterNode node) {
        return this.reactiveRedisClusterConnection.clusterMeet(node);
    }

    public Mono<Void> clusterSetSlot(RedisClusterNode node, int slot, ReactiveClusterCommands.AddSlots mode) {
        return this.reactiveRedisClusterConnection.clusterSetSlot(node, slot, mode);
    }

    public Flux<ByteBuffer> clusterGetKeysInSlot(int slot, int count) {
        return this.reactiveRedisClusterConnection.clusterGetKeysInSlot(slot, count);
    }

    public Mono<Void> clusterReplicate(RedisClusterNode master, RedisClusterNode replica) {
        return this.reactiveRedisClusterConnection.clusterReplicate(master, replica);
    }
}

