/*
 * Decompiled with CFR 0.152.
 */
package com.sofa.alipay.tracer.plugins.spring.redis.connections;

import com.sofa.alipay.tracer.plugins.spring.redis.common.RedisActionWrapperHelper;
import com.sofa.alipay.tracer.plugins.spring.redis.connections.TracingRedisConnection;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.data.redis.connection.ClusterInfo;
import org.springframework.data.redis.connection.RedisClusterCommands;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisClusterServerCommands;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.types.RedisClientInfo;

public class TracingRedisClusterConnection
extends TracingRedisConnection
implements RedisClusterConnection {
    private final RedisClusterConnection connection;
    private final RedisActionWrapperHelper actionWrapper;

    public TracingRedisClusterConnection(RedisClusterConnection connection, RedisActionWrapperHelper actionWrapper) {
        super((RedisConnection)connection, actionWrapper);
        this.connection = connection;
        this.actionWrapper = actionWrapper;
    }

    public RedisClusterCommands clusterCommands() {
        return this.connection.clusterCommands();
    }

    public RedisClusterServerCommands serverCommands() {
        return this.connection.serverCommands();
    }

    public Iterable<RedisClusterNode> clusterGetNodes() {
        return this.actionWrapper.doInScope("CLUSTER NODES", () -> this.connection.clusterGetNodes());
    }

    public Collection<RedisClusterNode> clusterGetReplicas(RedisClusterNode master) {
        return this.actionWrapper.doInScope("CLUSTER SLAVES", () -> this.connection.clusterGetReplicas(master));
    }

    public Map<RedisClusterNode, Collection<RedisClusterNode>> clusterGetMasterReplicaMap() {
        return this.actionWrapper.doInScope("CLUSTER MASTER-SLAVE-MAP", () -> this.connection.clusterGetMasterReplicaMap());
    }

    public Integer clusterGetSlotForKey(byte[] key) {
        return this.actionWrapper.doInScope("CLUSTER KEYSLOT", () -> this.connection.clusterGetSlotForKey(key));
    }

    public RedisClusterNode clusterGetNodeForSlot(int slot) {
        return this.actionWrapper.doInScope("CLUSTER_NODE_FOR_SLOT", () -> this.connection.clusterGetNodeForSlot(slot));
    }

    public RedisClusterNode clusterGetNodeForKey(byte[] key) {
        return this.actionWrapper.doInScope("CLUSTER_NODE_FOR_KEY", () -> this.connection.clusterGetNodeForKey(key));
    }

    public ClusterInfo clusterGetClusterInfo() {
        return this.actionWrapper.doInScope("CLUSTER INFO", () -> this.connection.clusterGetClusterInfo());
    }

    public void clusterAddSlots(RedisClusterNode node, int ... slots) {
        this.actionWrapper.doInScope("CLUSTER ADDSLOTS", () -> this.connection.clusterAddSlots(node, slots));
    }

    public void clusterAddSlots(RedisClusterNode node, RedisClusterNode.SlotRange range) {
        this.actionWrapper.doInScope("CLUSTER ADDSLOTS", () -> this.connection.clusterAddSlots(node, range));
    }

    public Long clusterCountKeysInSlot(int slot) {
        return this.actionWrapper.doInScope("CLUSTER COUNTKEYSINSLOT", () -> this.connection.clusterCountKeysInSlot(slot));
    }

    public void clusterDeleteSlots(RedisClusterNode node, int ... slots) {
        this.actionWrapper.doInScope("CLUSTER DELSLOTS", () -> this.connection.clusterDeleteSlots(node, slots));
    }

    public void clusterDeleteSlotsInRange(RedisClusterNode node, RedisClusterNode.SlotRange range) {
        this.actionWrapper.doInScope("CLUSTER DELSLOTS", () -> this.connection.clusterDeleteSlotsInRange(node, range));
    }

    public void clusterForget(RedisClusterNode node) {
        this.actionWrapper.doInScope("CLUSTER FORGET", () -> this.connection.clusterForget(node));
    }

    public void clusterMeet(RedisClusterNode node) {
        this.actionWrapper.doInScope("CLUSTER MEET", () -> this.connection.clusterMeet(node));
    }

    public void clusterSetSlot(RedisClusterNode node, int slot, RedisClusterCommands.AddSlots mode) {
        this.actionWrapper.doInScope("CLUSTER SETSLOT", () -> this.connection.clusterSetSlot(node, slot, mode));
    }

    public List<byte[]> clusterGetKeysInSlot(int slot, Integer count) {
        return this.actionWrapper.doInScope("CLUSTER GETKEYSINSLOT", () -> this.connection.clusterGetKeysInSlot(slot, count));
    }

    public void clusterReplicate(RedisClusterNode master, RedisClusterNode slave) {
        this.actionWrapper.doInScope("CLUSTER REPLICATE", () -> this.connection.clusterReplicate(master, slave));
    }

    public String ping(RedisClusterNode node) {
        return this.actionWrapper.doInScope("PING", () -> this.connection.ping(node));
    }

    public void bgReWriteAof(RedisClusterNode node) {
        this.actionWrapper.doInScope("BGREWRITEAOF", () -> this.connection.bgReWriteAof(node));
    }

    public void bgSave(RedisClusterNode node) {
        this.actionWrapper.doInScope("BGSAVE", () -> this.connection.bgSave(node));
    }

    public Long lastSave(RedisClusterNode node) {
        return this.actionWrapper.doInScope("LASTSAVE", () -> this.connection.lastSave(node));
    }

    public void save(RedisClusterNode node) {
        this.actionWrapper.doInScope("SAVE", () -> this.connection.save(node));
    }

    public Long dbSize(RedisClusterNode node) {
        return this.actionWrapper.doInScope("DBSIZE", () -> this.connection.dbSize(node));
    }

    public void flushDb(RedisClusterNode node) {
        this.actionWrapper.doInScope("FLUSHDB", () -> this.connection.flushDb(node));
    }

    public void flushAll(RedisClusterNode node) {
        this.actionWrapper.doInScope("FLUSHALL", () -> this.connection.flushAll(node));
    }

    public Properties info(RedisClusterNode node) {
        return this.actionWrapper.doInScope("INFO", () -> this.connection.info(node));
    }

    public Properties info(RedisClusterNode node, String section) {
        return this.actionWrapper.doInScope("INFO", () -> this.connection.info(node, section));
    }

    public Set<byte[]> keys(RedisClusterNode node, byte[] pattern) {
        return this.actionWrapper.doInScope("KEYS", () -> this.connection.keys(node, pattern));
    }

    public Cursor<byte[]> scan(RedisClusterNode node, ScanOptions options) {
        return this.actionWrapper.doInScope("SCAN", () -> this.connection.scan(node, options));
    }

    public byte[] randomKey(RedisClusterNode node) {
        return this.actionWrapper.doInScope("RANDOMKEY", () -> this.connection.randomKey(node));
    }

    public <T> T execute(String command, byte[] key, Collection<byte[]> args) {
        return (T)this.actionWrapper.doInScope("EXECUTE", () -> this.connection.execute(command, key, args));
    }

    public void shutdown(RedisClusterNode node) {
        this.actionWrapper.doInScope("SHUTDOWN", () -> this.connection.shutdown(node));
    }

    public Properties getConfig(RedisClusterNode node, String pattern) {
        return this.actionWrapper.doInScope("CONFIG GET", () -> this.connection.getConfig(node, pattern));
    }

    public void setConfig(RedisClusterNode node, String param, String value) {
        this.actionWrapper.doInScope("CONFIG SET", () -> this.connection.setConfig(node, param, value));
    }

    public void resetConfigStats(RedisClusterNode node) {
        this.actionWrapper.doInScope("CONFIG RESETSTAT", () -> this.connection.resetConfigStats(node));
    }

    public Long time(RedisClusterNode node) {
        return this.actionWrapper.doInScope("TIME", () -> this.connection.time(node));
    }

    public List<RedisClientInfo> getClientList(RedisClusterNode node) {
        return this.actionWrapper.doInScope("CLIENT LIST", () -> this.connection.getClientList(node));
    }
}

