/*
 * Decompiled with CFR 0.152.
 */
package com.sofa.alipay.tracer.plugins.spring.redis.connections;

import com.sofa.alipay.tracer.plugins.spring.redis.common.RedisActionWrapperHelper;
import com.sofa.alipay.tracer.plugins.spring.redis.connections.TracingRedisSentinelConnection;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.dao.DataAccessException;
import org.springframework.data.domain.Range;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.BitFieldSubCommands;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.Limit;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisCommands;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.RedisHashCommands;
import org.springframework.data.redis.connection.RedisHyperLogLogCommands;
import org.springframework.data.redis.connection.RedisKeyCommands;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPipelineException;
import org.springframework.data.redis.connection.RedisScriptingCommands;
import org.springframework.data.redis.connection.RedisSentinelConnection;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.connection.RedisSetCommands;
import org.springframework.data.redis.connection.RedisStreamCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.Subscription;
import org.springframework.data.redis.connection.ValueEncoding;
import org.springframework.data.redis.connection.zset.Aggregate;
import org.springframework.data.redis.connection.zset.Tuple;
import org.springframework.data.redis.connection.zset.Weights;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.core.types.RedisClientInfo;

public class TracingRedisConnection
implements RedisConnection {
    private final RedisConnection connection;
    private final RedisActionWrapperHelper actionWrapper;

    public TracingRedisConnection(RedisConnection connection, RedisActionWrapperHelper actionWrapper) {
        this.connection = connection;
        this.actionWrapper = actionWrapper;
    }

    public RedisCommands commands() {
        return this.connection.commands();
    }

    public RedisGeoCommands geoCommands() {
        return this.connection.geoCommands();
    }

    public RedisHashCommands hashCommands() {
        return this.connection.hashCommands();
    }

    public RedisHyperLogLogCommands hyperLogLogCommands() {
        return this.connection.hyperLogLogCommands();
    }

    public RedisKeyCommands keyCommands() {
        return this.connection.keyCommands();
    }

    public RedisListCommands listCommands() {
        return this.connection.listCommands();
    }

    public RedisSetCommands setCommands() {
        return this.connection.setCommands();
    }

    public RedisScriptingCommands scriptingCommands() {
        return this.connection.scriptingCommands();
    }

    public RedisServerCommands serverCommands() {
        return this.connection.serverCommands();
    }

    public RedisStreamCommands streamCommands() {
        return this.connection.streamCommands();
    }

    public RedisStringCommands stringCommands() {
        return this.connection.stringCommands();
    }

    public RedisZSetCommands zSetCommands() {
        return this.connection.zSetCommands();
    }

    public void close() throws DataAccessException {
        this.connection.close();
    }

    public boolean isClosed() {
        return this.connection.isClosed();
    }

    public Object getNativeConnection() {
        return this.connection.getNativeConnection();
    }

    public boolean isQueueing() {
        return this.connection.isQueueing();
    }

    public boolean isPipelined() {
        return this.connection.isPipelined();
    }

    public void openPipeline() {
        this.connection.openPipeline();
    }

    public List<Object> closePipeline() throws RedisPipelineException {
        return this.connection.closePipeline();
    }

    public boolean isSubscribed() {
        return this.connection.isSubscribed();
    }

    public Subscription getSubscription() {
        return this.connection.getSubscription();
    }

    public RedisSentinelConnection getSentinelConnection() {
        return new TracingRedisSentinelConnection(this.connection.getSentinelConnection(), this.actionWrapper);
    }

    public Object execute(String command, byte[] ... args) {
        return this.actionWrapper.doInScope(command, () -> this.connection.execute(command, args));
    }

    public Boolean exists(byte[] key) {
        return this.actionWrapper.doInScope("EXISTS", key, () -> this.connection.exists(key));
    }

    public Long exists(byte[] ... keys) {
        return this.actionWrapper.doInScope("EXISTS", keys, () -> this.connection.exists((byte[][])new byte[0][]));
    }

    public Long del(byte[] ... keys) {
        return this.actionWrapper.doInScope("DEL", keys, () -> this.connection.del(keys));
    }

    public Long unlink(byte[] ... keys) {
        return this.actionWrapper.doInScope("UNLINK", keys, () -> this.connection.unlink((byte[][])new byte[0][]));
    }

    public DataType type(byte[] key) {
        return this.actionWrapper.doInScope("TYPE", key, () -> this.connection.type(key));
    }

    public Long touch(byte[] ... keys) {
        return this.actionWrapper.doInScope("TOUCH", keys, () -> this.connection.touch((byte[][])new byte[0][]));
    }

    public Set<byte[]> keys(byte[] pattern) {
        return this.actionWrapper.doInScope("KEYS", () -> this.connection.keys(pattern));
    }

    public Cursor<byte[]> scan(ScanOptions options) {
        return this.actionWrapper.doInScope("SCAN", () -> this.connection.scan(options));
    }

    public byte[] randomKey() {
        return this.actionWrapper.doInScope("RANDOMKEY", () -> this.connection.randomKey());
    }

    public void rename(byte[] sourceKey, byte[] targetKey) {
        this.actionWrapper.doInScope("RENAME", sourceKey, () -> this.connection.rename(sourceKey, targetKey));
    }

    public Boolean renameNX(byte[] sourceKey, byte[] targetKey) {
        return this.actionWrapper.doInScope("RENAMENX", sourceKey, () -> this.connection.renameNX(sourceKey, targetKey));
    }

    public Boolean expire(byte[] key, long seconds) {
        return this.actionWrapper.doInScope("EXPIRE", key, () -> this.connection.expire(key, seconds));
    }

    public Boolean pExpire(byte[] key, long millis) {
        return this.actionWrapper.doInScope("PEXPIRE", key, () -> this.connection.pExpire(key, millis));
    }

    public Boolean expireAt(byte[] key, long unixTime) {
        return this.actionWrapper.doInScope("EXPIREAT", key, () -> this.connection.expireAt(key, unixTime));
    }

    public Boolean pExpireAt(byte[] key, long unixTimeInMillis) {
        return this.actionWrapper.doInScope("PEXPIREAT", key, () -> this.connection.pExpireAt(key, unixTimeInMillis));
    }

    public Boolean persist(byte[] key) {
        return this.actionWrapper.doInScope("PERSIST", key, () -> this.connection.persist(key));
    }

    public Boolean move(byte[] key, int dbIndex) {
        return this.actionWrapper.doInScope("MOVE", key, () -> this.connection.move(key, dbIndex));
    }

    public Long ttl(byte[] key) {
        return this.actionWrapper.doInScope("TTL", key, () -> this.connection.ttl(key));
    }

    public Long ttl(byte[] key, TimeUnit timeUnit) {
        return this.actionWrapper.doInScope("TTL", key, () -> this.connection.ttl(key, timeUnit));
    }

    public Long pTtl(byte[] key) {
        return this.actionWrapper.doInScope("PTTL", key, () -> this.connection.pTtl(key));
    }

    public Long pTtl(byte[] key, TimeUnit timeUnit) {
        return this.actionWrapper.doInScope("PTTL", key, () -> this.connection.pTtl(key, timeUnit));
    }

    public List<byte[]> sort(byte[] key, SortParameters params) {
        return this.actionWrapper.doInScope("SORT", key, () -> this.connection.sort(key, params));
    }

    public Long sort(byte[] key, SortParameters params, byte[] storeKey) {
        return this.actionWrapper.doInScope("SORT", key, () -> this.connection.sort(key, params, storeKey));
    }

    public byte[] dump(byte[] key) {
        return this.actionWrapper.doInScope("DUMP", key, () -> this.connection.dump(key));
    }

    public void restore(byte[] key, long ttlInMillis, byte[] serializedValue) {
        this.actionWrapper.doInScope("RESTORE", key, () -> this.connection.restore(key, ttlInMillis, serializedValue));
    }

    public void restore(byte[] key, long ttlInMillis, byte[] serializedValue, boolean replace) {
        this.actionWrapper.doInScope("RESTORE", key, () -> this.connection.restore(key, ttlInMillis, serializedValue, replace));
    }

    public ValueEncoding encodingOf(byte[] key) {
        return this.actionWrapper.doInScope("ENCODING", key, () -> this.connection.encodingOf(key));
    }

    public Duration idletime(byte[] key) {
        return this.actionWrapper.doInScope("IDLETIME", key, () -> this.connection.idletime(key));
    }

    public Long refcount(byte[] key) {
        return this.actionWrapper.doInScope("REFCOUNT", key, () -> this.connection.refcount(key));
    }

    public byte[] get(byte[] key) {
        return this.actionWrapper.doInScope("GET", key, () -> this.connection.get(key));
    }

    public byte[] getSet(byte[] key, byte[] value) {
        return this.actionWrapper.doInScope("GETSET", key, () -> this.connection.getSet(key, value));
    }

    public List<byte[]> mGet(byte[] ... keys) {
        return this.actionWrapper.doInScope("MGET", keys, () -> this.connection.mGet(keys));
    }

    public Boolean set(byte[] key, byte[] value) {
        return this.actionWrapper.doInScope("SET", key, () -> this.connection.set(key, value));
    }

    public Boolean set(byte[] key, byte[] value, Expiration expiration, RedisStringCommands.SetOption option) {
        return this.actionWrapper.doInScope("SET", key, () -> this.connection.set(key, value, expiration, option));
    }

    public Boolean setNX(byte[] key, byte[] value) {
        return this.actionWrapper.doInScope("SETNX", key, () -> this.connection.setNX(key, value));
    }

    public Boolean setEx(byte[] key, long seconds, byte[] value) {
        return this.actionWrapper.doInScope("SETEX", key, () -> this.connection.setEx(key, seconds, value));
    }

    public Boolean pSetEx(byte[] key, long milliseconds, byte[] value) {
        return this.actionWrapper.doInScope("PSETEX", key, () -> this.connection.pSetEx(key, milliseconds, value));
    }

    public Boolean mSet(Map<byte[], byte[]> tuple) {
        return this.actionWrapper.doInScope("MSET", () -> this.connection.mSet(tuple));
    }

    public Boolean mSetNX(Map<byte[], byte[]> tuple) {
        return this.actionWrapper.doInScope("MSETNX", () -> this.connection.mSetNX(tuple));
    }

    public Long incr(byte[] key) {
        return this.actionWrapper.doInScope("INCR", key, () -> this.connection.incr(key));
    }

    public Long incrBy(byte[] key, long value) {
        return this.actionWrapper.doInScope("INCRBY", key, () -> this.connection.incrBy(key, value));
    }

    public Double incrBy(byte[] key, double value) {
        return this.actionWrapper.doInScope("INCRBY", key, () -> this.connection.incrBy(key, value));
    }

    public Long decr(byte[] key) {
        return this.actionWrapper.doInScope("DECR", key, () -> this.connection.decr(key));
    }

    public Long decrBy(byte[] key, long value) {
        return this.actionWrapper.doInScope("DECRBY", key, () -> this.connection.decrBy(key, value));
    }

    public Long append(byte[] key, byte[] value) {
        return this.actionWrapper.doInScope("APPEND", key, () -> this.connection.append(key, value));
    }

    public byte[] getRange(byte[] key, long begin, long end) {
        return this.actionWrapper.doInScope("GETRANGE", key, () -> this.connection.getRange(key, begin, end));
    }

    public void setRange(byte[] key, byte[] value, long offset) {
        this.actionWrapper.doInScope("SETRANGE", key, () -> this.connection.setRange(key, value, offset));
    }

    public Boolean getBit(byte[] key, long offset) {
        return this.actionWrapper.doInScope("GETBIT", key, () -> this.connection.getBit(key, offset));
    }

    public Boolean setBit(byte[] key, long offset, boolean value) {
        return this.actionWrapper.doInScope("SETBIT", key, () -> this.connection.setBit(key, offset, value));
    }

    public Long bitCount(byte[] key) {
        return this.actionWrapper.doInScope("BITCOUNT", key, () -> this.connection.bitCount(key));
    }

    public Long bitCount(byte[] key, long begin, long end) {
        return this.actionWrapper.doInScope("BITCOUNT", key, () -> this.connection.bitCount(key, begin, end));
    }

    public List<Long> bitField(byte[] key, BitFieldSubCommands subCommands) {
        return this.actionWrapper.doInScope("BITFIELD", key, () -> this.connection.bitField(key, subCommands));
    }

    public Long bitOp(RedisStringCommands.BitOperation op, byte[] destination, byte[] ... keys) {
        return this.actionWrapper.doInScope("BITOP", keys, () -> this.connection.bitOp(op, destination, keys));
    }

    public Long bitPos(byte[] key, boolean bit, Range<Long> range) {
        return this.actionWrapper.doInScope("BITPOS", key, () -> this.connection.bitPos(key, bit, range));
    }

    public Long strLen(byte[] key) {
        return this.actionWrapper.doInScope("STRLEN", key, () -> this.connection.strLen(key));
    }

    public Long rPush(byte[] key, byte[] ... values) {
        return this.actionWrapper.doInScope("RPUSH", key, () -> this.connection.rPush(key, values));
    }

    public Long lPush(byte[] key, byte[] ... values) {
        return this.actionWrapper.doInScope("LPUSH", key, () -> this.connection.lPush(key, values));
    }

    public Long rPushX(byte[] key, byte[] value) {
        return this.actionWrapper.doInScope("RPUSHX", key, () -> this.connection.rPushX(key, value));
    }

    public Long lPushX(byte[] key, byte[] value) {
        return this.actionWrapper.doInScope("LPUSHX", key, () -> this.connection.lPushX(key, value));
    }

    public Long lLen(byte[] key) {
        return this.actionWrapper.doInScope("LLEN", key, () -> this.connection.lLen(key));
    }

    public List<byte[]> lRange(byte[] key, long start, long end) {
        return this.actionWrapper.doInScope("LRANGE", key, () -> this.connection.lRange(key, start, end));
    }

    public void lTrim(byte[] key, long start, long end) {
        this.actionWrapper.doInScope("LTRIM", key, () -> this.connection.lTrim(key, start, end));
    }

    public byte[] lIndex(byte[] key, long index) {
        return this.actionWrapper.doInScope("LINDEX", key, () -> this.connection.lIndex(key, index));
    }

    public Long lInsert(byte[] key, RedisListCommands.Position where, byte[] pivot, byte[] value) {
        return this.actionWrapper.doInScope("LINSERT", key, () -> this.connection.lInsert(key, where, pivot, value));
    }

    public void lSet(byte[] key, long index, byte[] value) {
        this.actionWrapper.doInScope("LSET", key, () -> this.connection.lSet(key, index, value));
    }

    public Long lRem(byte[] key, long count, byte[] value) {
        return this.actionWrapper.doInScope("LREM", key, () -> this.connection.lRem(key, count, value));
    }

    public byte[] lPop(byte[] key) {
        return this.actionWrapper.doInScope("LPOP", key, () -> this.connection.lPop(key));
    }

    public byte[] rPop(byte[] key) {
        return this.actionWrapper.doInScope("RPOP", key, () -> this.connection.rPop(key));
    }

    public List<byte[]> bLPop(int timeout, byte[] ... keys) {
        return this.actionWrapper.doInScope("BLPOP", keys, () -> this.connection.bLPop(timeout, keys));
    }

    public List<byte[]> bRPop(int timeout, byte[] ... keys) {
        return this.actionWrapper.doInScope("BRPOP", keys, () -> this.connection.bRPop(timeout, keys));
    }

    public byte[] rPopLPush(byte[] srcKey, byte[] dstKey) {
        return this.actionWrapper.doInScope("RPOPLPUSH", srcKey, () -> this.connection.rPopLPush(srcKey, dstKey));
    }

    public byte[] bRPopLPush(int timeout, byte[] srcKey, byte[] dstKey) {
        return this.actionWrapper.doInScope("BRPOPLPUSH", srcKey, () -> this.connection.bRPopLPush(timeout, srcKey, dstKey));
    }

    public Long sAdd(byte[] key, byte[] ... values) {
        return this.actionWrapper.doInScope("SADD", key, () -> this.connection.sAdd(key, values));
    }

    public Long sRem(byte[] key, byte[] ... values) {
        return this.actionWrapper.doInScope("SREM", key, () -> this.connection.sRem(key, values));
    }

    public byte[] sPop(byte[] key) {
        return this.actionWrapper.doInScope("SPOP", key, () -> this.connection.sPop(key));
    }

    public List<byte[]> sPop(byte[] key, long count) {
        return this.actionWrapper.doInScope("SPOP", key, () -> this.connection.sPop(key, count));
    }

    public Boolean sMove(byte[] srcKey, byte[] destKey, byte[] value) {
        return this.actionWrapper.doInScope("SMOVE", srcKey, () -> this.connection.sMove(srcKey, destKey, value));
    }

    public Long sCard(byte[] key) {
        return this.actionWrapper.doInScope("SCARD", key, () -> this.connection.sCard(key));
    }

    public Boolean sIsMember(byte[] key, byte[] value) {
        return this.actionWrapper.doInScope("SISMEMBER", key, () -> this.connection.sIsMember(key, value));
    }

    public Set<byte[]> sInter(byte[] ... keys) {
        return this.actionWrapper.doInScope("SINTER", keys, () -> this.connection.sInter(keys));
    }

    public Long sInterStore(byte[] destKey, byte[] ... keys) {
        return this.actionWrapper.doInScope("SINTERSTORE", keys, () -> this.connection.sInterStore(destKey, keys));
    }

    public Set<byte[]> sUnion(byte[] ... keys) {
        return this.actionWrapper.doInScope("SUNION", keys, () -> this.connection.sUnion(keys));
    }

    public Long sUnionStore(byte[] destKey, byte[] ... keys) {
        return this.actionWrapper.doInScope("SUNIONSTORE", keys, () -> this.connection.sUnionStore(destKey, keys));
    }

    public Set<byte[]> sDiff(byte[] ... keys) {
        return this.actionWrapper.doInScope("SDIFF", keys, () -> this.connection.sDiff(keys));
    }

    public Long sDiffStore(byte[] destKey, byte[] ... keys) {
        return this.actionWrapper.doInScope("SDIFFSTORE", keys, () -> this.connection.sDiffStore(destKey, keys));
    }

    public Set<byte[]> sMembers(byte[] key) {
        return this.actionWrapper.doInScope("SMEMBERS", key, () -> this.connection.sMembers(key));
    }

    public byte[] sRandMember(byte[] key) {
        return this.actionWrapper.doInScope("SRANDMEMBER", key, () -> this.connection.sRandMember(key));
    }

    public List<byte[]> sRandMember(byte[] key, long count) {
        return this.actionWrapper.doInScope("SRANDMEMBER", key, () -> this.connection.sRandMember(key, count));
    }

    public Cursor<byte[]> sScan(byte[] key, ScanOptions options) {
        return this.actionWrapper.doInScope("SSCAN", key, () -> this.connection.sScan(key, options));
    }

    public Boolean zAdd(byte[] key, double score, byte[] value) {
        return this.actionWrapper.doInScope("ZADD", key, () -> this.connection.zAdd(key, score, value));
    }

    public Long zAdd(byte[] key, Set<Tuple> tuples) {
        return this.actionWrapper.doInScope("ZADD", key, () -> this.connection.zAdd(key, tuples));
    }

    public Long zRem(byte[] key, byte[] ... values) {
        return this.actionWrapper.doInScope("ZREM", key, () -> this.connection.zRem(key, values));
    }

    public Double zIncrBy(byte[] key, double increment, byte[] value) {
        return this.actionWrapper.doInScope("ZINCRBY", key, () -> this.connection.zIncrBy(key, increment, value));
    }

    public Long zRank(byte[] key, byte[] value) {
        return this.actionWrapper.doInScope("ZRANK", key, () -> this.connection.zRank(key, value));
    }

    public Long zRevRank(byte[] key, byte[] value) {
        return this.actionWrapper.doInScope("ZREVRANK", key, () -> this.connection.zRevRank(key, value));
    }

    public Set<byte[]> zRange(byte[] key, long start, long end) {
        return this.actionWrapper.doInScope("ZRANGE", key, () -> this.connection.zRange(key, start, end));
    }

    public Set<byte[]> zRevRange(byte[] key, long start, long end) {
        return this.actionWrapper.doInScope("ZREVRANGE", key, () -> this.connection.zRevRange(key, start, end));
    }

    public Set<Tuple> zRevRangeWithScores(byte[] key, long start, long end) {
        return this.actionWrapper.doInScope("ZREVRANGE WITHSCORES", key, () -> this.connection.zRevRangeWithScores(key, start, end));
    }

    public Set<Tuple> zRangeWithScores(byte[] key, long start, long end) {
        return this.actionWrapper.doInScope("ZRANGE WITHSCORES", key, () -> this.connection.zRangeWithScores(key, start, end));
    }

    public Set<byte[]> zRangeByScore(byte[] key, double min, double max) {
        return this.actionWrapper.doInScope("ZRANGEBYSCORE", key, () -> this.connection.zRangeByScore(key, min, max));
    }

    public Set<byte[]> zRangeByScore(byte[] key, double min, double max, long offset, long count) {
        return this.actionWrapper.doInScope("ZRANGEBYSCORE", key, () -> this.connection.zRangeByScore(key, min, max, offset, count));
    }

    public Set<byte[]> zRangeByScore(byte[] key, String min, String max) {
        return this.actionWrapper.doInScope("ZRANGEBYSCORE", key, () -> this.connection.zRangeByScore(key, min, max));
    }

    public Set<byte[]> zRangeByScore(byte[] key, Range<? extends Number> range) {
        return this.actionWrapper.doInScope("ZRANGEBYSCORE", key, () -> this.connection.zRangeByScore(key, range));
    }

    public Set<byte[]> zRangeByScore(byte[] key, String min, String max, long offset, long count) {
        return this.actionWrapper.doInScope("ZRANGEBYSCORE", key, () -> this.connection.zRangeByScore(key, min, max, offset, count));
    }

    public Set<byte[]> zRangeByScore(byte[] key, Range<? extends Number> range, Limit limit) {
        return this.actionWrapper.doInScope("ZRANGEBYSCORE", key, () -> this.connection.zRangeByScore(key, range, limit));
    }

    public Set<Tuple> zRangeByScoreWithScores(byte[] key, Range<? extends Number> range) {
        return this.actionWrapper.doInScope("ZRANGEBYSCORE WITHSCORES", key, () -> this.connection.zRangeByScoreWithScores(key, range));
    }

    public Set<Tuple> zRangeByScoreWithScores(byte[] key, double min, double max) {
        return this.actionWrapper.doInScope("ZRANGEBYSCORE WITHSCORES", key, () -> this.connection.zRangeByScoreWithScores(key, min, max));
    }

    public Set<Tuple> zRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        return this.actionWrapper.doInScope("ZRANGEBYSCORE WITHSCORES", key, () -> this.connection.zRangeByScoreWithScores(key, min, max, offset, count));
    }

    public Set<Tuple> zRangeByScoreWithScores(byte[] key, Range<? extends Number> range, Limit limit) {
        return this.actionWrapper.doInScope("ZRANGEBYSCORE WITHSCORES", key, () -> this.connection.zRangeByScoreWithScores(key, range, limit));
    }

    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max) {
        return this.actionWrapper.doInScope("ZREVRANGEBYSCORE", key, () -> this.connection.zRevRangeByScore(key, min, max));
    }

    public Set<byte[]> zRevRangeByScore(byte[] key, Range<? extends Number> range) {
        return this.actionWrapper.doInScope("ZREVRANGEBYSCORE", key, () -> this.connection.zRevRangeByScore(key, range));
    }

    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max, long offset, long count) {
        return this.actionWrapper.doInScope("ZREVRANGEBYSCORE", key, () -> this.connection.zRevRangeByScore(key, min, max, offset, count));
    }

    public Set<byte[]> zRevRangeByScore(byte[] key, Range<? extends Number> range, Limit limit) {
        return this.actionWrapper.doInScope("ZREVRANGEBYSCORE", key, () -> this.connection.zRevRangeByScore(key, range, limit));
    }

    public Set<Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max) {
        return this.actionWrapper.doInScope("ZREVRANGEBYSCORE WITHSCORES", key, () -> this.connection.zRevRangeByScoreWithScores(key, min, max));
    }

    public Set<Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        return this.actionWrapper.doInScope("ZREVRANGEBYSCORE WITHSCORES", key, () -> this.connection.zRevRangeByScoreWithScores(key, min, max, offset, count));
    }

    public Set<Tuple> zRevRangeByScoreWithScores(byte[] key, Range<? extends Number> range) {
        return this.actionWrapper.doInScope("ZREVRANGEBYSCORE WITHSCORES", key, () -> this.connection.zRevRangeByScoreWithScores(key, range));
    }

    public Set<Tuple> zRevRangeByScoreWithScores(byte[] key, Range<? extends Number> range, Limit limit) {
        return this.actionWrapper.doInScope("ZREVRANGEBYSCORE WITHSCORES", key, () -> this.connection.zRevRangeByScoreWithScores(key, range, limit));
    }

    public Long zCount(byte[] key, double min, double max) {
        return this.actionWrapper.doInScope("ZCOUNT", key, () -> this.connection.zCount(key, min, max));
    }

    public Long zCount(byte[] key, Range<? extends Number> range) {
        return this.actionWrapper.doInScope("ZCOUNT", key, () -> this.connection.zCount(key, range));
    }

    public Long zCard(byte[] key) {
        return this.actionWrapper.doInScope("ZCARD", key, () -> this.connection.zCard(key));
    }

    public Double zScore(byte[] key, byte[] value) {
        return this.actionWrapper.doInScope("ZSCORE", key, () -> this.connection.zScore(key, value));
    }

    public Long zRemRange(byte[] key, long start, long end) {
        return this.actionWrapper.doInScope("ZREMRANGE", key, () -> this.connection.zRemRange(key, start, end));
    }

    public Long zRemRangeByScore(byte[] key, double min, double max) {
        return this.actionWrapper.doInScope("ZREMRANGEBYSCORE", key, () -> this.connection.zRemRangeByScore(key, min, max));
    }

    public Long zRemRangeByScore(byte[] key, Range<? extends Number> range) {
        return this.actionWrapper.doInScope("ZREMRANGEBYSCORE", key, () -> this.connection.zRemRangeByScore(key, range));
    }

    public Long zUnionStore(byte[] destKey, byte[] ... sets) {
        return this.actionWrapper.doInScope("ZUNIONSTORE", () -> this.connection.zUnionStore(destKey, sets));
    }

    public Long zUnionStore(byte[] destKey, Aggregate aggregate, int[] weights, byte[] ... sets) {
        return this.actionWrapper.doInScope("ZUNIONSTORE", destKey, () -> this.connection.zUnionStore(destKey, aggregate, weights, sets));
    }

    public Long zUnionStore(byte[] destKey, Aggregate aggregate, Weights weights, byte[] ... sets) {
        return this.actionWrapper.doInScope("ZUNIONSTORE", destKey, () -> this.connection.zUnionStore(destKey, aggregate, weights, sets));
    }

    public Long zInterStore(byte[] destKey, byte[] ... sets) {
        return this.actionWrapper.doInScope("ZINTERSTORE", destKey, () -> this.connection.zInterStore(destKey, sets));
    }

    public Long zInterStore(byte[] destKey, Aggregate aggregate, int[] weights, byte[] ... sets) {
        return this.actionWrapper.doInScope("ZINTERSTORE", destKey, () -> this.connection.zInterStore(destKey, aggregate, weights, sets));
    }

    public Long zInterStore(byte[] destKey, Aggregate aggregate, Weights weights, byte[] ... sets) {
        return this.actionWrapper.doInScope("ZINTERSTORE", destKey, () -> this.connection.zInterStore(destKey, aggregate, weights, sets));
    }

    public Cursor<Tuple> zScan(byte[] key, ScanOptions options) {
        return this.actionWrapper.doInScope("ZSCAN", key, () -> this.connection.zScan(key, options));
    }

    public Set<byte[]> zRangeByLex(byte[] key) {
        return this.actionWrapper.doInScope("ZRANGEBYLEX", key, () -> this.connection.zRangeByLex(key));
    }

    public Set<byte[]> zRangeByLex(byte[] key, Range range) {
        return this.actionWrapper.doInScope("ZRANGEBYLEX", key, () -> this.connection.zRangeByLex(key, range));
    }

    public Set<byte[]> zRangeByLex(byte[] key, Range range, Limit limit) {
        return this.actionWrapper.doInScope("ZRANGEBYLEX", key, () -> this.connection.zRangeByLex(key, range, limit));
    }

    public Boolean hSet(byte[] key, byte[] field, byte[] value) {
        return this.actionWrapper.doInScope("HSET", key, () -> this.connection.hSet(key, field, value));
    }

    public Boolean hSetNX(byte[] key, byte[] field, byte[] value) {
        return this.actionWrapper.doInScope("HSETNX", key, () -> this.connection.hSetNX(key, field, value));
    }

    public byte[] hGet(byte[] key, byte[] field) {
        return this.actionWrapper.doInScope("HGET", key, () -> this.connection.hGet(key, field));
    }

    public List<byte[]> hMGet(byte[] key, byte[] ... fields) {
        return this.actionWrapper.doInScope("HMGET", key, () -> this.connection.hMGet(key, fields));
    }

    public void hMSet(byte[] key, Map<byte[], byte[]> hashes) {
        this.actionWrapper.doInScope("HMSET", key, () -> this.connection.hMSet(key, hashes));
    }

    public Long hIncrBy(byte[] key, byte[] field, long delta) {
        return this.actionWrapper.doInScope("HINCRBY", key, () -> this.connection.hIncrBy(key, field, delta));
    }

    public Double hIncrBy(byte[] key, byte[] field, double delta) {
        return this.actionWrapper.doInScope("HINCRBY", key, () -> this.connection.hIncrBy(key, field, delta));
    }

    public Boolean hExists(byte[] key, byte[] field) {
        return this.actionWrapper.doInScope("HEXISTS", key, () -> this.connection.hExists(key, field));
    }

    public Long hDel(byte[] key, byte[] ... fields) {
        return this.actionWrapper.doInScope("HDEL", key, () -> this.connection.hDel(key, fields));
    }

    public Long hLen(byte[] key) {
        return this.actionWrapper.doInScope("HLEN", key, () -> this.connection.hLen(key));
    }

    public Set<byte[]> hKeys(byte[] key) {
        return this.actionWrapper.doInScope("HKEYS", key, () -> this.connection.hKeys(key));
    }

    public List<byte[]> hVals(byte[] key) {
        return this.actionWrapper.doInScope("HVALS", key, () -> this.connection.hVals(key));
    }

    public Map<byte[], byte[]> hGetAll(byte[] key) {
        return this.actionWrapper.doInScope("HGETALL", key, () -> this.connection.hGetAll(key));
    }

    public Cursor<Map.Entry<byte[], byte[]>> hScan(byte[] key, ScanOptions options) {
        return this.actionWrapper.doInScope("HSCAN", key, () -> this.connection.hScan(key, options));
    }

    public Long hStrLen(byte[] key, byte[] field) {
        return this.actionWrapper.doInScope("HSTRLEN", key, () -> this.connection.hStrLen(key, field));
    }

    public void multi() {
        this.actionWrapper.doInScope("MULTI", () -> this.connection.multi());
    }

    public List<Object> exec() {
        return this.actionWrapper.doInScope("EXEC", () -> this.connection.exec());
    }

    public void discard() {
        this.actionWrapper.doInScope("DISCARD", () -> this.connection.discard());
    }

    public void watch(byte[] ... keys) {
        this.actionWrapper.doInScope("WATCH", () -> this.connection.watch(keys));
    }

    public void unwatch() {
        this.actionWrapper.doInScope("UNWATCH", () -> this.connection.unwatch());
    }

    public Long publish(byte[] channel, byte[] message) {
        return this.actionWrapper.doInScope("PUBLISH", () -> this.connection.publish(channel, message));
    }

    public void subscribe(MessageListener listener, byte[] ... channels) {
        this.actionWrapper.doInScope("SUBSCRIBE", () -> this.connection.subscribe(listener, channels));
    }

    public void pSubscribe(MessageListener listener, byte[] ... patterns) {
        this.actionWrapper.doInScope("PSUBSCRIBE", () -> this.connection.pSubscribe(listener, patterns));
    }

    public void select(int dbIndex) {
        this.actionWrapper.doInScope("SELECT", () -> this.connection.select(dbIndex));
    }

    public byte[] echo(byte[] message) {
        return this.actionWrapper.doInScope("ECHO", () -> this.connection.echo(message));
    }

    public String ping() {
        return this.actionWrapper.doInScope("PING", () -> this.connection.ping());
    }

    public void bgReWriteAof() {
        this.actionWrapper.doInScope("BGREWRITEAOF", () -> this.connection.bgReWriteAof());
    }

    public void bgSave() {
        this.actionWrapper.doInScope("BGSAVE", () -> this.connection.bgSave());
    }

    public Long lastSave() {
        return this.actionWrapper.doInScope("LASTSAVE", () -> this.connection.lastSave());
    }

    public void save() {
        this.actionWrapper.doInScope("SAVE", () -> this.connection.save());
    }

    public Long dbSize() {
        return this.actionWrapper.doInScope("DBSIZE", () -> this.connection.dbSize());
    }

    public void flushDb() {
        this.actionWrapper.doInScope("FLUSHDB", () -> this.connection.flushDb());
    }

    public void flushAll() {
        this.actionWrapper.doInScope("FLUSHALL", () -> this.connection.flushAll());
    }

    public Properties info() {
        return this.actionWrapper.doInScope("INFO", () -> this.connection.info());
    }

    public Properties info(String section) {
        return this.actionWrapper.doInScope("INFO", () -> this.connection.info(section));
    }

    public void shutdown() {
        this.actionWrapper.doInScope("SHUTDOWN", () -> this.connection.shutdown());
    }

    public void shutdown(RedisServerCommands.ShutdownOption option) {
        this.actionWrapper.doInScope("SHUTDOWN", () -> this.connection.shutdown(option));
    }

    public Properties getConfig(String pattern) {
        return this.actionWrapper.doInScope("CONFIG GET", () -> this.connection.getConfig(pattern));
    }

    public void setConfig(String param, String value) {
        this.actionWrapper.doInScope("CONFIG SET", () -> this.connection.setConfig(param, value));
    }

    public void resetConfigStats() {
        this.actionWrapper.doInScope("CONFIG RESETSTAT", () -> this.connection.resetConfigStats());
    }

    public Long time() {
        return this.actionWrapper.doInScope("TIME", () -> this.connection.time());
    }

    public void killClient(String host, int port) {
        this.actionWrapper.doInScope("CLIENT KILL", () -> this.connection.killClient(host, port));
    }

    public void setClientName(byte[] name) {
        this.actionWrapper.doInScope("CLIENT SETNAME", () -> this.connection.setClientName(name));
    }

    public String getClientName() {
        return this.actionWrapper.doInScope("CLIENT GETNAME", () -> this.connection.getClientName());
    }

    public List<RedisClientInfo> getClientList() {
        return this.actionWrapper.doInScope("CLIENT LIST", () -> this.connection.getClientList());
    }

    public void replicaOf(String host, int port) {
        this.actionWrapper.doInScope("SLAVEOF", () -> this.connection.replicaOf(host, port));
    }

    public void replicaOfNoOne() {
        this.actionWrapper.doInScope("SLAVEOFNOONE", () -> this.connection.replicaOfNoOne());
    }

    public void migrate(byte[] key, RedisNode target, int dbIndex, RedisServerCommands.MigrateOption option) {
        this.actionWrapper.doInScope("MIGRATE", key, () -> this.connection.migrate(key, target, dbIndex, option));
    }

    public void migrate(byte[] key, RedisNode target, int dbIndex, RedisServerCommands.MigrateOption option, long timeout) {
        this.actionWrapper.doInScope("MIGRATE", key, () -> this.connection.migrate(key, target, dbIndex, option, timeout));
    }

    public void scriptFlush() {
        this.actionWrapper.doInScope("SCRIPT FLUSH", () -> this.connection.scriptFlush());
    }

    public void scriptKill() {
        this.actionWrapper.doInScope("SCRIPT KILL", () -> this.connection.scriptKill());
    }

    public String scriptLoad(byte[] script) {
        return this.actionWrapper.doInScope("SCRIPT LOAD", () -> this.connection.scriptLoad(script));
    }

    public List<Boolean> scriptExists(String ... scriptShas) {
        return this.actionWrapper.doInScope("SCRIPT EXISTS", () -> this.connection.scriptExists(scriptShas));
    }

    public <T> T eval(byte[] script, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        return (T)this.actionWrapper.doInScope("EVAL", () -> this.connection.eval(script, returnType, numKeys, keysAndArgs));
    }

    public <T> T evalSha(String scriptSha, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        return (T)this.actionWrapper.doInScope("EVALSHA", () -> this.connection.evalSha(scriptSha, returnType, numKeys, keysAndArgs));
    }

    public <T> T evalSha(byte[] scriptSha, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        return (T)this.actionWrapper.doInScope("EVALSHA", () -> this.connection.evalSha(scriptSha, returnType, numKeys, keysAndArgs));
    }

    public Long geoAdd(byte[] key, Point point, byte[] member) {
        return this.actionWrapper.doInScope("GEOADD", key, () -> this.connection.geoAdd(key, point, member));
    }

    public Long geoAdd(byte[] key, RedisGeoCommands.GeoLocation<byte[]> location) {
        return this.actionWrapper.doInScope("GEOADD", key, () -> this.connection.geoAdd(key, location));
    }

    public Long geoAdd(byte[] key, Map<byte[], Point> memberCoordinateMap) {
        return this.actionWrapper.doInScope("GEOADD", key, () -> this.connection.geoAdd(key, memberCoordinateMap));
    }

    public Long geoAdd(byte[] key, Iterable<RedisGeoCommands.GeoLocation<byte[]>> locations) {
        return this.actionWrapper.doInScope("GEOADD", key, () -> this.connection.geoAdd(key, locations));
    }

    public Distance geoDist(byte[] key, byte[] member1, byte[] member2) {
        return this.actionWrapper.doInScope("GEODIST", key, () -> this.connection.geoDist(key, member1, member2));
    }

    public Distance geoDist(byte[] key, byte[] member1, byte[] member2, Metric metric) {
        return this.actionWrapper.doInScope("GEODIST", key, () -> this.connection.geoDist(key, member1, member2, metric));
    }

    public List<String> geoHash(byte[] key, byte[] ... members) {
        return this.actionWrapper.doInScope("GEOHASH", key, () -> this.connection.geoHash(key, members));
    }

    public List<Point> geoPos(byte[] key, byte[] ... members) {
        return this.actionWrapper.doInScope("GEOPOS", key, () -> this.connection.geoPos(key, members));
    }

    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadius(byte[] key, Circle within) {
        return this.actionWrapper.doInScope("GEORADIUS", key, () -> this.connection.geoRadius(key, within));
    }

    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadius(byte[] key, Circle within, RedisGeoCommands.GeoRadiusCommandArgs args) {
        return this.actionWrapper.doInScope("GEORADIUS", key, () -> this.connection.geoRadius(key, within, args));
    }

    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, double radius) {
        return this.actionWrapper.doInScope("GEORADIUSBYMEMBER", key, () -> this.connection.geoRadiusByMember(key, member, radius));
    }

    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, Distance radius) {
        return this.actionWrapper.doInScope("GEORADIUSBYMEMBER", key, () -> this.connection.geoRadiusByMember(key, member, radius));
    }

    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, Distance radius, RedisGeoCommands.GeoRadiusCommandArgs args) {
        return this.actionWrapper.doInScope("GEORADIUSBYMEMBER", key, () -> this.connection.geoRadiusByMember(key, member, radius, args));
    }

    public Long geoRemove(byte[] key, byte[] ... members) {
        return this.actionWrapper.doInScope("GEOREMOVE", key, () -> this.connection.geoRemove(key, members));
    }

    public Long pfAdd(byte[] key, byte[] ... values) {
        return this.actionWrapper.doInScope("PFADD", key, () -> this.connection.pfAdd(key, values));
    }

    public Long pfCount(byte[] ... keys) {
        return this.actionWrapper.doInScope("PFCOUNT", keys, () -> this.connection.pfCount(keys));
    }

    public void pfMerge(byte[] destinationKey, byte[] ... sourceKeys) {
        this.actionWrapper.doInScope("PFMERGE", () -> this.connection.pfMerge(destinationKey, sourceKeys));
    }
}

