/*
 * Decompiled with CFR 0.152.
 */
package com.sofa.alipay.tracer.plugins.spring.redis.reporter;

import com.alipay.common.tracer.core.reporter.stat.AbstractSofaTracerStatisticReporter;
import com.alipay.common.tracer.core.reporter.stat.model.StatKey;
import com.alipay.common.tracer.core.reporter.stat.model.StatMapKey;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.utils.TracerUtils;
import io.opentracing.tag.Tags;
import java.util.Map;

public class RedisStatJsonReporter
extends AbstractSofaTracerStatisticReporter {
    public RedisStatJsonReporter(String statTracerName, String rollingPolicy, String logReserveConfig) {
        super(statTracerName, rollingPolicy, logReserveConfig);
    }

    public void doReportStat(SofaTracerSpan sofaTracerSpan) {
        Map tagsWithStr = sofaTracerSpan.getTagsWithStr();
        StatMapKey statKey = new StatMapKey();
        String localApp = (String)tagsWithStr.get("local.app");
        String dbType = (String)tagsWithStr.get(Tags.DB_TYPE.getKey());
        statKey.addKey("local.app", localApp);
        statKey.addKey(Tags.DB_TYPE.getKey(), dbType);
        String result = "00".equals(tagsWithStr.get("result.code")) ? "Y" : "N";
        statKey.setResult(result);
        statKey.setLoadTest(TracerUtils.isLoadTest((SofaTracerSpan)sofaTracerSpan));
        statKey.setEnd(TracerUtils.getLoadTestMark((SofaTracerSpan)sofaTracerSpan));
        long duration = sofaTracerSpan.getEndTime() - sofaTracerSpan.getStartTime();
        long[] values = new long[]{1L, duration};
        this.addStat((StatKey)statKey, values);
    }
}

