/*
 * Decompiled with CFR 0.152.
 */
package com.sofa.alipay.tracer.plugins.spring.redis.reporter;

import com.alipay.common.tracer.core.reporter.stat.AbstractSofaTracerStatisticReporter;
import com.alipay.common.tracer.core.reporter.stat.model.StatKey;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.utils.TracerUtils;
import io.opentracing.tag.Tags;
import java.util.Map;

public class RedisStatReporter
extends AbstractSofaTracerStatisticReporter {
    public RedisStatReporter(String statTracerName, String rollingPolicy, String logReserveConfig) {
        super(statTracerName, rollingPolicy, logReserveConfig);
    }

    public void doReportStat(SofaTracerSpan sofaTracerSpan) {
        Map tagsWithStr = sofaTracerSpan.getTagsWithStr();
        StatKey statKey = new StatKey();
        String localApp = (String)tagsWithStr.get("local.app");
        String dbType = (String)tagsWithStr.get(Tags.DB_TYPE.getKey());
        statKey.setKey(this.buildString(new String[]{localApp, dbType}));
        String resultCode = "00".equals(tagsWithStr.get("result.code")) ? "Y" : "N";
        statKey.setResult(resultCode);
        statKey.setEnd(this.buildString(new String[]{TracerUtils.getLoadTestMark((SofaTracerSpan)sofaTracerSpan)}));
        statKey.setLoadTest(TracerUtils.isLoadTest((SofaTracerSpan)sofaTracerSpan));
        long duration = sofaTracerSpan.getEndTime() - sofaTracerSpan.getStartTime();
        long[] values = new long[]{1L, duration};
        this.addStat(statKey, values);
    }
}

