/*
 * Decompiled with CFR 0.152.
 */
package com.sofa.alipay.tracer.plugins.spring.redis.tracer;

import com.alipay.common.tracer.core.appender.encoder.SpanEncoder;
import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.reporter.stat.AbstractSofaTracerStatisticReporter;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.tracer.AbstractClientTracer;
import com.sofa.alipay.tracer.plugins.spring.redis.encoder.RedisDigestEncoder;
import com.sofa.alipay.tracer.plugins.spring.redis.encoder.RedisDigestJsonEncoder;
import com.sofa.alipay.tracer.plugins.spring.redis.enums.RedisLogEnum;
import com.sofa.alipay.tracer.plugins.spring.redis.reporter.RedisStatJsonReporter;
import com.sofa.alipay.tracer.plugins.spring.redis.reporter.RedisStatReporter;

public class RedisSofaTracer
extends AbstractClientTracer {
    private static volatile RedisSofaTracer redisSofaTracer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RedisSofaTracer getRedisSofaTracerSingleton() {
        if (redisSofaTracer != null) return redisSofaTracer;
        Class<RedisSofaTracer> clazz = RedisSofaTracer.class;
        synchronized (RedisSofaTracer.class) {
            if (redisSofaTracer != null) return redisSofaTracer;
            redisSofaTracer = new RedisSofaTracer("redis");
            // ** MonitorExit[var0] (shouldn't be in output)
            return redisSofaTracer;
        }
    }

    public RedisSofaTracer(String tracerType) {
        super(tracerType);
    }

    protected String getClientDigestReporterLogName() {
        return RedisLogEnum.REDIS_DIGEST.getDefaultLogName();
    }

    protected String getClientDigestReporterRollingKey() {
        return RedisLogEnum.REDIS_DIGEST.getRollingKey();
    }

    protected String getClientDigestReporterLogNameKey() {
        return RedisLogEnum.REDIS_DIGEST.getLogNameKey();
    }

    protected SpanEncoder<SofaTracerSpan> getClientDigestEncoder() {
        if (SofaTracerConfiguration.isJsonOutput()) {
            return new RedisDigestJsonEncoder();
        }
        return new RedisDigestEncoder();
    }

    protected AbstractSofaTracerStatisticReporter generateClientStatReporter() {
        RedisLogEnum redisLogEnum = RedisLogEnum.REDIS_STAT;
        String statLog = redisLogEnum.getDefaultLogName();
        String statRollingPolicy = SofaTracerConfiguration.getRollingPolicy((String)redisLogEnum.getRollingKey());
        String statLogReserveConfig = SofaTracerConfiguration.getLogReserveConfig((String)redisLogEnum.getLogNameKey());
        return this.getRedisClientStatReporter(statLog, statRollingPolicy, statLogReserveConfig);
    }

    protected AbstractSofaTracerStatisticReporter getRedisClientStatReporter(String statTracerName, String statRollingPolicy, String statLogReserveConfig) {
        if (SofaTracerConfiguration.isJsonOutput()) {
            return new RedisStatJsonReporter(statTracerName, statRollingPolicy, statLogReserveConfig);
        }
        return new RedisStatReporter(statTracerName, statRollingPolicy, statLogReserveConfig);
    }
}

