/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.springmvc;

import com.alipay.common.tracer.core.SofaTracer;
import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.context.span.SofaTracerSpanContext;
import com.alipay.common.tracer.core.registry.ExtendFormat;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.utils.StringUtils;
import com.alipay.sofa.tracer.plugins.springmvc.SpringMvcHeadersCarrier;
import com.alipay.sofa.tracer.plugins.springmvc.SpringMvcTracer;
import io.opentracing.tag.Tags;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;

public class SpringMvcSofaTracerFilter
implements Filter {
    private String appName = "";
    private SpringMvcTracer springMvcTracer;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) {
        int httpStatus;
        long responseSize;
        SofaTracerSpan springMvcSpan;
        block9: {
            if (this.springMvcTracer == null) {
                this.springMvcTracer = SpringMvcTracer.getSpringMvcTracerSingleton();
            }
            springMvcSpan = null;
            responseSize = -1L;
            httpStatus = -1;
            Throwable currThrowable = null;
            boolean errorFlag = false;
            try {
                HttpServletRequest request = (HttpServletRequest)servletRequest;
                HttpServletResponse response = (HttpServletResponse)servletResponse;
                SofaTracerSpanContext spanContext = this.getSpanContextFromRequest(request);
                springMvcSpan = this.springMvcTracer.serverReceive(spanContext);
                if (StringUtils.isBlank((String)this.appName)) {
                    this.appName = SofaTracerConfiguration.getProperty((String)"spring.application.name");
                }
                springMvcSpan.setOperationName(request.getRequestURL().toString());
                springMvcSpan.setTag("local.app", this.appName);
                springMvcSpan.setTag("request.url", request.getRequestURL().toString());
                springMvcSpan.setTag("method", request.getMethod());
                springMvcSpan.setTag("req.size.bytes", (Number)request.getContentLength());
                ResponseWrapper responseWrapper = new ResponseWrapper(response);
                filterChain.doFilter(servletRequest, (ServletResponse)responseWrapper);
                httpStatus = responseWrapper.getStatus();
                responseSize = responseWrapper.getContentLength();
                if (!errorFlag) break block9;
            }
            catch (Throwable t) {
                try {
                    httpStatus = 500;
                    errorFlag = true;
                    currThrowable = t;
                    throw new RuntimeException(t);
                }
                catch (Throwable throwable) {
                    if (errorFlag) {
                        springMvcSpan.setTag(Tags.ERROR.getKey(), null == currThrowable ? "an error occurred!" : currThrowable.getMessage());
                    }
                    if (springMvcSpan != null) {
                        springMvcSpan.setTag("resp.size.bytes", (Number)responseSize);
                        this.springMvcTracer.serverSend(String.valueOf(httpStatus));
                    }
                    throw throwable;
                }
            }
            springMvcSpan.setTag(Tags.ERROR.getKey(), null == currThrowable ? "an error occurred!" : currThrowable.getMessage());
        }
        if (springMvcSpan != null) {
            springMvcSpan.setTag("resp.size.bytes", (Number)responseSize);
            this.springMvcTracer.serverSend(String.valueOf(httpStatus));
        }
    }

    public void destroy() {
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getFilterName() {
        return "SpringMvcSofaTracerFilter";
    }

    public SofaTracerSpanContext getSpanContextFromRequest(HttpServletRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = request.getHeader(key);
            headers.put(key, value);
        }
        if (headers.isEmpty() || !this.isContainSofaTracerMark(headers)) {
            return null;
        }
        SofaTracer tracer = this.springMvcTracer.getSofaTracer();
        SofaTracerSpanContext spanContext = (SofaTracerSpanContext)tracer.extract(ExtendFormat.Builtin.B3_HTTP_HEADERS, (Object)new SpringMvcHeadersCarrier(headers));
        return spanContext;
    }

    private boolean isContainSofaTracerMark(HashMap<String, String> headers) {
        return !(!headers.containsKey("X-B3-TraceId".toLowerCase()) && !headers.containsKey("X-B3-TraceId") || !headers.containsKey("X-B3-SpanId".toLowerCase()) && !headers.containsKey("X-B3-SpanId"));
    }

    class ResponseWrapper
    extends HttpServletResponseWrapper {
        int contentLength;

        public ResponseWrapper(HttpServletResponse httpServletResponse) throws IOException {
            super(httpServletResponse);
            this.contentLength = 0;
        }

        public void setContentLength(int len) {
            this.contentLength = len;
            super.setContentLength(len);
        }

        public int getContentLength() {
            return this.contentLength;
        }
    }
}

