/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.alidns20150109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class AddCustomLineRequest
extends Request {
    @Query
    @NameInMap(value="DomainName")
    @Validation(required=true)
    private String domainName;
    @Query
    @NameInMap(value="IpSegment")
    @Validation(required=true)
    private List<IpSegment> ipSegment;
    @Query
    @NameInMap(value="Lang")
    private String lang;
    @Query
    @NameInMap(value="LineName")
    @Validation(required=true)
    private String lineName;

    private AddCustomLineRequest(Builder builder) {
        super((Request.Builder)builder);
        this.domainName = builder.domainName;
        this.ipSegment = builder.ipSegment;
        this.lang = builder.lang;
        this.lineName = builder.lineName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AddCustomLineRequest create() {
        return AddCustomLineRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public List<IpSegment> getIpSegment() {
        return this.ipSegment;
    }

    public String getLang() {
        return this.lang;
    }

    public String getLineName() {
        return this.lineName;
    }

    public static class IpSegment
    extends TeaModel {
        @NameInMap(value="EndIp")
        private String endIp;
        @NameInMap(value="StartIp")
        private String startIp;

        private IpSegment(Builder builder) {
            this.endIp = builder.endIp;
            this.startIp = builder.startIp;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static IpSegment create() {
            return IpSegment.builder().build();
        }

        public String getEndIp() {
            return this.endIp;
        }

        public String getStartIp() {
            return this.startIp;
        }

        public static final class Builder {
            private String endIp;
            private String startIp;

            private Builder() {
            }

            private Builder(IpSegment model) {
                this.endIp = model.endIp;
                this.startIp = model.startIp;
            }

            public Builder endIp(String endIp) {
                this.endIp = endIp;
                return this;
            }

            public Builder startIp(String startIp) {
                this.startIp = startIp;
                return this;
            }

            public IpSegment build() {
                return new IpSegment(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<AddCustomLineRequest, Builder> {
        private String domainName;
        private List<IpSegment> ipSegment;
        private String lang;
        private String lineName;

        private Builder() {
        }

        private Builder(AddCustomLineRequest request) {
            super((Request)request);
            this.domainName = request.domainName;
            this.ipSegment = request.ipSegment;
            this.lang = request.lang;
            this.lineName = request.lineName;
        }

        public Builder domainName(String domainName) {
            this.putQueryParameter("DomainName", domainName);
            this.domainName = domainName;
            return this;
        }

        public Builder ipSegment(List<IpSegment> ipSegment) {
            this.putQueryParameter("IpSegment", ipSegment);
            this.ipSegment = ipSegment;
            return this;
        }

        public Builder lang(String lang) {
            this.putQueryParameter("Lang", lang);
            this.lang = lang;
            return this;
        }

        public Builder lineName(String lineName) {
            this.putQueryParameter("LineName", lineName);
            this.lineName = lineName;
            return this;
        }

        public AddCustomLineRequest build() {
            return new AddCustomLineRequest(this);
        }
    }
}

