/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.alidns20150109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class AddDnsCacheDomainRequest
extends Request {
    @Query
    @NameInMap(value="CacheTtlMax")
    @Validation(required=true, maximum=86400.0, minimum=30.0)
    private Integer cacheTtlMax;
    @Query
    @NameInMap(value="CacheTtlMin")
    @Validation(required=true, maximum=86400.0, minimum=30.0)
    private Integer cacheTtlMin;
    @Query
    @NameInMap(value="DomainName")
    @Validation(required=true)
    private String domainName;
    @Query
    @NameInMap(value="InstanceId")
    @Validation(required=true)
    private String instanceId;
    @Query
    @NameInMap(value="Lang")
    private String lang;
    @Query
    @NameInMap(value="Remark")
    private String remark;
    @Query
    @NameInMap(value="SourceDnsServer")
    @Validation(required=true)
    private List<SourceDnsServer> sourceDnsServer;
    @Query
    @NameInMap(value="SourceEdns")
    @Validation(required=true)
    private String sourceEdns;
    @Query
    @NameInMap(value="SourceProtocol")
    @Validation(required=true)
    private String sourceProtocol;

    private AddDnsCacheDomainRequest(Builder builder) {
        super((Request.Builder)builder);
        this.cacheTtlMax = builder.cacheTtlMax;
        this.cacheTtlMin = builder.cacheTtlMin;
        this.domainName = builder.domainName;
        this.instanceId = builder.instanceId;
        this.lang = builder.lang;
        this.remark = builder.remark;
        this.sourceDnsServer = builder.sourceDnsServer;
        this.sourceEdns = builder.sourceEdns;
        this.sourceProtocol = builder.sourceProtocol;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AddDnsCacheDomainRequest create() {
        return AddDnsCacheDomainRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Integer getCacheTtlMax() {
        return this.cacheTtlMax;
    }

    public Integer getCacheTtlMin() {
        return this.cacheTtlMin;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getLang() {
        return this.lang;
    }

    public String getRemark() {
        return this.remark;
    }

    public List<SourceDnsServer> getSourceDnsServer() {
        return this.sourceDnsServer;
    }

    public String getSourceEdns() {
        return this.sourceEdns;
    }

    public String getSourceProtocol() {
        return this.sourceProtocol;
    }

    public static class SourceDnsServer
    extends TeaModel {
        @NameInMap(value="Host")
        @Validation(required=true)
        private String host;
        @NameInMap(value="Port")
        @Validation(required=true)
        private String port;

        private SourceDnsServer(Builder builder) {
            this.host = builder.host;
            this.port = builder.port;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static SourceDnsServer create() {
            return SourceDnsServer.builder().build();
        }

        public String getHost() {
            return this.host;
        }

        public String getPort() {
            return this.port;
        }

        public static final class Builder {
            private String host;
            private String port;

            private Builder() {
            }

            private Builder(SourceDnsServer model) {
                this.host = model.host;
                this.port = model.port;
            }

            public Builder host(String host) {
                this.host = host;
                return this;
            }

            public Builder port(String port) {
                this.port = port;
                return this;
            }

            public SourceDnsServer build() {
                return new SourceDnsServer(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<AddDnsCacheDomainRequest, Builder> {
        private Integer cacheTtlMax;
        private Integer cacheTtlMin;
        private String domainName;
        private String instanceId;
        private String lang;
        private String remark;
        private List<SourceDnsServer> sourceDnsServer;
        private String sourceEdns;
        private String sourceProtocol;

        private Builder() {
        }

        private Builder(AddDnsCacheDomainRequest request) {
            super((Request)request);
            this.cacheTtlMax = request.cacheTtlMax;
            this.cacheTtlMin = request.cacheTtlMin;
            this.domainName = request.domainName;
            this.instanceId = request.instanceId;
            this.lang = request.lang;
            this.remark = request.remark;
            this.sourceDnsServer = request.sourceDnsServer;
            this.sourceEdns = request.sourceEdns;
            this.sourceProtocol = request.sourceProtocol;
        }

        public Builder cacheTtlMax(Integer cacheTtlMax) {
            this.putQueryParameter("CacheTtlMax", cacheTtlMax);
            this.cacheTtlMax = cacheTtlMax;
            return this;
        }

        public Builder cacheTtlMin(Integer cacheTtlMin) {
            this.putQueryParameter("CacheTtlMin", cacheTtlMin);
            this.cacheTtlMin = cacheTtlMin;
            return this;
        }

        public Builder domainName(String domainName) {
            this.putQueryParameter("DomainName", domainName);
            this.domainName = domainName;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.putQueryParameter("InstanceId", instanceId);
            this.instanceId = instanceId;
            return this;
        }

        public Builder lang(String lang) {
            this.putQueryParameter("Lang", lang);
            this.lang = lang;
            return this;
        }

        public Builder remark(String remark) {
            this.putQueryParameter("Remark", remark);
            this.remark = remark;
            return this;
        }

        public Builder sourceDnsServer(List<SourceDnsServer> sourceDnsServer) {
            this.putQueryParameter("SourceDnsServer", sourceDnsServer);
            this.sourceDnsServer = sourceDnsServer;
            return this;
        }

        public Builder sourceEdns(String sourceEdns) {
            this.putQueryParameter("SourceEdns", sourceEdns);
            this.sourceEdns = sourceEdns;
            return this;
        }

        public Builder sourceProtocol(String sourceProtocol) {
            this.putQueryParameter("SourceProtocol", sourceProtocol);
            this.sourceProtocol = sourceProtocol;
            return this;
        }

        public AddDnsCacheDomainRequest build() {
            return new AddDnsCacheDomainRequest(this);
        }
    }
}

