/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.alidns20150109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class AddDnsGtmAddressPoolRequest
extends Request {
    @Query
    @NameInMap(value="Addr")
    @Validation(required=true)
    private List<Addr> addr;
    @Query
    @NameInMap(value="EvaluationCount")
    @Validation(maximum=9999999.0, minimum=1.0)
    private Integer evaluationCount;
    @Query
    @NameInMap(value="InstanceId")
    @Validation(required=true)
    private String instanceId;
    @Query
    @NameInMap(value="Interval")
    @Validation(maximum=9999999.0, minimum=1.0)
    private Integer interval;
    @Query
    @NameInMap(value="IspCityNode")
    private List<IspCityNode> ispCityNode;
    @Query
    @NameInMap(value="Lang")
    private String lang;
    @Query
    @NameInMap(value="LbaStrategy")
    @Validation(required=true)
    private String lbaStrategy;
    @Query
    @NameInMap(value="MonitorExtendInfo")
    private String monitorExtendInfo;
    @Query
    @NameInMap(value="MonitorStatus")
    private String monitorStatus;
    @Query
    @NameInMap(value="Name")
    @Validation(required=true)
    private String name;
    @Query
    @NameInMap(value="ProtocolType")
    private String protocolType;
    @Query
    @NameInMap(value="Timeout")
    @Validation(maximum=9999999.0, minimum=1.0)
    private Integer timeout;
    @Query
    @NameInMap(value="Type")
    @Validation(required=true)
    private String type;

    private AddDnsGtmAddressPoolRequest(Builder builder) {
        super((Request.Builder)builder);
        this.addr = builder.addr;
        this.evaluationCount = builder.evaluationCount;
        this.instanceId = builder.instanceId;
        this.interval = builder.interval;
        this.ispCityNode = builder.ispCityNode;
        this.lang = builder.lang;
        this.lbaStrategy = builder.lbaStrategy;
        this.monitorExtendInfo = builder.monitorExtendInfo;
        this.monitorStatus = builder.monitorStatus;
        this.name = builder.name;
        this.protocolType = builder.protocolType;
        this.timeout = builder.timeout;
        this.type = builder.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AddDnsGtmAddressPoolRequest create() {
        return AddDnsGtmAddressPoolRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<Addr> getAddr() {
        return this.addr;
    }

    public Integer getEvaluationCount() {
        return this.evaluationCount;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public Integer getInterval() {
        return this.interval;
    }

    public List<IspCityNode> getIspCityNode() {
        return this.ispCityNode;
    }

    public String getLang() {
        return this.lang;
    }

    public String getLbaStrategy() {
        return this.lbaStrategy;
    }

    public String getMonitorExtendInfo() {
        return this.monitorExtendInfo;
    }

    public String getMonitorStatus() {
        return this.monitorStatus;
    }

    public String getName() {
        return this.name;
    }

    public String getProtocolType() {
        return this.protocolType;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public String getType() {
        return this.type;
    }

    public static class IspCityNode
    extends TeaModel {
        @NameInMap(value="CityCode")
        private String cityCode;
        @NameInMap(value="IspCode")
        private String ispCode;

        private IspCityNode(Builder builder) {
            this.cityCode = builder.cityCode;
            this.ispCode = builder.ispCode;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static IspCityNode create() {
            return IspCityNode.builder().build();
        }

        public String getCityCode() {
            return this.cityCode;
        }

        public String getIspCode() {
            return this.ispCode;
        }

        public static final class Builder {
            private String cityCode;
            private String ispCode;

            private Builder() {
            }

            private Builder(IspCityNode model) {
                this.cityCode = model.cityCode;
                this.ispCode = model.ispCode;
            }

            public Builder cityCode(String cityCode) {
                this.cityCode = cityCode;
                return this;
            }

            public Builder ispCode(String ispCode) {
                this.ispCode = ispCode;
                return this;
            }

            public IspCityNode build() {
                return new IspCityNode(this);
            }
        }
    }

    public static class Addr
    extends TeaModel {
        @NameInMap(value="Addr")
        @Validation(required=true)
        private String addr;
        @NameInMap(value="AttributeInfo")
        @Validation(required=true)
        private String attributeInfo;
        @NameInMap(value="LbaWeight")
        private Integer lbaWeight;
        @NameInMap(value="Mode")
        @Validation(required=true)
        private String mode;
        @NameInMap(value="Remark")
        private String remark;

        private Addr(Builder builder) {
            this.addr = builder.addr;
            this.attributeInfo = builder.attributeInfo;
            this.lbaWeight = builder.lbaWeight;
            this.mode = builder.mode;
            this.remark = builder.remark;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Addr create() {
            return Addr.builder().build();
        }

        public String getAddr() {
            return this.addr;
        }

        public String getAttributeInfo() {
            return this.attributeInfo;
        }

        public Integer getLbaWeight() {
            return this.lbaWeight;
        }

        public String getMode() {
            return this.mode;
        }

        public String getRemark() {
            return this.remark;
        }

        public static final class Builder {
            private String addr;
            private String attributeInfo;
            private Integer lbaWeight;
            private String mode;
            private String remark;

            private Builder() {
            }

            private Builder(Addr model) {
                this.addr = model.addr;
                this.attributeInfo = model.attributeInfo;
                this.lbaWeight = model.lbaWeight;
                this.mode = model.mode;
                this.remark = model.remark;
            }

            public Builder addr(String addr) {
                this.addr = addr;
                return this;
            }

            public Builder attributeInfo(String attributeInfo) {
                this.attributeInfo = attributeInfo;
                return this;
            }

            public Builder lbaWeight(Integer lbaWeight) {
                this.lbaWeight = lbaWeight;
                return this;
            }

            public Builder mode(String mode) {
                this.mode = mode;
                return this;
            }

            public Builder remark(String remark) {
                this.remark = remark;
                return this;
            }

            public Addr build() {
                return new Addr(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<AddDnsGtmAddressPoolRequest, Builder> {
        private List<Addr> addr;
        private Integer evaluationCount;
        private String instanceId;
        private Integer interval;
        private List<IspCityNode> ispCityNode;
        private String lang;
        private String lbaStrategy;
        private String monitorExtendInfo;
        private String monitorStatus;
        private String name;
        private String protocolType;
        private Integer timeout;
        private String type;

        private Builder() {
        }

        private Builder(AddDnsGtmAddressPoolRequest request) {
            super((Request)request);
            this.addr = request.addr;
            this.evaluationCount = request.evaluationCount;
            this.instanceId = request.instanceId;
            this.interval = request.interval;
            this.ispCityNode = request.ispCityNode;
            this.lang = request.lang;
            this.lbaStrategy = request.lbaStrategy;
            this.monitorExtendInfo = request.monitorExtendInfo;
            this.monitorStatus = request.monitorStatus;
            this.name = request.name;
            this.protocolType = request.protocolType;
            this.timeout = request.timeout;
            this.type = request.type;
        }

        public Builder addr(List<Addr> addr) {
            this.putQueryParameter("Addr", addr);
            this.addr = addr;
            return this;
        }

        public Builder evaluationCount(Integer evaluationCount) {
            this.putQueryParameter("EvaluationCount", evaluationCount);
            this.evaluationCount = evaluationCount;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.putQueryParameter("InstanceId", instanceId);
            this.instanceId = instanceId;
            return this;
        }

        public Builder interval(Integer interval) {
            this.putQueryParameter("Interval", interval);
            this.interval = interval;
            return this;
        }

        public Builder ispCityNode(List<IspCityNode> ispCityNode) {
            this.putQueryParameter("IspCityNode", ispCityNode);
            this.ispCityNode = ispCityNode;
            return this;
        }

        public Builder lang(String lang) {
            this.putQueryParameter("Lang", lang);
            this.lang = lang;
            return this;
        }

        public Builder lbaStrategy(String lbaStrategy) {
            this.putQueryParameter("LbaStrategy", lbaStrategy);
            this.lbaStrategy = lbaStrategy;
            return this;
        }

        public Builder monitorExtendInfo(String monitorExtendInfo) {
            this.putQueryParameter("MonitorExtendInfo", monitorExtendInfo);
            this.monitorExtendInfo = monitorExtendInfo;
            return this;
        }

        public Builder monitorStatus(String monitorStatus) {
            this.putQueryParameter("MonitorStatus", monitorStatus);
            this.monitorStatus = monitorStatus;
            return this;
        }

        public Builder name(String name) {
            this.putQueryParameter("Name", name);
            this.name = name;
            return this;
        }

        public Builder protocolType(String protocolType) {
            this.putQueryParameter("ProtocolType", protocolType);
            this.protocolType = protocolType;
            return this;
        }

        public Builder timeout(Integer timeout) {
            this.putQueryParameter("Timeout", timeout);
            this.timeout = timeout;
            return this;
        }

        public Builder type(String type) {
            this.putQueryParameter("Type", type);
            this.type = type;
            return this;
        }

        public AddDnsGtmAddressPoolRequest build() {
            return new AddDnsGtmAddressPoolRequest(this);
        }
    }
}

