/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.alidns20150109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class AddDomainRecordRequest
extends Request {
    @Query
    @NameInMap(value="DomainName")
    @Validation(required=true)
    private String domainName;
    @Query
    @NameInMap(value="Lang")
    private String lang;
    @Query
    @NameInMap(value="Line")
    private String line;
    @Query
    @NameInMap(value="Priority")
    @Validation(maximum=65535.0)
    private Long priority;
    @Query
    @NameInMap(value="RR")
    @Validation(required=true)
    private String rr;
    @Query
    @NameInMap(value="TTL")
    @Validation(maximum=86400.0, minimum=1.0)
    private Long TTL;
    @Query
    @NameInMap(value="Type")
    @Validation(required=true)
    private String type;
    @Query
    @NameInMap(value="UserClientIp")
    private String userClientIp;
    @Query
    @NameInMap(value="Value")
    @Validation(required=true)
    private String value;

    private AddDomainRecordRequest(Builder builder) {
        super((Request.Builder)builder);
        this.domainName = builder.domainName;
        this.lang = builder.lang;
        this.line = builder.line;
        this.priority = builder.priority;
        this.rr = builder.rr;
        this.TTL = builder.TTL;
        this.type = builder.type;
        this.userClientIp = builder.userClientIp;
        this.value = builder.value;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AddDomainRecordRequest create() {
        return AddDomainRecordRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getLang() {
        return this.lang;
    }

    public String getLine() {
        return this.line;
    }

    public Long getPriority() {
        return this.priority;
    }

    public String getRr() {
        return this.rr;
    }

    public Long getTTL() {
        return this.TTL;
    }

    public String getType() {
        return this.type;
    }

    public String getUserClientIp() {
        return this.userClientIp;
    }

    public String getValue() {
        return this.value;
    }

    public static final class Builder
    extends Request.Builder<AddDomainRecordRequest, Builder> {
        private String domainName;
        private String lang;
        private String line;
        private Long priority;
        private String rr;
        private Long TTL;
        private String type;
        private String userClientIp;
        private String value;

        private Builder() {
        }

        private Builder(AddDomainRecordRequest request) {
            super((Request)request);
            this.domainName = request.domainName;
            this.lang = request.lang;
            this.line = request.line;
            this.priority = request.priority;
            this.rr = request.rr;
            this.TTL = request.TTL;
            this.type = request.type;
            this.userClientIp = request.userClientIp;
            this.value = request.value;
        }

        public Builder domainName(String domainName) {
            this.putQueryParameter("DomainName", domainName);
            this.domainName = domainName;
            return this;
        }

        public Builder lang(String lang) {
            this.putQueryParameter("Lang", lang);
            this.lang = lang;
            return this;
        }

        public Builder line(String line) {
            this.putQueryParameter("Line", line);
            this.line = line;
            return this;
        }

        public Builder priority(Long priority) {
            this.putQueryParameter("Priority", priority);
            this.priority = priority;
            return this;
        }

        public Builder rr(String rr) {
            this.putQueryParameter("RR", rr);
            this.rr = rr;
            return this;
        }

        public Builder TTL(Long TTL) {
            this.putQueryParameter("TTL", TTL);
            this.TTL = TTL;
            return this;
        }

        public Builder type(String type) {
            this.putQueryParameter("Type", type);
            this.type = type;
            return this;
        }

        public Builder userClientIp(String userClientIp) {
            this.putQueryParameter("UserClientIp", userClientIp);
            this.userClientIp = userClientIp;
            return this;
        }

        public Builder value(String value) {
            this.putQueryParameter("Value", value);
            this.value = value;
            return this;
        }

        public AddDomainRecordRequest build() {
            return new AddDomainRecordRequest(this);
        }
    }
}

