/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.alidns20150109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class CreateCloudGtmAddressRequest
extends Request {
    @Query
    @NameInMap(value="AcceptLanguage")
    private String acceptLanguage;
    @Query
    @NameInMap(value="Address")
    @Validation(required=true)
    private String address;
    @Query
    @NameInMap(value="AttributeInfo")
    private String attributeInfo;
    @Query
    @NameInMap(value="AvailableMode")
    @Validation(required=true)
    private String availableMode;
    @Query
    @NameInMap(value="ClientToken")
    private String clientToken;
    @Query
    @NameInMap(value="EnableStatus")
    @Validation(required=true)
    private String enableStatus;
    @Query
    @NameInMap(value="HealthJudgement")
    @Validation(required=true)
    private String healthJudgement;
    @Query
    @NameInMap(value="HealthTasks")
    private List<HealthTasks> healthTasks;
    @Query
    @NameInMap(value="ManualAvailableStatus")
    private String manualAvailableStatus;
    @Query
    @NameInMap(value="Name")
    @Validation(required=true)
    private String name;
    @Query
    @NameInMap(value="Remark")
    private String remark;
    @Query
    @NameInMap(value="Type")
    @Validation(required=true)
    private String type;

    private CreateCloudGtmAddressRequest(Builder builder) {
        super((Request.Builder)builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.address = builder.address;
        this.attributeInfo = builder.attributeInfo;
        this.availableMode = builder.availableMode;
        this.clientToken = builder.clientToken;
        this.enableStatus = builder.enableStatus;
        this.healthJudgement = builder.healthJudgement;
        this.healthTasks = builder.healthTasks;
        this.manualAvailableStatus = builder.manualAvailableStatus;
        this.name = builder.name;
        this.remark = builder.remark;
        this.type = builder.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateCloudGtmAddressRequest create() {
        return CreateCloudGtmAddressRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAcceptLanguage() {
        return this.acceptLanguage;
    }

    public String getAddress() {
        return this.address;
    }

    public String getAttributeInfo() {
        return this.attributeInfo;
    }

    public String getAvailableMode() {
        return this.availableMode;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public String getEnableStatus() {
        return this.enableStatus;
    }

    public String getHealthJudgement() {
        return this.healthJudgement;
    }

    public List<HealthTasks> getHealthTasks() {
        return this.healthTasks;
    }

    public String getManualAvailableStatus() {
        return this.manualAvailableStatus;
    }

    public String getName() {
        return this.name;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getType() {
        return this.type;
    }

    public static class HealthTasks
    extends TeaModel {
        @NameInMap(value="Port")
        private Integer port;
        @NameInMap(value="TemplateId")
        private String templateId;

        private HealthTasks(Builder builder) {
            this.port = builder.port;
            this.templateId = builder.templateId;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static HealthTasks create() {
            return HealthTasks.builder().build();
        }

        public Integer getPort() {
            return this.port;
        }

        public String getTemplateId() {
            return this.templateId;
        }

        public static final class Builder {
            private Integer port;
            private String templateId;

            private Builder() {
            }

            private Builder(HealthTasks model) {
                this.port = model.port;
                this.templateId = model.templateId;
            }

            public Builder port(Integer port) {
                this.port = port;
                return this;
            }

            public Builder templateId(String templateId) {
                this.templateId = templateId;
                return this;
            }

            public HealthTasks build() {
                return new HealthTasks(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<CreateCloudGtmAddressRequest, Builder> {
        private String acceptLanguage;
        private String address;
        private String attributeInfo;
        private String availableMode;
        private String clientToken;
        private String enableStatus;
        private String healthJudgement;
        private List<HealthTasks> healthTasks;
        private String manualAvailableStatus;
        private String name;
        private String remark;
        private String type;

        private Builder() {
        }

        private Builder(CreateCloudGtmAddressRequest request) {
            super((Request)request);
            this.acceptLanguage = request.acceptLanguage;
            this.address = request.address;
            this.attributeInfo = request.attributeInfo;
            this.availableMode = request.availableMode;
            this.clientToken = request.clientToken;
            this.enableStatus = request.enableStatus;
            this.healthJudgement = request.healthJudgement;
            this.healthTasks = request.healthTasks;
            this.manualAvailableStatus = request.manualAvailableStatus;
            this.name = request.name;
            this.remark = request.remark;
            this.type = request.type;
        }

        public Builder acceptLanguage(String acceptLanguage) {
            this.putQueryParameter("AcceptLanguage", acceptLanguage);
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public Builder address(String address) {
            this.putQueryParameter("Address", address);
            this.address = address;
            return this;
        }

        public Builder attributeInfo(String attributeInfo) {
            this.putQueryParameter("AttributeInfo", attributeInfo);
            this.attributeInfo = attributeInfo;
            return this;
        }

        public Builder availableMode(String availableMode) {
            this.putQueryParameter("AvailableMode", availableMode);
            this.availableMode = availableMode;
            return this;
        }

        public Builder clientToken(String clientToken) {
            this.putQueryParameter("ClientToken", clientToken);
            this.clientToken = clientToken;
            return this;
        }

        public Builder enableStatus(String enableStatus) {
            this.putQueryParameter("EnableStatus", enableStatus);
            this.enableStatus = enableStatus;
            return this;
        }

        public Builder healthJudgement(String healthJudgement) {
            this.putQueryParameter("HealthJudgement", healthJudgement);
            this.healthJudgement = healthJudgement;
            return this;
        }

        public Builder healthTasks(List<HealthTasks> healthTasks) {
            String healthTasksShrink = this.shrink(healthTasks, "HealthTasks", "json");
            this.putQueryParameter("HealthTasks", healthTasksShrink);
            this.healthTasks = healthTasks;
            return this;
        }

        public Builder manualAvailableStatus(String manualAvailableStatus) {
            this.putQueryParameter("ManualAvailableStatus", manualAvailableStatus);
            this.manualAvailableStatus = manualAvailableStatus;
            return this;
        }

        public Builder name(String name) {
            this.putQueryParameter("Name", name);
            this.name = name;
            return this;
        }

        public Builder remark(String remark) {
            this.putQueryParameter("Remark", remark);
            this.remark = remark;
            return this;
        }

        public Builder type(String type) {
            this.putQueryParameter("Type", type);
            this.type = type;
            return this;
        }

        public CreateCloudGtmAddressRequest build() {
            return new CreateCloudGtmAddressRequest(this);
        }
    }
}

