/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.alidns20150109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class DescribeDnsGtmInstancesRequest
extends Request {
    @Query
    @NameInMap(value="Keyword")
    private String keyword;
    @Query
    @NameInMap(value="Lang")
    private String lang;
    @Query
    @NameInMap(value="PageNumber")
    @Validation(maximum=9999999.0, minimum=1.0)
    private Integer pageNumber;
    @Query
    @NameInMap(value="PageSize")
    @Validation(maximum=100.0, minimum=1.0)
    private Integer pageSize;
    @Query
    @NameInMap(value="ResourceGroupId")
    private String resourceGroupId;

    private DescribeDnsGtmInstancesRequest(Builder builder) {
        super((Request.Builder)builder);
        this.keyword = builder.keyword;
        this.lang = builder.lang;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
        this.resourceGroupId = builder.resourceGroupId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DescribeDnsGtmInstancesRequest create() {
        return DescribeDnsGtmInstancesRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getLang() {
        return this.lang;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getResourceGroupId() {
        return this.resourceGroupId;
    }

    public static final class Builder
    extends Request.Builder<DescribeDnsGtmInstancesRequest, Builder> {
        private String keyword;
        private String lang;
        private Integer pageNumber;
        private Integer pageSize;
        private String resourceGroupId;

        private Builder() {
        }

        private Builder(DescribeDnsGtmInstancesRequest request) {
            super((Request)request);
            this.keyword = request.keyword;
            this.lang = request.lang;
            this.pageNumber = request.pageNumber;
            this.pageSize = request.pageSize;
            this.resourceGroupId = request.resourceGroupId;
        }

        public Builder keyword(String keyword) {
            this.putQueryParameter("Keyword", keyword);
            this.keyword = keyword;
            return this;
        }

        public Builder lang(String lang) {
            this.putQueryParameter("Lang", lang);
            this.lang = lang;
            return this;
        }

        public Builder pageNumber(Integer pageNumber) {
            this.putQueryParameter("PageNumber", pageNumber);
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder resourceGroupId(String resourceGroupId) {
            this.putQueryParameter("ResourceGroupId", resourceGroupId);
            this.resourceGroupId = resourceGroupId;
            return this;
        }

        public DescribeDnsGtmInstancesRequest build() {
            return new DescribeDnsGtmInstancesRequest(this);
        }
    }
}

