/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.alidns20150109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class DescribeDomainsRequest
extends Request {
    @Query
    @NameInMap(value="GroupId")
    private String groupId;
    @Query
    @NameInMap(value="KeyWord")
    private String keyWord;
    @Query
    @NameInMap(value="Lang")
    private String lang;
    @Query
    @NameInMap(value="PageNumber")
    private Long pageNumber;
    @Query
    @NameInMap(value="PageSize")
    @Validation(maximum=100.0, minimum=1.0)
    private Long pageSize;
    @Query
    @NameInMap(value="ResourceGroupId")
    private String resourceGroupId;
    @Query
    @NameInMap(value="SearchMode")
    private String searchMode;
    @Query
    @NameInMap(value="Starmark")
    private Boolean starmark;

    private DescribeDomainsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.groupId = builder.groupId;
        this.keyWord = builder.keyWord;
        this.lang = builder.lang;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
        this.resourceGroupId = builder.resourceGroupId;
        this.searchMode = builder.searchMode;
        this.starmark = builder.starmark;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DescribeDomainsRequest create() {
        return DescribeDomainsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getKeyWord() {
        return this.keyWord;
    }

    public String getLang() {
        return this.lang;
    }

    public Long getPageNumber() {
        return this.pageNumber;
    }

    public Long getPageSize() {
        return this.pageSize;
    }

    public String getResourceGroupId() {
        return this.resourceGroupId;
    }

    public String getSearchMode() {
        return this.searchMode;
    }

    public Boolean getStarmark() {
        return this.starmark;
    }

    public static final class Builder
    extends Request.Builder<DescribeDomainsRequest, Builder> {
        private String groupId;
        private String keyWord;
        private String lang;
        private Long pageNumber;
        private Long pageSize;
        private String resourceGroupId;
        private String searchMode;
        private Boolean starmark;

        private Builder() {
        }

        private Builder(DescribeDomainsRequest request) {
            super((Request)request);
            this.groupId = request.groupId;
            this.keyWord = request.keyWord;
            this.lang = request.lang;
            this.pageNumber = request.pageNumber;
            this.pageSize = request.pageSize;
            this.resourceGroupId = request.resourceGroupId;
            this.searchMode = request.searchMode;
            this.starmark = request.starmark;
        }

        public Builder groupId(String groupId) {
            this.putQueryParameter("GroupId", groupId);
            this.groupId = groupId;
            return this;
        }

        public Builder keyWord(String keyWord) {
            this.putQueryParameter("KeyWord", keyWord);
            this.keyWord = keyWord;
            return this;
        }

        public Builder lang(String lang) {
            this.putQueryParameter("Lang", lang);
            this.lang = lang;
            return this;
        }

        public Builder pageNumber(Long pageNumber) {
            this.putQueryParameter("PageNumber", pageNumber);
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder pageSize(Long pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder resourceGroupId(String resourceGroupId) {
            this.putQueryParameter("ResourceGroupId", resourceGroupId);
            this.resourceGroupId = resourceGroupId;
            return this;
        }

        public Builder searchMode(String searchMode) {
            this.putQueryParameter("SearchMode", searchMode);
            this.searchMode = searchMode;
            return this;
        }

        public Builder starmark(Boolean starmark) {
            this.putQueryParameter("Starmark", starmark);
            this.starmark = starmark;
            return this;
        }

        public DescribeDomainsRequest build() {
            return new DescribeDomainsRequest(this);
        }
    }
}

