/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.alidns20150109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class DescribeRecordLogsRequest
extends Request {
    @Query
    @NameInMap(value="DomainName")
    @Validation(required=true)
    private String domainName;
    @Query
    @NameInMap(value="KeyWord")
    private String keyWord;
    @Query
    @NameInMap(value="Lang")
    private String lang;
    @Query
    @NameInMap(value="PageNumber")
    private Long pageNumber;
    @Query
    @NameInMap(value="PageSize")
    @Validation(maximum=100.0, minimum=1.0)
    private Long pageSize;
    @Query
    @NameInMap(value="StartDate")
    private String startDate;
    @Query
    @NameInMap(value="UserClientIp")
    private String userClientIp;
    @Query
    @NameInMap(value="endDate")
    private String endDate;

    private DescribeRecordLogsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.domainName = builder.domainName;
        this.keyWord = builder.keyWord;
        this.lang = builder.lang;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
        this.startDate = builder.startDate;
        this.userClientIp = builder.userClientIp;
        this.endDate = builder.endDate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DescribeRecordLogsRequest create() {
        return DescribeRecordLogsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getKeyWord() {
        return this.keyWord;
    }

    public String getLang() {
        return this.lang;
    }

    public Long getPageNumber() {
        return this.pageNumber;
    }

    public Long getPageSize() {
        return this.pageSize;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getUserClientIp() {
        return this.userClientIp;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public static final class Builder
    extends Request.Builder<DescribeRecordLogsRequest, Builder> {
        private String domainName;
        private String keyWord;
        private String lang;
        private Long pageNumber;
        private Long pageSize;
        private String startDate;
        private String userClientIp;
        private String endDate;

        private Builder() {
        }

        private Builder(DescribeRecordLogsRequest request) {
            super((Request)request);
            this.domainName = request.domainName;
            this.keyWord = request.keyWord;
            this.lang = request.lang;
            this.pageNumber = request.pageNumber;
            this.pageSize = request.pageSize;
            this.startDate = request.startDate;
            this.userClientIp = request.userClientIp;
            this.endDate = request.endDate;
        }

        public Builder domainName(String domainName) {
            this.putQueryParameter("DomainName", domainName);
            this.domainName = domainName;
            return this;
        }

        public Builder keyWord(String keyWord) {
            this.putQueryParameter("KeyWord", keyWord);
            this.keyWord = keyWord;
            return this;
        }

        public Builder lang(String lang) {
            this.putQueryParameter("Lang", lang);
            this.lang = lang;
            return this;
        }

        public Builder pageNumber(Long pageNumber) {
            this.putQueryParameter("PageNumber", pageNumber);
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder pageSize(Long pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder startDate(String startDate) {
            this.putQueryParameter("StartDate", startDate);
            this.startDate = startDate;
            return this;
        }

        public Builder userClientIp(String userClientIp) {
            this.putQueryParameter("UserClientIp", userClientIp);
            this.userClientIp = userClientIp;
            return this;
        }

        public Builder endDate(String endDate) {
            this.putQueryParameter("endDate", endDate);
            this.endDate = endDate;
            return this;
        }

        public DescribeRecordLogsRequest build() {
            return new DescribeRecordLogsRequest(this);
        }
    }
}

