/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.alidns20150109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class DescribeSubDomainRecordsRequest
extends Request {
    @Query
    @NameInMap(value="DomainName")
    private String domainName;
    @Query
    @NameInMap(value="Lang")
    private String lang;
    @Query
    @NameInMap(value="Line")
    private String line;
    @Query
    @NameInMap(value="PageNumber")
    private Long pageNumber;
    @Query
    @NameInMap(value="PageSize")
    @Validation(maximum=500.0, minimum=1.0)
    private Long pageSize;
    @Query
    @NameInMap(value="SubDomain")
    @Validation(required=true)
    private String subDomain;
    @Query
    @NameInMap(value="Type")
    private String type;
    @Query
    @NameInMap(value="UserClientIp")
    private String userClientIp;

    private DescribeSubDomainRecordsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.domainName = builder.domainName;
        this.lang = builder.lang;
        this.line = builder.line;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
        this.subDomain = builder.subDomain;
        this.type = builder.type;
        this.userClientIp = builder.userClientIp;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DescribeSubDomainRecordsRequest create() {
        return DescribeSubDomainRecordsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getLang() {
        return this.lang;
    }

    public String getLine() {
        return this.line;
    }

    public Long getPageNumber() {
        return this.pageNumber;
    }

    public Long getPageSize() {
        return this.pageSize;
    }

    public String getSubDomain() {
        return this.subDomain;
    }

    public String getType() {
        return this.type;
    }

    public String getUserClientIp() {
        return this.userClientIp;
    }

    public static final class Builder
    extends Request.Builder<DescribeSubDomainRecordsRequest, Builder> {
        private String domainName;
        private String lang;
        private String line;
        private Long pageNumber;
        private Long pageSize;
        private String subDomain;
        private String type;
        private String userClientIp;

        private Builder() {
        }

        private Builder(DescribeSubDomainRecordsRequest request) {
            super((Request)request);
            this.domainName = request.domainName;
            this.lang = request.lang;
            this.line = request.line;
            this.pageNumber = request.pageNumber;
            this.pageSize = request.pageSize;
            this.subDomain = request.subDomain;
            this.type = request.type;
            this.userClientIp = request.userClientIp;
        }

        public Builder domainName(String domainName) {
            this.putQueryParameter("DomainName", domainName);
            this.domainName = domainName;
            return this;
        }

        public Builder lang(String lang) {
            this.putQueryParameter("Lang", lang);
            this.lang = lang;
            return this;
        }

        public Builder line(String line) {
            this.putQueryParameter("Line", line);
            this.line = line;
            return this;
        }

        public Builder pageNumber(Long pageNumber) {
            this.putQueryParameter("PageNumber", pageNumber);
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder pageSize(Long pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder subDomain(String subDomain) {
            this.putQueryParameter("SubDomain", subDomain);
            this.subDomain = subDomain;
            return this;
        }

        public Builder type(String type) {
            this.putQueryParameter("Type", type);
            this.type = type;
            return this;
        }

        public Builder userClientIp(String userClientIp) {
            this.putQueryParameter("UserClientIp", userClientIp);
            this.userClientIp = userClientIp;
            return this;
        }

        public DescribeSubDomainRecordsRequest build() {
            return new DescribeSubDomainRecordsRequest(this);
        }
    }
}

