/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.alidns20150109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class DescribeTagsRequest
extends Request {
    @Query
    @NameInMap(value="Lang")
    private String lang;
    @Query
    @NameInMap(value="PageNumber")
    private Long pageNumber;
    @Query
    @NameInMap(value="PageSize")
    private Long pageSize;
    @Query
    @NameInMap(value="ResourceType")
    @Validation(required=true)
    private String resourceType;

    private DescribeTagsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.lang = builder.lang;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
        this.resourceType = builder.resourceType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DescribeTagsRequest create() {
        return DescribeTagsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getLang() {
        return this.lang;
    }

    public Long getPageNumber() {
        return this.pageNumber;
    }

    public Long getPageSize() {
        return this.pageSize;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public static final class Builder
    extends Request.Builder<DescribeTagsRequest, Builder> {
        private String lang;
        private Long pageNumber;
        private Long pageSize;
        private String resourceType;

        private Builder() {
        }

        private Builder(DescribeTagsRequest request) {
            super((Request)request);
            this.lang = request.lang;
            this.pageNumber = request.pageNumber;
            this.pageSize = request.pageSize;
            this.resourceType = request.resourceType;
        }

        public Builder lang(String lang) {
            this.putQueryParameter("Lang", lang);
            this.lang = lang;
            return this;
        }

        public Builder pageNumber(Long pageNumber) {
            this.putQueryParameter("PageNumber", pageNumber);
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder pageSize(Long pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.putQueryParameter("ResourceType", resourceType);
            this.resourceType = resourceType;
            return this;
        }

        public DescribeTagsRequest build() {
            return new DescribeTagsRequest(this);
        }
    }
}

