/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.alidns20150109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class DescribeTransferDomainsRequest
extends Request {
    @Query
    @NameInMap(value="DomainName")
    private String domainName;
    @Query
    @NameInMap(value="FromUserId")
    private Long fromUserId;
    @Query
    @NameInMap(value="Lang")
    private String lang;
    @Query
    @NameInMap(value="PageNumber")
    private Long pageNumber;
    @Query
    @NameInMap(value="PageSize")
    @Validation(maximum=100.0, minimum=1.0)
    private Long pageSize;
    @Query
    @NameInMap(value="TargetUserId")
    private Long targetUserId;
    @Query
    @NameInMap(value="TransferType")
    @Validation(required=true)
    private String transferType;

    private DescribeTransferDomainsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.domainName = builder.domainName;
        this.fromUserId = builder.fromUserId;
        this.lang = builder.lang;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
        this.targetUserId = builder.targetUserId;
        this.transferType = builder.transferType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DescribeTransferDomainsRequest create() {
        return DescribeTransferDomainsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public Long getFromUserId() {
        return this.fromUserId;
    }

    public String getLang() {
        return this.lang;
    }

    public Long getPageNumber() {
        return this.pageNumber;
    }

    public Long getPageSize() {
        return this.pageSize;
    }

    public Long getTargetUserId() {
        return this.targetUserId;
    }

    public String getTransferType() {
        return this.transferType;
    }

    public static final class Builder
    extends Request.Builder<DescribeTransferDomainsRequest, Builder> {
        private String domainName;
        private Long fromUserId;
        private String lang;
        private Long pageNumber;
        private Long pageSize;
        private Long targetUserId;
        private String transferType;

        private Builder() {
        }

        private Builder(DescribeTransferDomainsRequest request) {
            super((Request)request);
            this.domainName = request.domainName;
            this.fromUserId = request.fromUserId;
            this.lang = request.lang;
            this.pageNumber = request.pageNumber;
            this.pageSize = request.pageSize;
            this.targetUserId = request.targetUserId;
            this.transferType = request.transferType;
        }

        public Builder domainName(String domainName) {
            this.putQueryParameter("DomainName", domainName);
            this.domainName = domainName;
            return this;
        }

        public Builder fromUserId(Long fromUserId) {
            this.putQueryParameter("FromUserId", fromUserId);
            this.fromUserId = fromUserId;
            return this;
        }

        public Builder lang(String lang) {
            this.putQueryParameter("Lang", lang);
            this.lang = lang;
            return this;
        }

        public Builder pageNumber(Long pageNumber) {
            this.putQueryParameter("PageNumber", pageNumber);
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder pageSize(Long pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder targetUserId(Long targetUserId) {
            this.putQueryParameter("TargetUserId", targetUserId);
            this.targetUserId = targetUserId;
            return this;
        }

        public Builder transferType(String transferType) {
            this.putQueryParameter("TransferType", transferType);
            this.transferType = transferType;
            return this;
        }

        public DescribeTransferDomainsRequest build() {
            return new DescribeTransferDomainsRequest(this);
        }
    }
}

