/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.alidns20150109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class ReplaceCloudGtmAddressPoolAddressRequest
extends Request {
    @Query
    @NameInMap(value="AcceptLanguage")
    private String acceptLanguage;
    @Query
    @NameInMap(value="AddressPoolId")
    private String addressPoolId;
    @Query
    @NameInMap(value="Addresses")
    private List<Addresses> addresses;
    @Query
    @NameInMap(value="ClientToken")
    private String clientToken;

    private ReplaceCloudGtmAddressPoolAddressRequest(Builder builder) {
        super((Request.Builder)builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.addressPoolId = builder.addressPoolId;
        this.addresses = builder.addresses;
        this.clientToken = builder.clientToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ReplaceCloudGtmAddressPoolAddressRequest create() {
        return ReplaceCloudGtmAddressPoolAddressRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAcceptLanguage() {
        return this.acceptLanguage;
    }

    public String getAddressPoolId() {
        return this.addressPoolId;
    }

    public List<Addresses> getAddresses() {
        return this.addresses;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public static class Addresses
    extends TeaModel {
        @NameInMap(value="AddressId")
        private String addressId;
        @NameInMap(value="RequestSource")
        private List<String> requestSource;
        @NameInMap(value="SerialNumber")
        private Integer serialNumber;
        @NameInMap(value="WeightValue")
        private Integer weightValue;

        private Addresses(Builder builder) {
            this.addressId = builder.addressId;
            this.requestSource = builder.requestSource;
            this.serialNumber = builder.serialNumber;
            this.weightValue = builder.weightValue;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Addresses create() {
            return Addresses.builder().build();
        }

        public String getAddressId() {
            return this.addressId;
        }

        public List<String> getRequestSource() {
            return this.requestSource;
        }

        public Integer getSerialNumber() {
            return this.serialNumber;
        }

        public Integer getWeightValue() {
            return this.weightValue;
        }

        public static final class Builder {
            private String addressId;
            private List<String> requestSource;
            private Integer serialNumber;
            private Integer weightValue;

            private Builder() {
            }

            private Builder(Addresses model) {
                this.addressId = model.addressId;
                this.requestSource = model.requestSource;
                this.serialNumber = model.serialNumber;
                this.weightValue = model.weightValue;
            }

            public Builder addressId(String addressId) {
                this.addressId = addressId;
                return this;
            }

            public Builder requestSource(List<String> requestSource) {
                this.requestSource = requestSource;
                return this;
            }

            public Builder serialNumber(Integer serialNumber) {
                this.serialNumber = serialNumber;
                return this;
            }

            public Builder weightValue(Integer weightValue) {
                this.weightValue = weightValue;
                return this;
            }

            public Addresses build() {
                return new Addresses(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<ReplaceCloudGtmAddressPoolAddressRequest, Builder> {
        private String acceptLanguage;
        private String addressPoolId;
        private List<Addresses> addresses;
        private String clientToken;

        private Builder() {
        }

        private Builder(ReplaceCloudGtmAddressPoolAddressRequest request) {
            super((Request)request);
            this.acceptLanguage = request.acceptLanguage;
            this.addressPoolId = request.addressPoolId;
            this.addresses = request.addresses;
            this.clientToken = request.clientToken;
        }

        public Builder acceptLanguage(String acceptLanguage) {
            this.putQueryParameter("AcceptLanguage", acceptLanguage);
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public Builder addressPoolId(String addressPoolId) {
            this.putQueryParameter("AddressPoolId", addressPoolId);
            this.addressPoolId = addressPoolId;
            return this;
        }

        public Builder addresses(List<Addresses> addresses) {
            String addressesShrink = this.shrink(addresses, "Addresses", "json");
            this.putQueryParameter("Addresses", addressesShrink);
            this.addresses = addresses;
            return this;
        }

        public Builder clientToken(String clientToken) {
            this.putQueryParameter("ClientToken", clientToken);
            this.clientToken = clientToken;
            return this;
        }

        public ReplaceCloudGtmAddressPoolAddressRequest build() {
            return new ReplaceCloudGtmAddressPoolAddressRequest(this);
        }
    }
}

