/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.alidns20150109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class ReplaceCloudGtmInstanceConfigAddressPoolRequest
extends Request {
    @Query
    @NameInMap(value="AcceptLanguage")
    private String acceptLanguage;
    @Query
    @NameInMap(value="AddressPools")
    private List<AddressPools> addressPools;
    @Query
    @NameInMap(value="ClientToken")
    private String clientToken;
    @Query
    @NameInMap(value="ConfigId")
    private String configId;
    @Query
    @NameInMap(value="InstanceId")
    private String instanceId;

    private ReplaceCloudGtmInstanceConfigAddressPoolRequest(Builder builder) {
        super((Request.Builder)builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.addressPools = builder.addressPools;
        this.clientToken = builder.clientToken;
        this.configId = builder.configId;
        this.instanceId = builder.instanceId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ReplaceCloudGtmInstanceConfigAddressPoolRequest create() {
        return ReplaceCloudGtmInstanceConfigAddressPoolRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAcceptLanguage() {
        return this.acceptLanguage;
    }

    public List<AddressPools> getAddressPools() {
        return this.addressPools;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public String getConfigId() {
        return this.configId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public static class AddressPools
    extends TeaModel {
        @NameInMap(value="AddressPoolId")
        private String addressPoolId;
        @NameInMap(value="RequestSource")
        private List<String> requestSource;
        @NameInMap(value="SerialNumber")
        private Integer serialNumber;
        @NameInMap(value="WeightValue")
        private Integer weightValue;

        private AddressPools(Builder builder) {
            this.addressPoolId = builder.addressPoolId;
            this.requestSource = builder.requestSource;
            this.serialNumber = builder.serialNumber;
            this.weightValue = builder.weightValue;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static AddressPools create() {
            return AddressPools.builder().build();
        }

        public String getAddressPoolId() {
            return this.addressPoolId;
        }

        public List<String> getRequestSource() {
            return this.requestSource;
        }

        public Integer getSerialNumber() {
            return this.serialNumber;
        }

        public Integer getWeightValue() {
            return this.weightValue;
        }

        public static final class Builder {
            private String addressPoolId;
            private List<String> requestSource;
            private Integer serialNumber;
            private Integer weightValue;

            private Builder() {
            }

            private Builder(AddressPools model) {
                this.addressPoolId = model.addressPoolId;
                this.requestSource = model.requestSource;
                this.serialNumber = model.serialNumber;
                this.weightValue = model.weightValue;
            }

            public Builder addressPoolId(String addressPoolId) {
                this.addressPoolId = addressPoolId;
                return this;
            }

            public Builder requestSource(List<String> requestSource) {
                this.requestSource = requestSource;
                return this;
            }

            public Builder serialNumber(Integer serialNumber) {
                this.serialNumber = serialNumber;
                return this;
            }

            public Builder weightValue(Integer weightValue) {
                this.weightValue = weightValue;
                return this;
            }

            public AddressPools build() {
                return new AddressPools(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<ReplaceCloudGtmInstanceConfigAddressPoolRequest, Builder> {
        private String acceptLanguage;
        private List<AddressPools> addressPools;
        private String clientToken;
        private String configId;
        private String instanceId;

        private Builder() {
        }

        private Builder(ReplaceCloudGtmInstanceConfigAddressPoolRequest request) {
            super((Request)request);
            this.acceptLanguage = request.acceptLanguage;
            this.addressPools = request.addressPools;
            this.clientToken = request.clientToken;
            this.configId = request.configId;
            this.instanceId = request.instanceId;
        }

        public Builder acceptLanguage(String acceptLanguage) {
            this.putQueryParameter("AcceptLanguage", acceptLanguage);
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public Builder addressPools(List<AddressPools> addressPools) {
            String addressPoolsShrink = this.shrink(addressPools, "AddressPools", "json");
            this.putQueryParameter("AddressPools", addressPoolsShrink);
            this.addressPools = addressPools;
            return this;
        }

        public Builder clientToken(String clientToken) {
            this.putQueryParameter("ClientToken", clientToken);
            this.clientToken = clientToken;
            return this;
        }

        public Builder configId(String configId) {
            this.putQueryParameter("ConfigId", configId);
            this.configId = configId;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.putQueryParameter("InstanceId", instanceId);
            this.instanceId = instanceId;
            return this;
        }

        public ReplaceCloudGtmInstanceConfigAddressPoolRequest build() {
            return new ReplaceCloudGtmInstanceConfigAddressPoolRequest(this);
        }
    }
}

