/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.alidns20150109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class SearchCloudGtmMonitorTemplatesRequest
extends Request {
    @Query
    @NameInMap(value="AcceptLanguage")
    private String acceptLanguage;
    @Query
    @NameInMap(value="IpVersion")
    private String ipVersion;
    @Query
    @NameInMap(value="Name")
    private String name;
    @Query
    @NameInMap(value="PageNumber")
    @Validation(required=true)
    private Integer pageNumber;
    @Query
    @NameInMap(value="PageSize")
    @Validation(required=true)
    private Integer pageSize;
    @Query
    @NameInMap(value="Protocol")
    private String protocol;

    private SearchCloudGtmMonitorTemplatesRequest(Builder builder) {
        super((Request.Builder)builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.ipVersion = builder.ipVersion;
        this.name = builder.name;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
        this.protocol = builder.protocol;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SearchCloudGtmMonitorTemplatesRequest create() {
        return SearchCloudGtmMonitorTemplatesRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAcceptLanguage() {
        return this.acceptLanguage;
    }

    public String getIpVersion() {
        return this.ipVersion;
    }

    public String getName() {
        return this.name;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public static final class Builder
    extends Request.Builder<SearchCloudGtmMonitorTemplatesRequest, Builder> {
        private String acceptLanguage;
        private String ipVersion;
        private String name;
        private Integer pageNumber;
        private Integer pageSize;
        private String protocol;

        private Builder() {
        }

        private Builder(SearchCloudGtmMonitorTemplatesRequest request) {
            super((Request)request);
            this.acceptLanguage = request.acceptLanguage;
            this.ipVersion = request.ipVersion;
            this.name = request.name;
            this.pageNumber = request.pageNumber;
            this.pageSize = request.pageSize;
            this.protocol = request.protocol;
        }

        public Builder acceptLanguage(String acceptLanguage) {
            this.putQueryParameter("AcceptLanguage", acceptLanguage);
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public Builder ipVersion(String ipVersion) {
            this.putQueryParameter("IpVersion", ipVersion);
            this.ipVersion = ipVersion;
            return this;
        }

        public Builder name(String name) {
            this.putQueryParameter("Name", name);
            this.name = name;
            return this;
        }

        public Builder pageNumber(Integer pageNumber) {
            this.putQueryParameter("PageNumber", pageNumber);
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder protocol(String protocol) {
            this.putQueryParameter("Protocol", protocol);
            this.protocol = protocol;
            return this;
        }

        public SearchCloudGtmMonitorTemplatesRequest build() {
            return new SearchCloudGtmMonitorTemplatesRequest(this);
        }
    }
}

