/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.alidns20150109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class TransferDomainRequest
extends Request {
    @Query
    @NameInMap(value="DomainNames")
    @Validation(required=true)
    private String domainNames;
    @Query
    @NameInMap(value="Lang")
    private String lang;
    @Query
    @NameInMap(value="Remark")
    private String remark;
    @Query
    @NameInMap(value="TargetUserId")
    @Validation(required=true)
    private Long targetUserId;

    private TransferDomainRequest(Builder builder) {
        super((Request.Builder)builder);
        this.domainNames = builder.domainNames;
        this.lang = builder.lang;
        this.remark = builder.remark;
        this.targetUserId = builder.targetUserId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static TransferDomainRequest create() {
        return TransferDomainRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getDomainNames() {
        return this.domainNames;
    }

    public String getLang() {
        return this.lang;
    }

    public String getRemark() {
        return this.remark;
    }

    public Long getTargetUserId() {
        return this.targetUserId;
    }

    public static final class Builder
    extends Request.Builder<TransferDomainRequest, Builder> {
        private String domainNames;
        private String lang;
        private String remark;
        private Long targetUserId;

        private Builder() {
        }

        private Builder(TransferDomainRequest request) {
            super((Request)request);
            this.domainNames = request.domainNames;
            this.lang = request.lang;
            this.remark = request.remark;
            this.targetUserId = request.targetUserId;
        }

        public Builder domainNames(String domainNames) {
            this.putQueryParameter("DomainNames", domainNames);
            this.domainNames = domainNames;
            return this;
        }

        public Builder lang(String lang) {
            this.putQueryParameter("Lang", lang);
            this.lang = lang;
            return this;
        }

        public Builder remark(String remark) {
            this.putQueryParameter("Remark", remark);
            this.remark = remark;
            return this;
        }

        public Builder targetUserId(Long targetUserId) {
            this.putQueryParameter("TargetUserId", targetUserId);
            this.targetUserId = targetUserId;
            return this;
        }

        public TransferDomainRequest build() {
            return new TransferDomainRequest(this);
        }
    }
}

