/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.alidns20150109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class UpdateCloudGtmAddressRequest
extends Request {
    @Query
    @NameInMap(value="AcceptLanguage")
    private String acceptLanguage;
    @Query
    @NameInMap(value="Address")
    private String address;
    @Query
    @NameInMap(value="AddressId")
    @Validation(required=true)
    private String addressId;
    @Query
    @NameInMap(value="AttributeInfo")
    private String attributeInfo;
    @Query
    @NameInMap(value="ClientToken")
    private String clientToken;
    @Query
    @NameInMap(value="HealthJudgement")
    private String healthJudgement;
    @Query
    @NameInMap(value="HealthTasks")
    private List<HealthTasks> healthTasks;
    @Query
    @NameInMap(value="Name")
    private String name;

    private UpdateCloudGtmAddressRequest(Builder builder) {
        super((Request.Builder)builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.address = builder.address;
        this.addressId = builder.addressId;
        this.attributeInfo = builder.attributeInfo;
        this.clientToken = builder.clientToken;
        this.healthJudgement = builder.healthJudgement;
        this.healthTasks = builder.healthTasks;
        this.name = builder.name;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateCloudGtmAddressRequest create() {
        return UpdateCloudGtmAddressRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAcceptLanguage() {
        return this.acceptLanguage;
    }

    public String getAddress() {
        return this.address;
    }

    public String getAddressId() {
        return this.addressId;
    }

    public String getAttributeInfo() {
        return this.attributeInfo;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public String getHealthJudgement() {
        return this.healthJudgement;
    }

    public List<HealthTasks> getHealthTasks() {
        return this.healthTasks;
    }

    public String getName() {
        return this.name;
    }

    public static class HealthTasks
    extends TeaModel {
        @NameInMap(value="Port")
        private Integer port;
        @NameInMap(value="TemplateId")
        private String templateId;

        private HealthTasks(Builder builder) {
            this.port = builder.port;
            this.templateId = builder.templateId;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static HealthTasks create() {
            return HealthTasks.builder().build();
        }

        public Integer getPort() {
            return this.port;
        }

        public String getTemplateId() {
            return this.templateId;
        }

        public static final class Builder {
            private Integer port;
            private String templateId;

            private Builder() {
            }

            private Builder(HealthTasks model) {
                this.port = model.port;
                this.templateId = model.templateId;
            }

            public Builder port(Integer port) {
                this.port = port;
                return this;
            }

            public Builder templateId(String templateId) {
                this.templateId = templateId;
                return this;
            }

            public HealthTasks build() {
                return new HealthTasks(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<UpdateCloudGtmAddressRequest, Builder> {
        private String acceptLanguage;
        private String address;
        private String addressId;
        private String attributeInfo;
        private String clientToken;
        private String healthJudgement;
        private List<HealthTasks> healthTasks;
        private String name;

        private Builder() {
        }

        private Builder(UpdateCloudGtmAddressRequest request) {
            super((Request)request);
            this.acceptLanguage = request.acceptLanguage;
            this.address = request.address;
            this.addressId = request.addressId;
            this.attributeInfo = request.attributeInfo;
            this.clientToken = request.clientToken;
            this.healthJudgement = request.healthJudgement;
            this.healthTasks = request.healthTasks;
            this.name = request.name;
        }

        public Builder acceptLanguage(String acceptLanguage) {
            this.putQueryParameter("AcceptLanguage", acceptLanguage);
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public Builder address(String address) {
            this.putQueryParameter("Address", address);
            this.address = address;
            return this;
        }

        public Builder addressId(String addressId) {
            this.putQueryParameter("AddressId", addressId);
            this.addressId = addressId;
            return this;
        }

        public Builder attributeInfo(String attributeInfo) {
            this.putQueryParameter("AttributeInfo", attributeInfo);
            this.attributeInfo = attributeInfo;
            return this;
        }

        public Builder clientToken(String clientToken) {
            this.putQueryParameter("ClientToken", clientToken);
            this.clientToken = clientToken;
            return this;
        }

        public Builder healthJudgement(String healthJudgement) {
            this.putQueryParameter("HealthJudgement", healthJudgement);
            this.healthJudgement = healthJudgement;
            return this;
        }

        public Builder healthTasks(List<HealthTasks> healthTasks) {
            String healthTasksShrink = this.shrink(healthTasks, "HealthTasks", "json");
            this.putQueryParameter("HealthTasks", healthTasksShrink);
            this.healthTasks = healthTasks;
            return this;
        }

        public Builder name(String name) {
            this.putQueryParameter("Name", name);
            this.name = name;
            return this;
        }

        public UpdateCloudGtmAddressRequest build() {
            return new UpdateCloudGtmAddressRequest(this);
        }
    }
}

