/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.alidns20150109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class UpdateCloudGtmInstanceConfigAlertRequest
extends Request {
    @Query
    @NameInMap(value="AcceptLanguage")
    private String acceptLanguage;
    @Query
    @NameInMap(value="AlertConfig")
    private List<AlertConfig> alertConfig;
    @Query
    @NameInMap(value="AlertGroup")
    private List<String> alertGroup;
    @Query
    @NameInMap(value="AlertMode")
    private String alertMode;
    @Query
    @NameInMap(value="ClientToken")
    private String clientToken;
    @Query
    @NameInMap(value="ConfigId")
    private String configId;
    @Query
    @NameInMap(value="InstanceId")
    private String instanceId;

    private UpdateCloudGtmInstanceConfigAlertRequest(Builder builder) {
        super((Request.Builder)builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.alertConfig = builder.alertConfig;
        this.alertGroup = builder.alertGroup;
        this.alertMode = builder.alertMode;
        this.clientToken = builder.clientToken;
        this.configId = builder.configId;
        this.instanceId = builder.instanceId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateCloudGtmInstanceConfigAlertRequest create() {
        return UpdateCloudGtmInstanceConfigAlertRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAcceptLanguage() {
        return this.acceptLanguage;
    }

    public List<AlertConfig> getAlertConfig() {
        return this.alertConfig;
    }

    public List<String> getAlertGroup() {
        return this.alertGroup;
    }

    public String getAlertMode() {
        return this.alertMode;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public String getConfigId() {
        return this.configId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public static class AlertConfig
    extends TeaModel {
        @NameInMap(value="DingtalkNotice")
        private Boolean dingtalkNotice;
        @NameInMap(value="EmailNotice")
        private Boolean emailNotice;
        @NameInMap(value="NoticeType")
        private String noticeType;
        @NameInMap(value="SmsNotice")
        private Boolean smsNotice;

        private AlertConfig(Builder builder) {
            this.dingtalkNotice = builder.dingtalkNotice;
            this.emailNotice = builder.emailNotice;
            this.noticeType = builder.noticeType;
            this.smsNotice = builder.smsNotice;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static AlertConfig create() {
            return AlertConfig.builder().build();
        }

        public Boolean getDingtalkNotice() {
            return this.dingtalkNotice;
        }

        public Boolean getEmailNotice() {
            return this.emailNotice;
        }

        public String getNoticeType() {
            return this.noticeType;
        }

        public Boolean getSmsNotice() {
            return this.smsNotice;
        }

        public static final class Builder {
            private Boolean dingtalkNotice;
            private Boolean emailNotice;
            private String noticeType;
            private Boolean smsNotice;

            private Builder() {
            }

            private Builder(AlertConfig model) {
                this.dingtalkNotice = model.dingtalkNotice;
                this.emailNotice = model.emailNotice;
                this.noticeType = model.noticeType;
                this.smsNotice = model.smsNotice;
            }

            public Builder dingtalkNotice(Boolean dingtalkNotice) {
                this.dingtalkNotice = dingtalkNotice;
                return this;
            }

            public Builder emailNotice(Boolean emailNotice) {
                this.emailNotice = emailNotice;
                return this;
            }

            public Builder noticeType(String noticeType) {
                this.noticeType = noticeType;
                return this;
            }

            public Builder smsNotice(Boolean smsNotice) {
                this.smsNotice = smsNotice;
                return this;
            }

            public AlertConfig build() {
                return new AlertConfig(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<UpdateCloudGtmInstanceConfigAlertRequest, Builder> {
        private String acceptLanguage;
        private List<AlertConfig> alertConfig;
        private List<String> alertGroup;
        private String alertMode;
        private String clientToken;
        private String configId;
        private String instanceId;

        private Builder() {
        }

        private Builder(UpdateCloudGtmInstanceConfigAlertRequest request) {
            super((Request)request);
            this.acceptLanguage = request.acceptLanguage;
            this.alertConfig = request.alertConfig;
            this.alertGroup = request.alertGroup;
            this.alertMode = request.alertMode;
            this.clientToken = request.clientToken;
            this.configId = request.configId;
            this.instanceId = request.instanceId;
        }

        public Builder acceptLanguage(String acceptLanguage) {
            this.putQueryParameter("AcceptLanguage", acceptLanguage);
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public Builder alertConfig(List<AlertConfig> alertConfig) {
            String alertConfigShrink = this.shrink(alertConfig, "AlertConfig", "json");
            this.putQueryParameter("AlertConfig", alertConfigShrink);
            this.alertConfig = alertConfig;
            return this;
        }

        public Builder alertGroup(List<String> alertGroup) {
            String alertGroupShrink = this.shrink(alertGroup, "AlertGroup", "json");
            this.putQueryParameter("AlertGroup", alertGroupShrink);
            this.alertGroup = alertGroup;
            return this;
        }

        public Builder alertMode(String alertMode) {
            this.putQueryParameter("AlertMode", alertMode);
            this.alertMode = alertMode;
            return this;
        }

        public Builder clientToken(String clientToken) {
            this.putQueryParameter("ClientToken", clientToken);
            this.clientToken = clientToken;
            return this;
        }

        public Builder configId(String configId) {
            this.putQueryParameter("ConfigId", configId);
            this.configId = configId;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.putQueryParameter("InstanceId", instanceId);
            this.instanceId = instanceId;
            return this;
        }

        public UpdateCloudGtmInstanceConfigAlertRequest build() {
            return new UpdateCloudGtmInstanceConfigAlertRequest(this);
        }
    }
}

