/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.alidns20150109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class UpdateCloudGtmMonitorTemplateRequest
extends Request {
    @Query
    @NameInMap(value="AcceptLanguage")
    private String acceptLanguage;
    @Query
    @NameInMap(value="ClientToken")
    private String clientToken;
    @Query
    @NameInMap(value="EvaluationCount")
    private Integer evaluationCount;
    @Query
    @NameInMap(value="ExtendInfo")
    private String extendInfo;
    @Query
    @NameInMap(value="FailureRate")
    private Integer failureRate;
    @Query
    @NameInMap(value="Interval")
    private Integer interval;
    @Query
    @NameInMap(value="IspCityNodes")
    private List<IspCityNodes> ispCityNodes;
    @Query
    @NameInMap(value="Name")
    private String name;
    @Query
    @NameInMap(value="TemplateId")
    @Validation(required=true)
    private String templateId;
    @Query
    @NameInMap(value="Timeout")
    private Integer timeout;

    private UpdateCloudGtmMonitorTemplateRequest(Builder builder) {
        super((Request.Builder)builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.clientToken = builder.clientToken;
        this.evaluationCount = builder.evaluationCount;
        this.extendInfo = builder.extendInfo;
        this.failureRate = builder.failureRate;
        this.interval = builder.interval;
        this.ispCityNodes = builder.ispCityNodes;
        this.name = builder.name;
        this.templateId = builder.templateId;
        this.timeout = builder.timeout;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateCloudGtmMonitorTemplateRequest create() {
        return UpdateCloudGtmMonitorTemplateRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAcceptLanguage() {
        return this.acceptLanguage;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public Integer getEvaluationCount() {
        return this.evaluationCount;
    }

    public String getExtendInfo() {
        return this.extendInfo;
    }

    public Integer getFailureRate() {
        return this.failureRate;
    }

    public Integer getInterval() {
        return this.interval;
    }

    public List<IspCityNodes> getIspCityNodes() {
        return this.ispCityNodes;
    }

    public String getName() {
        return this.name;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public static class IspCityNodes
    extends TeaModel {
        @NameInMap(value="CityCode")
        private String cityCode;
        @NameInMap(value="IspCode")
        private String ispCode;

        private IspCityNodes(Builder builder) {
            this.cityCode = builder.cityCode;
            this.ispCode = builder.ispCode;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static IspCityNodes create() {
            return IspCityNodes.builder().build();
        }

        public String getCityCode() {
            return this.cityCode;
        }

        public String getIspCode() {
            return this.ispCode;
        }

        public static final class Builder {
            private String cityCode;
            private String ispCode;

            private Builder() {
            }

            private Builder(IspCityNodes model) {
                this.cityCode = model.cityCode;
                this.ispCode = model.ispCode;
            }

            public Builder cityCode(String cityCode) {
                this.cityCode = cityCode;
                return this;
            }

            public Builder ispCode(String ispCode) {
                this.ispCode = ispCode;
                return this;
            }

            public IspCityNodes build() {
                return new IspCityNodes(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<UpdateCloudGtmMonitorTemplateRequest, Builder> {
        private String acceptLanguage;
        private String clientToken;
        private Integer evaluationCount;
        private String extendInfo;
        private Integer failureRate;
        private Integer interval;
        private List<IspCityNodes> ispCityNodes;
        private String name;
        private String templateId;
        private Integer timeout;

        private Builder() {
        }

        private Builder(UpdateCloudGtmMonitorTemplateRequest request) {
            super((Request)request);
            this.acceptLanguage = request.acceptLanguage;
            this.clientToken = request.clientToken;
            this.evaluationCount = request.evaluationCount;
            this.extendInfo = request.extendInfo;
            this.failureRate = request.failureRate;
            this.interval = request.interval;
            this.ispCityNodes = request.ispCityNodes;
            this.name = request.name;
            this.templateId = request.templateId;
            this.timeout = request.timeout;
        }

        public Builder acceptLanguage(String acceptLanguage) {
            this.putQueryParameter("AcceptLanguage", acceptLanguage);
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public Builder clientToken(String clientToken) {
            this.putQueryParameter("ClientToken", clientToken);
            this.clientToken = clientToken;
            return this;
        }

        public Builder evaluationCount(Integer evaluationCount) {
            this.putQueryParameter("EvaluationCount", evaluationCount);
            this.evaluationCount = evaluationCount;
            return this;
        }

        public Builder extendInfo(String extendInfo) {
            this.putQueryParameter("ExtendInfo", extendInfo);
            this.extendInfo = extendInfo;
            return this;
        }

        public Builder failureRate(Integer failureRate) {
            this.putQueryParameter("FailureRate", failureRate);
            this.failureRate = failureRate;
            return this;
        }

        public Builder interval(Integer interval) {
            this.putQueryParameter("Interval", interval);
            this.interval = interval;
            return this;
        }

        public Builder ispCityNodes(List<IspCityNodes> ispCityNodes) {
            String ispCityNodesShrink = this.shrink(ispCityNodes, "IspCityNodes", "json");
            this.putQueryParameter("IspCityNodes", ispCityNodesShrink);
            this.ispCityNodes = ispCityNodes;
            return this;
        }

        public Builder name(String name) {
            this.putQueryParameter("Name", name);
            this.name = name;
            return this;
        }

        public Builder templateId(String templateId) {
            this.putQueryParameter("TemplateId", templateId);
            this.templateId = templateId;
            return this;
        }

        public Builder timeout(Integer timeout) {
            this.putQueryParameter("Timeout", timeout);
            this.timeout = timeout;
            return this;
        }

        public UpdateCloudGtmMonitorTemplateRequest build() {
            return new UpdateCloudGtmMonitorTemplateRequest(this);
        }
    }
}

