/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.alidns20150109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class UpdateDnsGtmAddressPoolRequest
extends Request {
    @Query
    @NameInMap(value="Addr")
    @Validation(required=true)
    private List<Addr> addr;
    @Query
    @NameInMap(value="AddrPoolId")
    @Validation(required=true)
    private String addrPoolId;
    @Query
    @NameInMap(value="Lang")
    private String lang;
    @Query
    @NameInMap(value="LbaStrategy")
    @Validation(required=true)
    private String lbaStrategy;
    @Query
    @NameInMap(value="Name")
    private String name;

    private UpdateDnsGtmAddressPoolRequest(Builder builder) {
        super((Request.Builder)builder);
        this.addr = builder.addr;
        this.addrPoolId = builder.addrPoolId;
        this.lang = builder.lang;
        this.lbaStrategy = builder.lbaStrategy;
        this.name = builder.name;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateDnsGtmAddressPoolRequest create() {
        return UpdateDnsGtmAddressPoolRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<Addr> getAddr() {
        return this.addr;
    }

    public String getAddrPoolId() {
        return this.addrPoolId;
    }

    public String getLang() {
        return this.lang;
    }

    public String getLbaStrategy() {
        return this.lbaStrategy;
    }

    public String getName() {
        return this.name;
    }

    public static class Addr
    extends TeaModel {
        @NameInMap(value="Addr")
        @Validation(required=true)
        private String addr;
        @NameInMap(value="AttributeInfo")
        private String attributeInfo;
        @NameInMap(value="LbaWeight")
        private Integer lbaWeight;
        @NameInMap(value="Mode")
        @Validation(required=true)
        private String mode;
        @NameInMap(value="Remark")
        private String remark;

        private Addr(Builder builder) {
            this.addr = builder.addr;
            this.attributeInfo = builder.attributeInfo;
            this.lbaWeight = builder.lbaWeight;
            this.mode = builder.mode;
            this.remark = builder.remark;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Addr create() {
            return Addr.builder().build();
        }

        public String getAddr() {
            return this.addr;
        }

        public String getAttributeInfo() {
            return this.attributeInfo;
        }

        public Integer getLbaWeight() {
            return this.lbaWeight;
        }

        public String getMode() {
            return this.mode;
        }

        public String getRemark() {
            return this.remark;
        }

        public static final class Builder {
            private String addr;
            private String attributeInfo;
            private Integer lbaWeight;
            private String mode;
            private String remark;

            private Builder() {
            }

            private Builder(Addr model) {
                this.addr = model.addr;
                this.attributeInfo = model.attributeInfo;
                this.lbaWeight = model.lbaWeight;
                this.mode = model.mode;
                this.remark = model.remark;
            }

            public Builder addr(String addr) {
                this.addr = addr;
                return this;
            }

            public Builder attributeInfo(String attributeInfo) {
                this.attributeInfo = attributeInfo;
                return this;
            }

            public Builder lbaWeight(Integer lbaWeight) {
                this.lbaWeight = lbaWeight;
                return this;
            }

            public Builder mode(String mode) {
                this.mode = mode;
                return this;
            }

            public Builder remark(String remark) {
                this.remark = remark;
                return this;
            }

            public Addr build() {
                return new Addr(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<UpdateDnsGtmAddressPoolRequest, Builder> {
        private List<Addr> addr;
        private String addrPoolId;
        private String lang;
        private String lbaStrategy;
        private String name;

        private Builder() {
        }

        private Builder(UpdateDnsGtmAddressPoolRequest request) {
            super((Request)request);
            this.addr = request.addr;
            this.addrPoolId = request.addrPoolId;
            this.lang = request.lang;
            this.lbaStrategy = request.lbaStrategy;
            this.name = request.name;
        }

        public Builder addr(List<Addr> addr) {
            this.putQueryParameter("Addr", addr);
            this.addr = addr;
            return this;
        }

        public Builder addrPoolId(String addrPoolId) {
            this.putQueryParameter("AddrPoolId", addrPoolId);
            this.addrPoolId = addrPoolId;
            return this;
        }

        public Builder lang(String lang) {
            this.putQueryParameter("Lang", lang);
            this.lang = lang;
            return this;
        }

        public Builder lbaStrategy(String lbaStrategy) {
            this.putQueryParameter("LbaStrategy", lbaStrategy);
            this.lbaStrategy = lbaStrategy;
            return this;
        }

        public Builder name(String name) {
            this.putQueryParameter("Name", name);
            this.name = name;
            return this;
        }

        public UpdateDnsGtmAddressPoolRequest build() {
            return new UpdateDnsGtmAddressPoolRequest(this);
        }
    }
}

