/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.alidns20150109.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class UpdateDnsGtmInstanceGlobalConfigRequest
extends Request {
    @Query
    @NameInMap(value="AlertConfig")
    private List<AlertConfig> alertConfig;
    @Query
    @NameInMap(value="AlertGroup")
    private String alertGroup;
    @Query
    @NameInMap(value="CnameType")
    private String cnameType;
    @Query
    @NameInMap(value="ForceUpdate")
    private Boolean forceUpdate;
    @Query
    @NameInMap(value="InstanceId")
    @Validation(required=true)
    private String instanceId;
    @Query
    @NameInMap(value="InstanceName")
    private String instanceName;
    @Query
    @NameInMap(value="Lang")
    private String lang;
    @Query
    @NameInMap(value="PublicCnameMode")
    private String publicCnameMode;
    @Query
    @NameInMap(value="PublicRr")
    private String publicRr;
    @Query
    @NameInMap(value="PublicUserDomainName")
    private String publicUserDomainName;
    @Query
    @NameInMap(value="PublicZoneName")
    private String publicZoneName;
    @Query
    @NameInMap(value="Ttl")
    @Validation(maximum=9999999.0, minimum=1.0)
    private Integer ttl;

    private UpdateDnsGtmInstanceGlobalConfigRequest(Builder builder) {
        super((Request.Builder)builder);
        this.alertConfig = builder.alertConfig;
        this.alertGroup = builder.alertGroup;
        this.cnameType = builder.cnameType;
        this.forceUpdate = builder.forceUpdate;
        this.instanceId = builder.instanceId;
        this.instanceName = builder.instanceName;
        this.lang = builder.lang;
        this.publicCnameMode = builder.publicCnameMode;
        this.publicRr = builder.publicRr;
        this.publicUserDomainName = builder.publicUserDomainName;
        this.publicZoneName = builder.publicZoneName;
        this.ttl = builder.ttl;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateDnsGtmInstanceGlobalConfigRequest create() {
        return UpdateDnsGtmInstanceGlobalConfigRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<AlertConfig> getAlertConfig() {
        return this.alertConfig;
    }

    public String getAlertGroup() {
        return this.alertGroup;
    }

    public String getCnameType() {
        return this.cnameType;
    }

    public Boolean getForceUpdate() {
        return this.forceUpdate;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getLang() {
        return this.lang;
    }

    public String getPublicCnameMode() {
        return this.publicCnameMode;
    }

    public String getPublicRr() {
        return this.publicRr;
    }

    public String getPublicUserDomainName() {
        return this.publicUserDomainName;
    }

    public String getPublicZoneName() {
        return this.publicZoneName;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public static class AlertConfig
    extends TeaModel {
        @NameInMap(value="DingtalkNotice")
        private Boolean dingtalkNotice;
        @NameInMap(value="EmailNotice")
        private Boolean emailNotice;
        @NameInMap(value="NoticeType")
        private String noticeType;
        @NameInMap(value="SmsNotice")
        private Boolean smsNotice;

        private AlertConfig(Builder builder) {
            this.dingtalkNotice = builder.dingtalkNotice;
            this.emailNotice = builder.emailNotice;
            this.noticeType = builder.noticeType;
            this.smsNotice = builder.smsNotice;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static AlertConfig create() {
            return AlertConfig.builder().build();
        }

        public Boolean getDingtalkNotice() {
            return this.dingtalkNotice;
        }

        public Boolean getEmailNotice() {
            return this.emailNotice;
        }

        public String getNoticeType() {
            return this.noticeType;
        }

        public Boolean getSmsNotice() {
            return this.smsNotice;
        }

        public static final class Builder {
            private Boolean dingtalkNotice;
            private Boolean emailNotice;
            private String noticeType;
            private Boolean smsNotice;

            private Builder() {
            }

            private Builder(AlertConfig model) {
                this.dingtalkNotice = model.dingtalkNotice;
                this.emailNotice = model.emailNotice;
                this.noticeType = model.noticeType;
                this.smsNotice = model.smsNotice;
            }

            public Builder dingtalkNotice(Boolean dingtalkNotice) {
                this.dingtalkNotice = dingtalkNotice;
                return this;
            }

            public Builder emailNotice(Boolean emailNotice) {
                this.emailNotice = emailNotice;
                return this;
            }

            public Builder noticeType(String noticeType) {
                this.noticeType = noticeType;
                return this;
            }

            public Builder smsNotice(Boolean smsNotice) {
                this.smsNotice = smsNotice;
                return this;
            }

            public AlertConfig build() {
                return new AlertConfig(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<UpdateDnsGtmInstanceGlobalConfigRequest, Builder> {
        private List<AlertConfig> alertConfig;
        private String alertGroup;
        private String cnameType;
        private Boolean forceUpdate;
        private String instanceId;
        private String instanceName;
        private String lang;
        private String publicCnameMode;
        private String publicRr;
        private String publicUserDomainName;
        private String publicZoneName;
        private Integer ttl;

        private Builder() {
        }

        private Builder(UpdateDnsGtmInstanceGlobalConfigRequest request) {
            super((Request)request);
            this.alertConfig = request.alertConfig;
            this.alertGroup = request.alertGroup;
            this.cnameType = request.cnameType;
            this.forceUpdate = request.forceUpdate;
            this.instanceId = request.instanceId;
            this.instanceName = request.instanceName;
            this.lang = request.lang;
            this.publicCnameMode = request.publicCnameMode;
            this.publicRr = request.publicRr;
            this.publicUserDomainName = request.publicUserDomainName;
            this.publicZoneName = request.publicZoneName;
            this.ttl = request.ttl;
        }

        public Builder alertConfig(List<AlertConfig> alertConfig) {
            this.putQueryParameter("AlertConfig", alertConfig);
            this.alertConfig = alertConfig;
            return this;
        }

        public Builder alertGroup(String alertGroup) {
            this.putQueryParameter("AlertGroup", alertGroup);
            this.alertGroup = alertGroup;
            return this;
        }

        public Builder cnameType(String cnameType) {
            this.putQueryParameter("CnameType", cnameType);
            this.cnameType = cnameType;
            return this;
        }

        public Builder forceUpdate(Boolean forceUpdate) {
            this.putQueryParameter("ForceUpdate", forceUpdate);
            this.forceUpdate = forceUpdate;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.putQueryParameter("InstanceId", instanceId);
            this.instanceId = instanceId;
            return this;
        }

        public Builder instanceName(String instanceName) {
            this.putQueryParameter("InstanceName", instanceName);
            this.instanceName = instanceName;
            return this;
        }

        public Builder lang(String lang) {
            this.putQueryParameter("Lang", lang);
            this.lang = lang;
            return this;
        }

        public Builder publicCnameMode(String publicCnameMode) {
            this.putQueryParameter("PublicCnameMode", publicCnameMode);
            this.publicCnameMode = publicCnameMode;
            return this;
        }

        public Builder publicRr(String publicRr) {
            this.putQueryParameter("PublicRr", publicRr);
            this.publicRr = publicRr;
            return this;
        }

        public Builder publicUserDomainName(String publicUserDomainName) {
            this.putQueryParameter("PublicUserDomainName", publicUserDomainName);
            this.publicUserDomainName = publicUserDomainName;
            return this;
        }

        public Builder publicZoneName(String publicZoneName) {
            this.putQueryParameter("PublicZoneName", publicZoneName);
            this.publicZoneName = publicZoneName;
            return this;
        }

        public Builder ttl(Integer ttl) {
            this.putQueryParameter("Ttl", ttl);
            this.ttl = ttl;
            return this;
        }

        public UpdateDnsGtmInstanceGlobalConfigRequest build() {
            return new UpdateDnsGtmInstanceGlobalConfigRequest(this);
        }
    }
}

